/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.GovernanceProgramCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceOfficerHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.PersonalProfileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceProgramRESTServices {
    private static GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(GovernanceProgramRESTServices.class);

    public GUIDResponse createPersonalProfile(String serverName, String userId, PersonalDetailsRequestBody requestBody) {
        String methodName = "createPersonalProfile";
        log.debug("Calling method: createPersonalProfile");
        GUIDResponse response = new GUIDResponse();
        try {
            String profileUserId = null;
            String employeeNumber = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                profileUserId = requestBody.getUserId();
                employeeNumber = requestBody.getEmployeeNumber();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            PersonalProfileHandler handler = new PersonalProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(handler.createPersonalProfile(userId, profileUserId, employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: createPersonalProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse updatePersonalProfile(String serverName, String userId, String profileGUID, PersonalDetailsRequestBody requestBody) {
        String methodName = "updatePersonalProfile";
        log.debug("Calling method: updatePersonalProfile");
        VoidResponse response = new VoidResponse();
        try {
            String employeeNumber = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getEmployeeNumber();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            PersonalProfileHandler handler = new PersonalProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.updatePersonalProfile(userId, profileGUID, employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updatePersonalProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse deletePersonalProfile(String serverName, String userId, String profileGUID, PersonalProfileValidatorRequestBody requestBody) {
        String methodName = "deletePersonalProfile";
        log.debug("Calling method: deletePersonalProfile");
        VoidResponse response = new VoidResponse();
        try {
            String employeeNumber = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getEmployeeNumber();
            }
            PersonalProfileHandler handler = new PersonalProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.deletePersonalProfile(userId, profileGUID, employeeNumber);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: deletePersonalProfile with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByGUID(String serverName, String userId, String profileGUID) {
        String methodName = "getPersonalProfileByGUID";
        log.debug("Calling method: getPersonalProfileByGUID");
        PersonalProfileResponse response = new PersonalProfileResponse();
        try {
            PersonalProfileHandler handler = new PersonalProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setPersonalProfile(handler.getPersonalProfileByGUID(userId, profileGUID));
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getPersonalProfileByGUID with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByEmployeeNumber(String serverName, String userId, String employeeNumber) {
        String methodName = "getPersonalProfileByEmployeeNumber";
        log.debug("Calling method: getPersonalProfileByEmployeeNumber");
        PersonalProfileResponse response = new PersonalProfileResponse();
        try {
            PersonalProfileHandler handler = new PersonalProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setPersonalProfile(handler.getPersonalProfileByEmployeeNumber(userId, employeeNumber));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (EmployeeNumberNotUniqueException error) {
            this.captureEmployeeNumberNotUniqueException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getPersonalProfileByEmployeeNumber with response: " + response.toString());
        return response;
    }

    public PersonalProfileListResponse getPersonalProfilesByName(String serverName, String userId, String name) {
        String methodName = "getPersonalProfilesByName";
        log.debug("Calling method: getPersonalProfilesByName");
        PersonalProfileListResponse response = new PersonalProfileListResponse();
        try {
            PersonalProfileHandler handler = new PersonalProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setPersonalProfiles(handler.getPersonalProfilesByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getPersonalProfilesByName with response: " + response.toString());
        return response;
    }

    public GUIDResponse createGovernanceOfficer(String serverName, String userId, GovernanceOfficerDetailsRequestBody requestBody) {
        String methodName = "createGovernanceOfficer";
        log.debug("Calling method: createGovernanceOfficer");
        GUIDResponse response = new GUIDResponse();
        GovernanceDomain governanceDomain = null;
        String appointmentId = null;
        String appointmentContext = null;
        String title = null;
        Map additionalProperties = null;
        List externalReferences = null;
        if (requestBody != null) {
            governanceDomain = requestBody.getGovernanceDomain();
            appointmentId = requestBody.getAppointmentId();
            appointmentContext = requestBody.getAppointmentContext();
            title = requestBody.getTitle();
            additionalProperties = requestBody.getAdditionalProperties();
            externalReferences = requestBody.getExternalReferences();
        }
        try {
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGUID(handler.createGovernanceOfficer(userId, governanceDomain, appointmentId, appointmentContext, title, additionalProperties, externalReferences));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: createGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse updateGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, GovernanceOfficerDetailsRequestBody requestBody) {
        String methodName = "updateGovernanceOfficer";
        log.debug("Calling method: updateGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        GovernanceDomain governanceDomain = null;
        String appointmentId = null;
        String appointmentContext = null;
        String title = null;
        Map additionalProperties = null;
        List externalReferences = null;
        if (requestBody != null) {
            governanceDomain = requestBody.getGovernanceDomain();
            appointmentId = requestBody.getAppointmentId();
            appointmentContext = requestBody.getAppointmentContext();
            title = requestBody.getTitle();
            additionalProperties = requestBody.getAdditionalProperties();
            externalReferences = requestBody.getExternalReferences();
        }
        try {
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.updateGovernanceOfficer(userId, governanceOfficerGUID, governanceDomain, appointmentId, appointmentContext, title, additionalProperties, externalReferences);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updateGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, GovernanceOfficerValidatorRequestBody requestBody) {
        String methodName = "deleteGovernanceOfficer";
        log.debug("Calling method: deleteGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        try {
            GovernanceDomain governanceDomain = null;
            String appointmentId = null;
            if (requestBody != null) {
                governanceDomain = requestBody.getGovernanceDomain();
                appointmentId = requestBody.getAppointmentId();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.deleteGovernanceOfficer(userId, governanceOfficerGUID, appointmentId, governanceDomain);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: deleteGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerResponse getGovernanceOfficerByGUID(String serverName, String userId, String governanceOfficerGUID) {
        String methodName = "getGovernanceOfficerByGUID";
        log.debug("Calling method: getGovernanceOfficerByGUID");
        GovernanceOfficerResponse response = new GovernanceOfficerResponse();
        try {
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGovernanceOfficer(handler.getGovernanceOfficerByGUID(userId, governanceOfficerGUID));
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficerByGUID with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerResponse getGovernanceOfficerByAppointmentId(String serverName, String userId, String appointmentId) {
        String methodName = "getGovernanceOfficerByAppointmentId";
        log.debug("Calling method: getGovernanceOfficerByAppointmentId");
        GovernanceOfficerResponse response = new GovernanceOfficerResponse();
        try {
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGovernanceOfficer(handler.getGovernanceOfficerByAppointmentId(userId, appointmentId));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (AppointmentIdNotUniqueException error) {
            this.captureAppointmentIdNotUniqueException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficerByAppointmentId with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getGovernanceOfficers(String serverName, String userId) {
        String methodName = "getGovernanceOfficers";
        log.debug("Calling method: getGovernanceOfficers");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        try {
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGovernanceOfficers(handler.getGovernanceOfficers(userId));
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficers with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getActiveGovernanceOfficers(String serverName, String userId) {
        String methodName = "getActiveGovernanceOfficers";
        log.debug("Calling method: getActiveGovernanceOfficers");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        try {
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGovernanceOfficers(handler.getActiveGovernanceOfficers(userId));
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getActiveGovernanceOfficers with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getGovernanceOfficersByDomain(String serverName, String userId, GovernanceDomainRequestBody requestBody) {
        String methodName = "getGovernanceOfficersByDomain";
        log.debug("Calling method: getGovernanceOfficersByDomain");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        try {
            GovernanceDomain governanceDomain = null;
            if (requestBody != null) {
                governanceDomain = requestBody.getGovernanceDomain();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setGovernanceOfficers(handler.getGovernanceOfficersByDomain(userId, governanceDomain));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficersByDomain with response: " + response.toString());
        return response;
    }

    public VoidResponse appointGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, AppointmentRequestBody requestBody) {
        String methodName = "appointGovernanceOfficer";
        log.debug("Calling method: appointGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        try {
            String profileGUID = null;
            Date startDate = null;
            if (requestBody != null) {
                profileGUID = requestBody.getGUID();
                startDate = requestBody.getEffectiveDate();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.appointGovernanceOfficer(userId, governanceOfficerGUID, profileGUID, startDate);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: appointGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse relieveGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, AppointmentRequestBody requestBody) {
        String methodName = "relieveGovernanceOfficer";
        log.debug("Calling method: relieveGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        try {
            String profileGUID = null;
            Date endDate = null;
            if (requestBody != null) {
                profileGUID = requestBody.getGUID();
                endDate = requestBody.getEffectiveDate();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.relieveGovernanceOfficer(userId, governanceOfficerGUID, profileGUID, endDate);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: relieveGovernanceOfficer with response: " + response.toString());
        return response;
    }

    private void captureCheckedException(GovernanceProgramOMASAPIResponse response, GovernanceProgramCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(GovernanceProgramOMASAPIResponse response, GovernanceProgramCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        this.captureCheckedException(response, error, exceptionClassName);
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureUnrecognizedGUIDException(GovernanceProgramOMASAPIResponse response, UnrecognizedGUIDException error) {
        String guid = error.getGUID();
        String expectedTypeName = error.getExpectedTypeName();
        if (guid != null || expectedTypeName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("guid", guid);
            exceptionProperties.put("expectedTypeName", expectedTypeName);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
        this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(GovernanceProgramOMASAPIResponse response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureEmployeeNumberNotUniqueException(GovernanceProgramOMASAPIResponse response, EmployeeNumberNotUniqueException error) {
        List duplicateProfiles = error.getDuplicateProfiles();
        if (duplicateProfiles != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("duplicateProfiles", duplicateProfiles);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureAppointmentIdNotUniqueException(GovernanceProgramOMASAPIResponse response, AppointmentIdNotUniqueException error) {
        List duplicatePosts = error.getDuplicatePosts();
        if (duplicatePosts != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("duplicatePosts", duplicatePosts);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void capturePropertyServerException(GovernanceProgramOMASAPIResponse response, PropertyServerException error) {
        this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureUserNotAuthorizedException(GovernanceProgramOMASAPIResponse response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }
}

