/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.GovernanceAppointeeNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.ExternalReferencesHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.GovernanceProgramEnumHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.PersonalProfileHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficer;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficerAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceOfficerHandler {
    private static final String governanceOfficerTypeGUID = "578a3510-9ad3-45fe-8ada-e4e9572c37c8";
    private static final String governanceOfficerTypeName = "GovernanceOfficer";
    private static final String appointmentIdPropertyName = "qualifiedName";
    private static final String titlePropertyName = "title";
    private static final String appointmentContextPropertyName = "scope";
    private static final String governanceDomainPropertyName = "domain";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String governancePostTypeGUID = "4c4d1d0c-a9fc-4305-8b71-4e691c0f9ae0";
    private static final String governancePostTypeName = "GovernancePost";
    private static final String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
    private static final String governanceDomainParameterName = "governanceDomain";
    private static final String appointmentIdParameterName = "appointmentId";
    private static final String titleParameterName = "title";
    private static final String profileGUIDParameterName = "profileGUID";
    private static final Logger log = LoggerFactory.getLogger(GovernanceOfficerHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private GovernanceProgramEnumHandler enumHandler;
    private PersonalProfileHandler personalProfileHandler;
    private ExternalReferencesHandler externalReferencesHandler;
    private RESTExceptionHandler errorHandler = new RESTExceptionHandler();

    public GovernanceOfficerHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, PersonalProfileHandler personalProfileHandler, ExternalReferencesHandler externalReferencesHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.enumHandler = new GovernanceProgramEnumHandler(serviceName, repositoryHelper);
        this.personalProfileHandler = personalProfileHandler;
        this.externalReferencesHandler = externalReferencesHandler;
    }

    private InstanceProperties createGovernanceOfficerProperties(String methodName, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties) throws InvalidParameterException {
        this.invalidParameterHandler.validateEnum((Object)governanceDomain, governanceDomainParameterName, methodName);
        this.invalidParameterHandler.validateName(appointmentId, appointmentIdParameterName, methodName);
        this.invalidParameterHandler.validateName(title, "title", methodName);
        InstanceProperties properties = this.enumHandler.addGovernanceDomainToProperties(null, governanceDomain, governanceDomainPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, appointmentIdPropertyName, appointmentId, methodName);
        if (appointmentContext != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, appointmentContextPropertyName, appointmentContext, methodName);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "title", title, methodName);
        if (additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, additionalPropertiesName, additionalProperties, methodName);
        }
        log.debug("Instance properties: " + properties.toString());
        return properties;
    }

    private GovernanceOfficer getGovernanceOfficerFromInstances(EntityDetail governanceOfficerEntity, String userId, String methodName) throws PropertyServerException {
        GovernanceOfficer governanceOfficer = null;
        long now = new Date().getTime();
        if (governanceOfficerEntity != null) {
            governanceOfficer = new GovernanceOfficer();
            governanceOfficer.setGUID(governanceOfficerEntity.getGUID());
            governanceOfficer.setType(governanceOfficerTypeName);
            InstanceProperties instanceProperties = governanceOfficerEntity.getProperties();
            if (instanceProperties != null) {
                governanceOfficer.setAppointmentId(this.repositoryHelper.getStringProperty(this.serviceName, appointmentIdPropertyName, instanceProperties, methodName));
                governanceOfficer.setAppointmentContext(this.repositoryHelper.getStringProperty(this.serviceName, appointmentContextPropertyName, instanceProperties, methodName));
                governanceOfficer.setTitle(this.repositoryHelper.getStringProperty(this.serviceName, "title", instanceProperties, methodName));
                governanceOfficer.setGovernanceDomain(this.enumHandler.getGovernanceDomainFromProperties(instanceProperties, governanceDomainPropertyName, methodName));
                governanceOfficer.setAdditionalProperties(this.repositoryHelper.getStringMapFromProperty(this.serviceName, additionalPropertiesName, instanceProperties, methodName));
            }
            try {
                List relationships = this.repositoryHandler.getRelationshipsByType(userId, governanceOfficerEntity.getGUID(), governanceOfficerTypeName, governancePostTypeGUID, governancePostTypeName, methodName);
                if (relationships != null) {
                    List<GovernanceOfficerAppointee> currentIncumbents = this.getCurrentIncumbents(relationships, now, userId);
                    if (currentIncumbents == null) {
                        governanceOfficer.setAppointee(null);
                    } else if (currentIncumbents.size() == 1) {
                        governanceOfficer.setAppointee(currentIncumbents.get(0));
                    } else {
                        GovernanceDomain governanceDomain = governanceOfficer.getGovernanceDomain();
                        if (governanceDomain == null) {
                            governanceDomain = GovernanceDomain.OTHER;
                        }
                        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.MULTIPLE_INCUMBENTS_FOR_GOVERNANCE_OFFICER;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governanceDomain.getName(), governanceOfficer.getGUID(), governanceOfficer.getAppointmentId(), governanceOfficer.getAppointmentContext(), Integer.toString(currentIncumbents.size())});
                        throw new GovernanceAppointeeNotUniqueException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), currentIncumbents);
                    }
                    governanceOfficer.setPredecessors(this.getPredecessors(relationships, now, userId));
                    governanceOfficer.setSuccessors(this.getSuccessors(relationships, now, userId));
                }
            }
            catch (Throwable error) {
                this.errorHandler.handleUnexpectedException(error, methodName, this.serverName, this.serviceName);
            }
            log.debug("Retrieved governance officer: " + governanceOfficer.toString());
        } else {
            log.debug("Null governance officer entity");
        }
        return governanceOfficer;
    }

    private GovernanceOfficerAppointee getAppointee(String governancePostGUID, String personalProfileGUID, String userId, Date startDate, Date endDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PersonalProfile personalProfile = this.personalProfileHandler.getPersonalProfileByGUID(userId, personalProfileGUID);
        GovernanceOfficerAppointee appointee = new GovernanceOfficerAppointee();
        appointee.setGUID(governancePostGUID);
        appointee.setType(governancePostTypeName);
        appointee.setProfile(personalProfile);
        appointee.setStartDate(startDate);
        appointee.setEndDate(endDate);
        return appointee;
    }

    private List<GovernanceOfficerAppointee> getPredecessors(List<Relationship> governancePostings, long now, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<GovernanceOfficerAppointee> appointees = new ArrayList<GovernanceOfficerAppointee>();
        if (governancePostings != null) {
            for (Relationship governancePost : governancePostings) {
                if (governancePost == null) continue;
                Date endDate = null;
                Date startDate = null;
                InstanceProperties properties = governancePost.getProperties();
                if (properties != null) {
                    endDate = properties.getEffectiveToTime();
                    startDate = properties.getEffectiveFromTime();
                }
                if (endDate == null || endDate.getTime() >= now) continue;
                String personalProfileGUID = null;
                if (governancePost.getEntityTwoProxy() != null) {
                    personalProfileGUID = governancePost.getEntityTwoProxy().getGUID();
                }
                appointees.add(this.getAppointee(governancePost.getGUID(), personalProfileGUID, userId, startDate, endDate));
            }
        }
        if (appointees.isEmpty()) {
            return null;
        }
        return appointees;
    }

    private List<GovernanceOfficerAppointee> getCurrentIncumbents(List<Relationship> governancePostings, long now, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<GovernanceOfficerAppointee> appointees = new ArrayList<GovernanceOfficerAppointee>();
        if (governancePostings != null) {
            for (Relationship governancePost : governancePostings) {
                if (governancePost == null) continue;
                Date endDate = null;
                Date startDate = null;
                InstanceProperties properties = governancePost.getProperties();
                if (properties != null) {
                    endDate = properties.getEffectiveToTime();
                    startDate = properties.getEffectiveFromTime();
                }
                if (startDate != null && startDate.getTime() > now || endDate != null && endDate.getTime() < now) continue;
                String personalProfileGUID = null;
                if (governancePost.getEntityTwoProxy() != null) {
                    personalProfileGUID = governancePost.getEntityTwoProxy().getGUID();
                }
                appointees.add(this.getAppointee(governancePost.getGUID(), personalProfileGUID, userId, startDate, endDate));
            }
        }
        if (appointees.isEmpty()) {
            return null;
        }
        return appointees;
    }

    private List<GovernanceOfficerAppointee> getSuccessors(List<Relationship> governancePostings, long now, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<GovernanceOfficerAppointee> appointees = new ArrayList<GovernanceOfficerAppointee>();
        if (governancePostings != null) {
            for (Relationship governancePost : governancePostings) {
                if (governancePost == null) continue;
                Date endDate = null;
                Date startDate = null;
                InstanceProperties properties = governancePost.getProperties();
                if (properties != null) {
                    endDate = properties.getEffectiveToTime();
                    startDate = properties.getEffectiveFromTime();
                }
                if (startDate == null || startDate.getTime() <= now) continue;
                String personalProfileGUID = null;
                if (governancePost.getEntityTwoProxy() != null) {
                    personalProfileGUID = governancePost.getEntityTwoProxy().getGUID();
                }
                appointees.add(this.getAppointee(governancePost.getGUID(), personalProfileGUID, userId, startDate, endDate));
            }
        }
        if (appointees.isEmpty()) {
            return null;
        }
        return appointees;
    }

    public String createGovernanceOfficer(String userId, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createGovernanceOfficer";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceOfficer");
        InstanceProperties properties = this.createGovernanceOfficerProperties("createGovernanceOfficer", governanceDomain, appointmentId, appointmentContext, title, additionalProperties);
        String governanceOfficerGUID = this.repositoryHandler.createEntity(userId, governanceOfficerTypeGUID, governanceOfficerTypeName, properties, "createGovernanceOfficer");
        if (governanceOfficerGUID != null) {
            log.debug("New governance officer entity: " + governanceOfficerGUID);
            if (externalReferences != null) {
                this.externalReferencesHandler.storeExternalReferences(userId, governanceOfficerGUID, externalReferences);
            }
        }
        return governanceOfficerGUID;
    }

    public void updateGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateGovernanceOfficer";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, "updateGovernanceOfficer");
        InstanceProperties properties = this.createGovernanceOfficerProperties("updateGovernanceOfficer", governanceDomain, appointmentId, appointmentContext, title, additionalProperties);
        this.repositoryHandler.updateEntity(userId, governanceOfficerGUID, governanceOfficerTypeGUID, governanceOfficerTypeName, properties, "updateGovernanceOfficer");
        this.externalReferencesHandler.storeExternalReferences(userId, governanceOfficerGUID, externalReferences);
        log.debug("Update of governance officer successful: " + governanceOfficerGUID);
    }

    public void deleteGovernanceOfficer(String userId, String governanceOfficerGUID, String appointmentId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteGovernanceOfficer";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, appointmentIdParameterName, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateEnum((Object)governanceDomain, governanceDomainParameterName, "deleteGovernanceOfficer");
        this.repositoryHandler.removeEntity(userId, governanceOfficerGUID, governanceOfficerTypeGUID, governanceOfficerTypeName, appointmentIdPropertyName, appointmentId, "deleteGovernanceOfficer");
        log.debug("Delete of governance officers successful: " + governanceOfficerGUID);
    }

    public GovernanceOfficer getGovernanceOfficerByGUID(String userId, String governanceOfficerGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficerByGUID");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, "getGovernanceOfficerByGUID");
        EntityDetail governanceOfficerEntity = this.repositoryHandler.getEntityByGUID(userId, governanceOfficerGUID, governanceOfficerGUIDParameterName, governanceOfficerTypeName, "getGovernanceOfficerByGUID");
        return this.getGovernanceOfficerFromInstances(governanceOfficerEntity, userId, "getGovernanceOfficerByGUID");
    }

    public GovernanceOfficer getGovernanceOfficerByAppointmentId(String userId, String appointmentId) throws InvalidParameterException, PropertyServerException, AppointmentIdNotUniqueException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByAppointmentId";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficerByAppointmentId");
        this.invalidParameterHandler.validateName(appointmentId, appointmentIdParameterName, "getGovernanceOfficerByAppointmentId");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, appointmentIdPropertyName, appointmentId, "getGovernanceOfficerByAppointmentId");
        List governanceOfficerEntities = this.repositoryHandler.getEntityByName(userId, properties, governanceOfficerTypeGUID, "getGovernanceOfficerByAppointmentId");
        if (governanceOfficerEntities == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.GOVERNANCE_OFFICER_NOT_FOUND_BY_APPOINTMENT_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{appointmentId});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceOfficerByAppointmentId", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), appointmentId);
        }
        if (governanceOfficerEntities.size() != 1) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.DUPLICATE_GOVERNANCE_OFFICER_FOR_APPOINTMENT_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{appointmentId});
            throw new AppointmentIdNotUniqueException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceOfficerByAppointmentId", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), governanceOfficerEntities);
        }
        return this.getGovernanceOfficerFromInstances((EntityDetail)governanceOfficerEntities.get(0), userId, "getGovernanceOfficerByAppointmentId");
    }

    public List<GovernanceOfficer> getGovernanceOfficers(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficers");
        List governanceOfficerEntities = this.repositoryHandler.getEntityByType(userId, governanceOfficerTypeGUID, 0, this.invalidParameterHandler.getMaxPagingSize(), "getGovernanceOfficers");
        if (governanceOfficerEntities != null) {
            ArrayList<GovernanceOfficer> governanceOfficers = new ArrayList<GovernanceOfficer>();
            for (EntityDetail governanceOfficerEntity : governanceOfficerEntities) {
                governanceOfficers.add(this.getGovernanceOfficerFromInstances(governanceOfficerEntity, userId, "getGovernanceOfficers"));
            }
            if (governanceOfficers.isEmpty()) {
                log.debug("No governance officers");
                return null;
            }
            log.debug(governanceOfficers.size() + " governance officers");
            return governanceOfficers;
        }
        log.debug("Null return from method: getGovernanceOfficers");
        return null;
    }

    public List<GovernanceOfficer> getActiveGovernanceOfficers(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getActiveGovernanceOfficers";
        List<GovernanceOfficer> fullList = this.getGovernanceOfficers(userId);
        ArrayList<GovernanceOfficer> returnList = new ArrayList<GovernanceOfficer>();
        for (GovernanceOfficer governanceOfficer : fullList) {
            if (governanceOfficer == null || governanceOfficer.getAppointee() == null) continue;
            returnList.add(governanceOfficer);
        }
        if (returnList.isEmpty()) {
            log.debug("No governance officers for method: getActiveGovernanceOfficers");
            return null;
        }
        log.debug(returnList.size() + " active governance officers");
        return returnList;
    }

    public List<GovernanceOfficer> getGovernanceOfficersByDomain(String userId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficersByDomain";
        this.invalidParameterHandler.validateEnum((Object)governanceDomain, governanceDomainParameterName, "getGovernanceOfficersByDomain");
        List<GovernanceOfficer> fullList = this.getGovernanceOfficers(userId);
        ArrayList<GovernanceOfficer> returnList = new ArrayList<GovernanceOfficer>();
        for (GovernanceOfficer governanceOfficer : fullList) {
            if (governanceOfficer == null || governanceOfficer.getGovernanceDomain() != governanceDomain) continue;
            returnList.add(governanceOfficer);
        }
        if (returnList.isEmpty()) {
            log.debug("Null return from method: getGovernanceOfficersByDomain");
            return null;
        }
        log.debug(returnList.size() + " governance officers for domain: " + governanceDomain);
        return returnList;
    }

    public void appointGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date startDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "appointGovernanceOfficer";
        this.invalidParameterHandler.validateUserId(userId, "appointGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, "appointGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(profileGUID, profileGUIDParameterName, "appointGovernanceOfficer");
        GovernanceOfficer governanceOfficer = this.getGovernanceOfficerByGUID(userId, governanceOfficerGUID);
        Date endDate = null;
        Date now = new Date();
        Date actualStartDate = startDate;
        if (actualStartDate == null) {
            actualStartDate = now;
        }
        if (governanceOfficer.getSuccessors() != null) {
            for (GovernanceOfficerAppointee successor : governanceOfficer.getSuccessors()) {
                if (endDate == null) {
                    endDate = successor.getStartDate();
                    continue;
                }
                if (successor.getStartDate() == null || endDate.getTime() <= successor.getStartDate().getTime()) continue;
                endDate = successor.getStartDate();
            }
        }
        if (governanceOfficer.getAppointee() != null) {
            if (governanceOfficer.getAppointee().getProfile() != null) {
                try {
                    Date incumbentEndDate = new Date(actualStartDate.getTime() - 1L);
                    this.relieveGovernanceOfficer(userId, governanceOfficerGUID, governanceOfficer.getAppointee().getProfile().getGUID(), incumbentEndDate);
                }
                catch (Throwable error) {
                    GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.FREE_ROLE_FOR_APPOINTMENT_FAILED;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage()});
                    throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "appointGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
                }
            } else {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NO_PROFILE_FOR_GOVERNANCE_POST;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governanceOfficerGUID, governanceOfficer.getAppointee().getGUID()});
                throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "appointGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        InstanceProperties properties = new InstanceProperties();
        properties.setEffectiveFromTime(startDate);
        properties.setEffectiveToTime(endDate);
        this.repositoryHandler.createRelationship(userId, governancePostTypeGUID, governanceOfficerGUID, profileGUID, properties, "appointGovernanceOfficer");
    }

    public void relieveGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date endDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List governancePosts;
        String methodName = "relieveGovernanceOfficer";
        this.invalidParameterHandler.validateUserId(userId, "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(profileGUID, profileGUIDParameterName, "relieveGovernanceOfficer");
        Date actualEndDate = endDate;
        if (actualEndDate == null) {
            actualEndDate = new Date();
        }
        if ((governancePosts = this.repositoryHandler.getRelationshipsByType(userId, governanceOfficerGUID, governanceOfficerTypeName, governancePostTypeGUID, governancePostTypeName, "relieveGovernanceOfficer")) == null || governancePosts.isEmpty()) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PROFILE_NOT_LINKED_TO_GOVERNANCE_OFFICER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{profileGUID, governanceOfficerGUID});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "relieveGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), profileGUIDParameterName);
        }
        Relationship relievedPost = null;
        for (Relationship governancePost : governancePosts) {
            if (governancePost == null) continue;
            EntityProxy appointeeProxy = governancePost.getEntityTwoProxy();
            if (appointeeProxy != null) {
                if (!profileGUID.equals(appointeeProxy.getGUID())) continue;
                if (relievedPost == null) {
                    relievedPost = governancePost;
                    continue;
                }
                Date governancePostEndDate = null;
                Date relievedPostEndDate = null;
                if (governancePost.getProperties() != null) {
                    governancePostEndDate = governancePost.getProperties().getEffectiveToTime();
                }
                if (relievedPost.getProperties() != null) {
                    relievedPostEndDate = relievedPost.getProperties().getEffectiveToTime();
                }
                if (relievedPostEndDate == null || governancePostEndDate != null && governancePostEndDate.getTime() <= relievedPostEndDate.getTime()) continue;
                relievedPost = governancePost;
                continue;
            }
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.INVALID_GOVERNANCE_POST_RELATIONSHIP;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governancePost.toString()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "relieveGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (relievedPost == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PROFILE_NOT_LINKED_TO_GOVERNANCE_OFFICER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{profileGUID, governanceOfficerGUID});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "relieveGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), profileGUIDParameterName);
        }
        InstanceProperties properties = relievedPost.getProperties();
        if (properties == null) {
            properties = new InstanceProperties();
        }
        properties.setEffectiveToTime(actualEndDate);
        this.repositoryHandler.updateRelationshipProperties(userId, relievedPost.getGUID(), properties, "relieveGovernanceOfficer");
    }
}

