/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.admin;

import org.odpi.openmetadata.accessservices.governanceprogram.auditlog.GovernanceProgramAuditCode;
import org.odpi.openmetadata.accessservices.governanceprogram.listener.GovernanceProgramOMRSTopicListener;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceProgramAdmin
extends AccessServiceAdmin {
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSTopicConnector omrsTopicConnector = null;
    private AccessServiceConfig accessServiceConfig = null;
    private OMRSAuditLog auditLog = null;
    private GovernanceProgramServicesInstance instance = null;
    private String serverName = null;
    private String serverUserName = null;
    private GovernanceProgramOMRSTopicListener omrsTopicListener = null;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        GovernanceProgramAuditCode auditCode = GovernanceProgramAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.auditLog = auditLog;
            this.repositoryConnector = enterpriseOMRSRepositoryConnector;
            this.instance = new GovernanceProgramServicesInstance(this.repositoryConnector, auditLog, this.serverName, enterpriseOMRSRepositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            this.accessServiceConfig = accessServiceConfigurationProperties;
            this.omrsTopicConnector = enterpriseOMRSTopicConnector;
            this.serverUserName = serverUserName;
            if (this.accessServiceConfig.getAccessServiceOutTopic() != null) {
                GovernanceProgramOMRSTopicListener omrsTopicListener = new GovernanceProgramOMRSTopicListener(this.accessServiceConfig.getAccessServiceOutTopic(), this.repositoryConnector.getRepositoryHelper(), this.repositoryConnector.getRepositoryValidator(), this.accessServiceConfig.getAccessServiceName());
                super.registerWithEnterpriseTopic(this.accessServiceConfig.getAccessServiceName(), this.serverName, this.omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditCode = GovernanceProgramAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfigurationProperties.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (Throwable error) {
            auditCode = GovernanceProgramAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfigurationProperties.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        GovernanceProgramAuditCode auditCode = GovernanceProgramAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

