/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.handlers.GovernanceZoneHandler;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.ZoneListResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.ZoneRequestBody;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.ZoneResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class GovernanceZoneRESTServices {
    private static GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceZoneRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse createGovernanceZone(String serverName, String userId, ZoneRequestBody requestBody) {
        String methodName = "createGovernanceZone";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceZone");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceZone");
                GovernanceZoneHandler handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "createGovernanceZone");
                handler.createGovernanceZone(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCriteria(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createGovernanceZone");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceZone", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createGovernanceZone", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ZoneListResponse getGovernanceZones(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getGovernanceZones";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZones");
        ZoneListResponse response = new ZoneListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZones");
            GovernanceZoneHandler handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZones");
            response.setGovernanceZone(handler.getGovernanceZones(userId, startingFrom, maximumResults, "getGovernanceZones"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getGovernanceZones", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ZoneResponse getGovernanceZone(String serverName, String userId, String qualifiedName) {
        String methodName = "getGovernanceZone";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZone");
        ZoneResponse response = new ZoneResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZone");
            GovernanceZoneHandler handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZone");
            response.setGovernanceZone(handler.getGovernanceZone(userId, qualifiedName, "getGovernanceZone"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getGovernanceZone", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

