/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import org.odpi.openmetadata.accessservices.governanceprogram.converters.GovernanceZoneConverter;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.ExternalReferencesHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.GovernanceOfficerHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.PersonalProfileHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneElement;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceZoneHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceProgramServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS;
    private GovernanceZoneHandler<GovernanceZoneElement> governanceZoneHandler;
    private GovernanceOfficerHandler governanceOfficerHandler;
    private ExternalReferencesHandler externalReferencesHandler;
    private PersonalProfileHandler personalProfileHandler;

    public GovernanceProgramServicesInstance(OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(GovernanceProgramErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.governanceZoneHandler = new GovernanceZoneHandler(new GovernanceZoneConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceZoneElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.externalReferencesHandler = new ExternalReferencesHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
        this.personalProfileHandler = new PersonalProfileHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler);
        this.governanceOfficerHandler = new GovernanceOfficerHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.personalProfileHandler, this.externalReferencesHandler);
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        throw new NewInstanceException(GovernanceProgramErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition(new String[]{"getServerName"}), ((Object)((Object)this)).getClass().getName(), "getServerName");
    }

    GovernanceOfficerHandler getGovernanceOfficerHandler() {
        return this.governanceOfficerHandler;
    }

    ExternalReferencesHandler getExternalReferencesHandler() {
        return this.externalReferencesHandler;
    }

    PersonalProfileHandler getPersonalProfileHandler() {
        return this.personalProfileHandler;
    }

    GovernanceZoneHandler<GovernanceZoneElement> getGovernanceZoneHandler() {
        return this.governanceZoneHandler;
    }
}

