/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.handlers;

import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalProfileHandler {
    private static final String personalDetailsTypeGUID = "ac406bf8-e53e-49f1-9088-2af28bbbd285";
    private static final String personalDetailsTypeName = "Person";
    private static final String employeeNumberPropertyName = "qualifiedName";
    private static final String fullNamePropertyName = "fullName";
    private static final String knownNamePropertyName = "name";
    private static final String jobTitlePropertyName = "jobTitle";
    private static final String jobDescriptionPropertyName = "description";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String profileGUIDParameterName = "profileGUID";
    private static final String employeeNumberParameterName = "employeeNumber";
    private static final String knownNameParameterName = "knownName";
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;

    public PersonalProfileHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String guidParameter = profileGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateGUID(profileGUID, profileGUIDParameterName, "getPersonalProfileByGUID");
        PersonalProfile personalProfile = null;
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, profileGUID, profileGUIDParameterName, personalDetailsTypeName, "getPersonalProfileByGUID");
        if (entity != null) {
            personalProfile = new PersonalProfile();
            personalProfile.setGUID(entity.getGUID());
            InstanceType instanceType = entity.getType();
            if (instanceType != null) {
                personalProfile.setType(instanceType.getTypeDefName());
            } else {
                personalProfile.setType(personalDetailsTypeName);
            }
            InstanceProperties instanceProperties = entity.getProperties();
            if (instanceProperties != null) {
                personalProfile.setEmployeeNumber(this.repositoryHelper.getStringProperty(this.serviceName, employeeNumberPropertyName, instanceProperties, "getPersonalProfileByGUID"));
                personalProfile.setFullName(this.repositoryHelper.getStringProperty(this.serviceName, fullNamePropertyName, instanceProperties, "getPersonalProfileByGUID"));
                personalProfile.setKnownName(this.repositoryHelper.getStringProperty(this.serviceName, knownNamePropertyName, instanceProperties, "getPersonalProfileByGUID"));
                personalProfile.setJobTitle(this.repositoryHelper.getStringProperty(this.serviceName, jobTitlePropertyName, instanceProperties, "getPersonalProfileByGUID"));
                personalProfile.setJobRoleDescription(this.repositoryHelper.getStringProperty(this.serviceName, jobDescriptionPropertyName, instanceProperties, "getPersonalProfileByGUID"));
                personalProfile.setAdditionalProperties(this.repositoryHelper.getStringMapFromProperty(this.serviceName, additionalPropertiesName, instanceProperties, "getPersonalProfileByGUID"));
            }
            log.debug("Personal details: " + personalProfile.toString());
        } else {
            log.debug("Personal details: <null>");
        }
        return personalProfile;
    }
}

