/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.GovernanceProgramCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.GovernanceOfficerHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceProgramRESTServices {
    private static GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(GovernanceProgramRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceOfficer(String serverName, String userId, GovernanceOfficerDetailsRequestBody requestBody) {
        String methodName = "createGovernanceOfficer";
        log.debug("Calling method: createGovernanceOfficer");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        GovernanceDomain governanceDomain = null;
        String appointmentId = null;
        String appointmentContext = null;
        String title = null;
        Map additionalProperties = null;
        List externalReferences = null;
        if (requestBody != null) {
            governanceDomain = requestBody.getGovernanceDomain();
            appointmentId = requestBody.getAppointmentId();
            appointmentContext = requestBody.getAppointmentContext();
            title = requestBody.getTitle();
            additionalProperties = requestBody.getAdditionalProperties();
            externalReferences = requestBody.getExternalReferences();
        }
        try {
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "createGovernanceOfficer");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceOfficer");
            response.setGUID(handler.createGovernanceOfficer(userId, governanceDomain, appointmentId, appointmentContext, title, additionalProperties, externalReferences));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGovernanceOfficer", auditLog);
        }
        log.debug("Returning from method: createGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse updateGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, GovernanceOfficerDetailsRequestBody requestBody) {
        String methodName = "updateGovernanceOfficer";
        log.debug("Calling method: updateGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        GovernanceDomain governanceDomain = null;
        String appointmentId = null;
        String appointmentContext = null;
        String title = null;
        Map additionalProperties = null;
        List externalReferences = null;
        if (requestBody != null) {
            governanceDomain = requestBody.getGovernanceDomain();
            appointmentId = requestBody.getAppointmentId();
            appointmentContext = requestBody.getAppointmentContext();
            title = requestBody.getTitle();
            additionalProperties = requestBody.getAdditionalProperties();
            externalReferences = requestBody.getExternalReferences();
        }
        try {
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "updateGovernanceOfficer");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceOfficer");
            handler.updateGovernanceOfficer(userId, governanceOfficerGUID, governanceDomain, appointmentId, appointmentContext, title, additionalProperties, externalReferences);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateGovernanceOfficer", auditLog);
        }
        log.debug("Returning from method: updateGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, GovernanceOfficerValidatorRequestBody requestBody) {
        String methodName = "deleteGovernanceOfficer";
        log.debug("Calling method: deleteGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceDomain governanceDomain = null;
            String appointmentId = null;
            if (requestBody != null) {
                governanceDomain = requestBody.getGovernanceDomain();
                appointmentId = requestBody.getAppointmentId();
            }
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "deleteGovernanceOfficer");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceOfficer");
            handler.deleteGovernanceOfficer(userId, governanceOfficerGUID, appointmentId, governanceDomain);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteGovernanceOfficer", auditLog);
        }
        log.debug("Returning from method: deleteGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerResponse getGovernanceOfficerByGUID(String serverName, String userId, String governanceOfficerGUID) {
        String methodName = "getGovernanceOfficerByGUID";
        log.debug("Calling method: getGovernanceOfficerByGUID");
        GovernanceOfficerResponse response = new GovernanceOfficerResponse();
        AuditLog auditLog = null;
        try {
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "getGovernanceOfficerByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceOfficerByGUID");
            response.setGovernanceOfficer(handler.getGovernanceOfficerByGUID(userId, governanceOfficerGUID));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGovernanceOfficerByGUID", auditLog);
        }
        log.debug("Returning from method: getGovernanceOfficerByGUID with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerResponse getGovernanceOfficerByAppointmentId(String serverName, String userId, String appointmentId) {
        String methodName = "getGovernanceOfficerByAppointmentId";
        log.debug("Calling method: getGovernanceOfficerByAppointmentId");
        GovernanceOfficerResponse response = new GovernanceOfficerResponse();
        AuditLog auditLog = null;
        try {
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "getGovernanceOfficerByAppointmentId");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceOfficerByAppointmentId");
            response.setGovernanceOfficer(handler.getGovernanceOfficerByAppointmentId(userId, appointmentId));
        }
        catch (AppointmentIdNotUniqueException error) {
            this.captureAppointmentIdNotUniqueException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGovernanceOfficerByAppointmentId", auditLog);
        }
        log.debug("Returning from method: getGovernanceOfficerByAppointmentId with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getGovernanceOfficers(String serverName, String userId) {
        String methodName = "getGovernanceOfficers";
        log.debug("Calling method: getGovernanceOfficers");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "getGovernanceOfficers");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceOfficers");
            response.setGovernanceOfficers(handler.getGovernanceOfficers(userId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGovernanceOfficers", auditLog);
        }
        log.debug("Returning from method: getGovernanceOfficers with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getActiveGovernanceOfficers(String serverName, String userId) {
        String methodName = "getActiveGovernanceOfficers";
        log.debug("Calling method: getActiveGovernanceOfficers");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "getActiveGovernanceOfficers");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveGovernanceOfficers");
            response.setGovernanceOfficers(handler.getActiveGovernanceOfficers(userId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getActiveGovernanceOfficers", auditLog);
        }
        log.debug("Returning from method: getActiveGovernanceOfficers with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getGovernanceOfficersByDomain(String serverName, String userId, GovernanceDomainRequestBody requestBody) {
        String methodName = "getGovernanceOfficersByDomain";
        log.debug("Calling method: getGovernanceOfficersByDomain");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceDomain governanceDomain = null;
            if (requestBody != null) {
                governanceDomain = requestBody.getGovernanceDomain();
            }
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "getGovernanceOfficersByDomain");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceOfficersByDomain");
            response.setGovernanceOfficers(handler.getGovernanceOfficersByDomain(userId, governanceDomain));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGovernanceOfficersByDomain", auditLog);
        }
        log.debug("Returning from method: getGovernanceOfficersByDomain with response: " + response.toString());
        return response;
    }

    public VoidResponse appointGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, AppointmentRequestBody requestBody) {
        String methodName = "appointGovernanceOfficer";
        log.debug("Calling method: appointGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String profileGUID = null;
            Date startDate = null;
            if (requestBody != null) {
                profileGUID = requestBody.getGUID();
                startDate = requestBody.getEffectiveDate();
            }
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "appointGovernanceOfficer");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "appointGovernanceOfficer");
            handler.appointGovernanceOfficer(userId, governanceOfficerGUID, profileGUID, startDate);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "appointGovernanceOfficer", auditLog);
        }
        log.debug("Returning from method: appointGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse relieveGovernanceOfficer(String serverName, String userId, String governanceOfficerGUID, AppointmentRequestBody requestBody) {
        String methodName = "relieveGovernanceOfficer";
        log.debug("Calling method: relieveGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String profileGUID = null;
            Date endDate = null;
            if (requestBody != null) {
                profileGUID = requestBody.getGUID();
                endDate = requestBody.getEffectiveDate();
            }
            GovernanceOfficerHandler handler = instanceHandler.getGovernanceOfficerHandler(userId, serverName, "relieveGovernanceOfficer");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "relieveGovernanceOfficer");
            handler.relieveGovernanceOfficer(userId, governanceOfficerGUID, profileGUID, endDate);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "relieveGovernanceOfficer", auditLog);
        }
        log.debug("Returning from method: relieveGovernanceOfficer with response: " + response.toString());
        return response;
    }

    private void captureCheckedException(GovernanceProgramOMASAPIResponse response, GovernanceProgramCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getReportedErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(GovernanceProgramOMASAPIResponse response, GovernanceProgramCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        this.captureCheckedException(response, error, exceptionClassName);
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureEmployeeNumberNotUniqueException(GovernanceProgramOMASAPIResponse response, EmployeeNumberNotUniqueException error) {
        List duplicateProfiles = error.getDuplicateProfiles();
        if (duplicateProfiles != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("duplicateProfiles", duplicateProfiles);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, error.getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, error.getClass().getName());
        }
    }

    private void captureAppointmentIdNotUniqueException(GovernanceProgramOMASAPIResponse response, AppointmentIdNotUniqueException error) {
        List duplicatePosts = error.getDuplicatePosts();
        if (duplicatePosts != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("duplicatePosts", duplicatePosts);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }
}

