/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDomainElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDomainSetElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainSetListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainSetResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.CollectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDomainHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class GovernanceDomainRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceDomainRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceDomainSet(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createGovernanceDomainSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceDomainSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceDomainSetProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceDomainSet");
                    CollectionHandler<GovernanceDomainSetElement> handler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "createGovernanceDomainSet");
                    GovernanceDomainSetProperties properties = (GovernanceDomainSetProperties)requestBody.getProperties();
                    String setGUID = handler.createCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), "GovernanceDomainSet", properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createGovernanceDomainSet");
                    response.setGUID(setGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDomainSetProperties.class.getName(), "createGovernanceDomainSet");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceDomainSet", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceDomainSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceDomainSet(String serverName, String userId, String governanceDomainSetGUID, ReferenceableRequestBody requestBody) {
        String methodName = "updateGovernanceDomainSet";
        String guidParameter = "governanceDomainSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceDomainSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceDomainSetProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceDomainSet");
                    CollectionHandler<GovernanceDomainSetElement> handler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "updateGovernanceDomainSet");
                    GovernanceDomainSetProperties properties = (GovernanceDomainSetProperties)requestBody.getProperties();
                    handler.updateCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDomainSetGUID, "governanceDomainSetGUID", properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, false, new Date(), "updateGovernanceDomainSet");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDomainSetProperties.class.getName(), "updateGovernanceDomainSet");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceDomainSet", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceDomainSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceDomainSet(String serverName, String userId, String governanceDomainSetGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeGovernanceDomainSet";
        String guidParameter = "governanceDomainSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceDomainSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceDomainSet");
            CollectionHandler<GovernanceDomainSetElement> setHandler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "removeGovernanceDomainSet");
            if (requestBody != null) {
                setHandler.removeCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDomainSetGUID, "governanceDomainSetGUID", false, false, new Date(), "removeGovernanceDomainSet");
            } else {
                setHandler.removeCollection(userId, null, null, governanceDomainSetGUID, "governanceDomainSetGUID", false, false, new Date(), "removeGovernanceDomainSet");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceDomainSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainSetListResponse findGovernanceDomainSets(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceDomainSets";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceDomainSets");
        GovernanceDomainSetListResponse response = new GovernanceDomainSetListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceDomainSets");
                CollectionHandler<GovernanceDomainSetElement> handler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "findGovernanceDomainSets");
                List sets = handler.findCollections(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findGovernanceDomainSets");
                this.addDomainsToSets(userId, sets, instanceHandler.getGovernanceDomainHandler(userId, serverName, "findGovernanceDomainSets"), "findGovernanceDomainSets");
                response.setElements(sets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceDomainSets", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceDomainSets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainSetListResponse getGovernanceDomainSetsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceDomainSetsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDomainSetsByName");
        GovernanceDomainSetListResponse response = new GovernanceDomainSetListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDomainSetsByName");
                CollectionHandler<GovernanceDomainSetElement> handler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "getGovernanceDomainSetsByName");
                List sets = handler.findCollections(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getGovernanceDomainSetsByName");
                this.addDomainsToSets(userId, sets, instanceHandler.getGovernanceDomainHandler(userId, serverName, "getGovernanceDomainSetsByName"), "getGovernanceDomainSetsByName");
                response.setElements(sets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceDomainSetsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDomainSetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainSetResponse getGovernanceDomainSetByGUID(String serverName, String userId, String governanceDomainSetGUID) {
        String methodName = "getGovernanceDomainSetByGUID";
        String guidParameterName = "governanceDomainSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDomainSetByGUID");
        GovernanceDomainSetResponse response = new GovernanceDomainSetResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDomainSetByGUID");
            CollectionHandler<GovernanceDomainSetElement> handler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "getGovernanceDomainSetByGUID");
            GovernanceDomainSetElement set = (GovernanceDomainSetElement)handler.getCollectionByGUID(userId, governanceDomainSetGUID, "governanceDomainSetGUID", false, false, new Date(), "getGovernanceDomainSetByGUID");
            this.addDomainsToSet(userId, set, instanceHandler.getGovernanceDomainHandler(userId, serverName, "getGovernanceDomainSetByGUID"), "getGovernanceDomainSetByGUID");
            response.setElement(set);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDomainSetByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceDomain(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createGovernanceDomain";
        String setGUIDParameter = "setGUID";
        String domainGUIDParameter = "domainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceDomain");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceDomainProperties) {
                    GovernanceDomainProperties properties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceDomain");
                    GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "createGovernanceDomain");
                    String domainGUID = domainHandler.createGovernanceDomain(userId, (properties = (GovernanceDomainProperties)requestBody.getProperties()).getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), new Date(), "createGovernanceDomain");
                    if (domainGUID != null) {
                        CollectionHandler<GovernanceDomainSetElement> setHandler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "createGovernanceDomain");
                        setHandler.addMemberToCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), "setGUID", domainGUID, "domainGUID", null, properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "createGovernanceDomain");
                    }
                    response.setGUID(domainGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDomainProperties.class.getName(), "createGovernanceDomain");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceDomain", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceDomain(String serverName, String userId, String governanceDomainGUID, ReferenceableRequestBody requestBody) {
        String methodName = "updateGovernanceDomain";
        String guidParameter = "governanceDomainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceDomain");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceDomainProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceDomain");
                    GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "updateGovernanceDomain");
                    GovernanceDomainProperties properties = (GovernanceDomainProperties)requestBody.getProperties();
                    domainHandler.updateGovernanceDomain(userId, governanceDomainGUID, "governanceDomainGUID", properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), "updateGovernanceDomain");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDomainProperties.class.getName(), "updateGovernanceDomain");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceDomain", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceDomain(String serverName, String userId, String governanceDomainGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteGovernanceDomain";
        String guidParameter = "governanceDomainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceDomain");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceDomain");
            GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "deleteGovernanceDomain");
            domainHandler.removeGovernanceDomain(userId, governanceDomainGUID, "governanceDomainGUID", "deleteGovernanceDomain");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addDomainToSet(String serverName, String userId, String governanceDomainSetGUID, String governanceDomainGUID, RelationshipRequestBody requestBody) {
        String methodName = "addDomainToSet";
        String guid1Parameter = "governanceDomainSetGUID";
        String guid2Parameter = "governanceDomainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDomainToSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDomainToSet");
            CollectionHandler<GovernanceDomainSetElement> setHandler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "addDomainToSet");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    setHandler.addMemberToCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDomainSetGUID, "governanceDomainSetGUID", governanceDomainGUID, "governanceDomainGUID", null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "addDomainToSet");
                } else {
                    setHandler.addMemberToCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDomainSetGUID, "governanceDomainSetGUID", governanceDomainGUID, "governanceDomainGUID", null, null, null, false, false, new Date(), "addDomainToSet");
                }
            } else {
                setHandler.addMemberToCollection(userId, null, null, governanceDomainSetGUID, "governanceDomainSetGUID", governanceDomainGUID, "governanceDomainGUID", null, null, null, false, false, new Date(), "addDomainToSet");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addDomainToSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDomainFromSet(String serverName, String userId, String governanceDomainSetGUID, String governanceDomainGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeDomainFromSet";
        String guid1Parameter = "governanceDomainSetGUID";
        String guid2Parameter = "governanceDomainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDomainFromSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDomainFromSet");
            CollectionHandler<GovernanceDomainSetElement> setHandler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "removeDomainFromSet");
            if (requestBody != null) {
                setHandler.removeMemberFromCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDomainSetGUID, "governanceDomainSetGUID", governanceDomainGUID, "governanceDomainGUID", false, false, new Date(), "removeDomainFromSet");
            } else {
                setHandler.removeMemberFromCollection(userId, null, null, governanceDomainSetGUID, "governanceDomainSetGUID", governanceDomainGUID, "governanceDomainGUID", false, false, new Date(), "removeDomainFromSet");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDomainFromSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainListResponse getGovernanceDomains(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getGovernanceDomains";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDomains");
        GovernanceDomainListResponse response = new GovernanceDomainListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDomains");
            GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "getGovernanceDomains");
            response.setElements(domainHandler.getBeansByType(userId, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDomainDescription", null, startFrom, pageSize, false, false, new Date(), "getGovernanceDomains"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDomains", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainListResponse findGovernanceDomains(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceDomains";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceDomains");
        GovernanceDomainListResponse response = new GovernanceDomainListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceDomains");
                GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "findGovernanceDomains");
                response.setElements(domainHandler.findGovernanceDomains(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, "findGovernanceDomains"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceDomains", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceDomains", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainSetListResponse getSetsForGovernanceDomain(String serverName, String userId, String governanceDomainGUID, int startFrom, int pageSize) {
        String methodName = "getSetsForGovernanceDomain";
        String guidParameterName = "governanceDomainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForGovernanceDomain");
        GovernanceDomainSetListResponse response = new GovernanceDomainSetListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForGovernanceDomain");
            CollectionHandler<GovernanceDomainSetElement> handler = instanceHandler.getGovernanceDomainSetHandler(userId, serverName, "getSetsForGovernanceDomain");
            List sets = handler.getAttachedElements(userId, governanceDomainGUID, "governanceDomainGUID", "GovernanceDomainDescription", "5cabb76a-e25b-4bb5-8b93-768bbac005af", "CollectionMembership", "Collection", null, null, 1, false, false, startFrom, pageSize, new Date(), "getSetsForGovernanceDomain");
            this.addDomainsToSets(userId, sets, instanceHandler.getGovernanceDomainHandler(userId, serverName, "getSetsForGovernanceDomain"), "getSetsForGovernanceDomain");
            response.setElements(sets);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSetsForGovernanceDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private void addDomainsToSets(String userId, List<GovernanceDomainSetElement> sets, GovernanceDomainHandler<GovernanceDomainElement> domainHandler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (sets != null) {
            for (GovernanceDomainSetElement setElement : sets) {
                this.addDomainsToSet(userId, setElement, domainHandler, methodName);
            }
        }
    }

    private void addDomainsToSet(String userId, GovernanceDomainSetElement set, GovernanceDomainHandler<GovernanceDomainElement> domainHandler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "set.getElementHeader().getGUID()";
        List domains = domainHandler.getDomainsInSet(userId, set.getElementHeader().getGUID(), "set.getElementHeader().getGUID()", 0, 0, false, false, new Date(), methodName);
        set.setDomains(domains);
    }

    public GovernanceDomainListResponse getGovernanceDomainsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceDomainsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDomainsByName");
        GovernanceDomainListResponse response = new GovernanceDomainListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDomainsByName");
                GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "getGovernanceDomainsByName");
                response.setElements(domainHandler.getGovernanceDomainsByName(userId, requestBody.getName(), "name", startFrom, pageSize, "getGovernanceDomainsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceDomainsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDomainsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainResponse getGovernanceDomainByGUID(String serverName, String userId, String governanceDomainGUID) {
        String methodName = "getGovernanceDomainByGUID";
        String guidParameterName = "governanceDomainGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDomainByGUID");
        GovernanceDomainResponse response = new GovernanceDomainResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDomainByGUID");
            GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "getGovernanceDomainByGUID");
            response.setElement((GovernanceDomainElement)domainHandler.getGovernanceDomainByGUID(userId, governanceDomainGUID, "governanceDomainGUID", "getGovernanceDomainByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDomainByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDomainResponse getGovernanceDomainByIdentifier(String serverName, String userId, int domainIdentifier) {
        String methodName = "getGovernanceDomainByIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDomainByIdentifier");
        GovernanceDomainResponse response = new GovernanceDomainResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDomainByIdentifier");
            GovernanceDomainHandler<GovernanceDomainElement> domainHandler = instanceHandler.getGovernanceDomainHandler(userId, serverName, "getGovernanceDomainByIdentifier");
            response.setElement((GovernanceDomainElement)domainHandler.getGovernanceDomainByDomainIdentifier(userId, domainIdentifier, "getGovernanceDomainByIdentifier"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDomainByIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

