/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.converters.GovernanceProgramOMASConverter;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleHistory;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ProfileElement;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AppointmentHandler {
    private final PersonRoleHandler<GovernanceRoleElement> roleHandler;
    private final ActorProfileHandler<ProfileElement> profileHandler;
    private final GovernanceProgramOMASConverter<GovernanceAppointee> converter;
    private final RepositoryErrorHandler errorHandler;

    public AppointmentHandler(PersonRoleHandler<GovernanceRoleElement> roleHandler, ActorProfileHandler<ProfileElement> profileHandler, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, AuditLog auditLog) {
        this.roleHandler = roleHandler;
        this.profileHandler = profileHandler;
        this.converter = new GovernanceProgramOMASConverter(repositoryHelper, serviceName, serverName);
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
    }

    public List<GovernanceRoleAppointee> getCurrentGovernanceRoleAppointments(String userId, int domainIdentifier, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        List governanceRoles = this.roleHandler.getPersonRolesForDomainId(userId, domainIdentifier, startFrom, pageSize, false, false, new Date(), methodName);
        if (governanceRoles != null) {
            ArrayList<GovernanceRoleAppointee> results = new ArrayList<GovernanceRoleAppointee>();
            for (GovernanceRoleElement governanceRole : governanceRoles) {
                if (governanceRole == null || governanceRole.getElementHeader() == null) continue;
                GovernanceRoleAppointee governanceRoleAppointee = new GovernanceRoleAppointee(governanceRole);
                List appointmentRelationships = this.roleHandler.getAttachmentLinks(userId, governanceRole.getElementHeader().getGUID(), "governanceRoleGUID", "PersonRole", "4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", null, "ActorProfile", 1, false, false, 0, 0, null, methodName);
                if (appointmentRelationships != null) {
                    ArrayList<GovernanceAppointee> currentAppointees = new ArrayList<GovernanceAppointee>();
                    for (Relationship relationship : appointmentRelationships) {
                        if (relationship != null && relationship.getProperties() != null) {
                            InstanceProperties properties = relationship.getProperties();
                            Date now = new Date();
                            if (properties.getEffectiveFromTime() != null && !properties.getEffectiveFromTime().before(now) || properties.getEffectiveToTime() != null && !properties.getEffectiveToTime().after(now)) continue;
                            GovernanceAppointee appointee = this.getAppointeeFromRelationship(userId, relationship, methodName);
                            currentAppointees.add(appointee);
                            continue;
                        }
                        this.errorHandler.logBadRelationship("PersonRoleAppointment", relationship, methodName);
                    }
                    if (!currentAppointees.isEmpty()) {
                        governanceRoleAppointee.setCurrentAppointees(currentAppointees);
                    }
                }
                results.add(governanceRoleAppointee);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public GovernanceRoleHistory getGovernanceRoleHistoryByGUID(String userId, String governanceRoleGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        GovernanceRoleElement governanceRole = (GovernanceRoleElement)this.roleHandler.getBeanFromRepository(userId, governanceRoleGUID, "governanceRoleGUID", "PersonRole", false, false, new Date(), methodName);
        if (governanceRole != null && governanceRole.getElementHeader() != null) {
            GovernanceRoleHistory governanceRoleHistory = new GovernanceRoleHistory(governanceRole);
            List appointmentRelationships = this.roleHandler.getAttachmentLinks(userId, governanceRole.getElementHeader().getGUID(), "governanceRoleGUID", "PersonRole", "4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", null, "ActorProfile", 1, false, false, 0, 0, null, methodName);
            if (appointmentRelationships != null) {
                ArrayList<GovernanceAppointee> previousAppointees = new ArrayList<GovernanceAppointee>();
                ArrayList<GovernanceAppointee> currentAppointees = new ArrayList<GovernanceAppointee>();
                ArrayList<GovernanceAppointee> futureAppointees = new ArrayList<GovernanceAppointee>();
                for (Relationship relationship : appointmentRelationships) {
                    if (relationship == null || relationship.getProperties() == null) continue;
                    InstanceProperties properties = relationship.getProperties();
                    Date now = new Date();
                    GovernanceAppointee appointee = this.getAppointeeFromRelationship(userId, relationship, methodName);
                    if ((properties.getEffectiveFromTime() == null || properties.getEffectiveFromTime().before(now)) && (properties.getEffectiveToTime() == null || properties.getEffectiveToTime().after(now))) {
                        currentAppointees.add(appointee);
                        continue;
                    }
                    if (properties.getEffectiveToTime() != null && properties.getEffectiveToTime().before(now)) {
                        previousAppointees.add(appointee);
                        continue;
                    }
                    futureAppointees.add(appointee);
                }
                if (!previousAppointees.isEmpty()) {
                    governanceRoleHistory.setPredecessors(previousAppointees);
                }
                if (!currentAppointees.isEmpty()) {
                    governanceRoleHistory.setCurrentAppointees(currentAppointees);
                }
                if (!futureAppointees.isEmpty()) {
                    governanceRoleHistory.setSuccessors(futureAppointees);
                }
            }
            return governanceRoleHistory;
        }
        return null;
    }

    private GovernanceAppointee getAppointeeFromRelationship(String userId, Relationship relationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String profileGUIDParameterName = "profileGUID";
        if (relationship != null && relationship.getProperties() != null && relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null) {
            GovernanceAppointee appointee = new GovernanceAppointee();
            InstanceProperties properties = relationship.getProperties();
            ElementHeader elementHeader = this.converter.getMetadataElementHeader(GovernanceAppointee.class, (InstanceHeader)relationship, null, methodName);
            appointee.setElementHeader(elementHeader);
            appointee.setStartDate(properties.getEffectiveFromTime());
            appointee.setEndDate(properties.getEffectiveToTime());
            ProfileElement profile = (ProfileElement)this.profileHandler.getActorProfileByGUID(userId, relationship.getEntityOneProxy().getGUID(), "profileGUID", "Person", false, false, new Date(), methodName);
            appointee.setProfile(profile);
            return appointee;
        }
        this.errorHandler.logBadRelationship("PersonRoleAppointment", relationship, methodName);
        return null;
    }
}

