/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.converters.GovernanceProgramOMASConverter;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricImplementation;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMetricProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceMetricImplementationConverter<B>
extends GovernanceProgramOMASConverter<B> {
    public GovernanceMetricImplementationConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceMetricImplementation) {
                GovernanceMetricImplementation bean = (GovernanceMetricImplementation)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    GovernanceMetricProperties governanceMetricProperties = new GovernanceMetricProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    governanceMetricProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    governanceMetricProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceMetricProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    governanceMetricProperties.setDescription(this.removeDescription(instanceProperties));
                    governanceMetricProperties.setMeasurement(this.removeMeasurement(instanceProperties));
                    governanceMetricProperties.setTarget(this.removeTarget(instanceProperties));
                    governanceMetricProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    governanceMetricProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceMetricProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(governanceMetricProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, entity, methodName);
        if (returnBean instanceof GovernanceMetricImplementation) {
            GovernanceMetricImplementation bean = (GovernanceMetricImplementation)returnBean;
            bean.setRelatedElement(super.getRelatedElement(beanClass, entity, relationship, methodName));
        }
        return returnBean;
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceMetricImplementation) {
                GovernanceMetricImplementation bean = (GovernanceMetricImplementation)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)primaryEntity, primaryEntity.getClassifications(), methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    GovernanceMetricProperties governanceMetricProperties = new GovernanceMetricProperties();
                    governanceMetricProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    governanceMetricProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceMetricProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    governanceMetricProperties.setDescription(this.removeDescription(instanceProperties));
                    governanceMetricProperties.setMeasurement(this.removeMeasurement(instanceProperties));
                    governanceMetricProperties.setTarget(this.removeTarget(instanceProperties));
                    governanceMetricProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    governanceMetricProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceMetricProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(governanceMetricProperties);
                    ArrayList<RelatedElement> implementations = new ArrayList<RelatedElement>();
                    if (relationships != null) {
                        for (Relationship relationship : relationships) {
                            RelatedElement element;
                            if (relationship == null) continue;
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceResults")) {
                                element = super.getRelatedElement(beanClass, relationship, relationship.getEntityTwoProxy(), methodName);
                                implementations.add(element);
                                continue;
                            }
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceDefinitionMetric")) continue;
                            element = super.getRelatedElement(beanClass, relationship, relationship.getEntityOneProxy(), methodName);
                            bean.setRelatedElement(element);
                        }
                    }
                    if (!implementations.isEmpty()) {
                        bean.setImplementations(implementations);
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

