/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionMetricProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceExpectationsProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMeasurementsDataSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMeasurementsProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMetricProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceResultsProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceMetricHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class GovernanceMetricsRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceMetricsRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceMetric(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createGovernanceMetric";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceMetric");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceMetricProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceMetric");
                    GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "createGovernanceMetric");
                    GovernanceMetricProperties properties = (GovernanceMetricProperties)requestBody.getProperties();
                    String setGUID = handler.createGovernanceMetric(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getMeasurement(), properties.getTarget(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createGovernanceMetric");
                    response.setGUID(setGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceMetricProperties.class.getName(), "createGovernanceMetric");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceMetric", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceMetric", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceMetric(String serverName, String userId, String metricGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateGovernanceMetric";
        String guidParameterName = "metricGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceMetric");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceMetricProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceMetric");
                    GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "updateGovernanceMetric");
                    GovernanceMetricProperties properties = (GovernanceMetricProperties)requestBody.getProperties();
                    handler.updateGovernanceMetric(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getMeasurement(), properties.getTarget(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateGovernanceMetric");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceMetricProperties.class.getName(), "updateGovernanceMetric");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceMetric", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceMetric", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceMetric(String serverName, String userId, String metricGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteExternalReference";
        String guidParameterName = "metricGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteExternalReference");
            GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "deleteExternalReference");
            handler.removeGovernanceMetric(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", false, false, new Date(), "deleteExternalReference");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernanceDefinitionMetric(String serverName, String userId, String metricGUID, String governanceDefinitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernanceDefinitionMetric";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernanceDefinitionMetric");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernanceDefinitionMetric");
            GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "setupGovernanceDefinitionMetric");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceDefinitionMetricProperties) {
                    GovernanceDefinitionMetricProperties properties = (GovernanceDefinitionMetricProperties)requestBody.getProperties();
                    handler.addGovernanceDefinitionMetric(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", governanceDefinitionGUID, "governanceDefinitionGUID", properties.getRationale(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernanceDefinitionMetric");
                } else if (requestBody.getProperties() == null) {
                    handler.addGovernanceDefinitionMetric(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", governanceDefinitionGUID, "governanceDefinitionGUID", null, null, null, false, false, new Date(), "setupGovernanceDefinitionMetric");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDefinitionMetricProperties.class.getName(), "setupGovernanceDefinitionMetric");
                }
            } else {
                handler.addGovernanceDefinitionMetric(userId, null, null, metricGUID, "metricGUID", governanceDefinitionGUID, "governanceDefinitionGUID", null, null, null, false, false, new Date(), "setupGovernanceDefinitionMetric");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupGovernanceDefinitionMetric", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceDefinitionMetric(String serverName, String userId, String metricGUID, String governanceDefinitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "clearGovernanceDefinitionMetric";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceDefinitionMetric");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceDefinitionMetric");
            GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "clearGovernanceDefinitionMetric");
            if (requestBody != null) {
                handler.removeGovernanceDefinitionMetric(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", governanceDefinitionGUID, "governanceDefinitionGUID", false, false, new Date(), "clearGovernanceDefinitionMetric");
            } else {
                handler.removeGovernanceDefinitionMetric(userId, null, null, metricGUID, "metricGUID", governanceDefinitionGUID, "governanceDefinitionGUID", false, false, new Date(), "clearGovernanceDefinitionMetric");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceDefinitionMetric", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernanceResults(String serverName, String userId, String metricGUID, String dataSetGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernanceResults";
        String metricGUIDParameterName = "metricGUID";
        String dataSetGUIDParameterName = "dataSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernanceResults");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernanceResults");
            GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "setupGovernanceResults");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceResultsProperties) {
                    GovernanceResultsProperties properties = (GovernanceResultsProperties)requestBody.getProperties();
                    handler.addGovernanceResults(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", dataSetGUID, "dataSetGUID", properties.getQuery(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernanceResults");
                } else if (requestBody.getProperties() == null) {
                    handler.addGovernanceResults(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", dataSetGUID, "dataSetGUID", null, null, null, false, false, new Date(), "setupGovernanceResults");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceResultsProperties.class.getName(), "setupGovernanceResults");
                }
            } else {
                handler.addGovernanceResults(userId, null, null, metricGUID, "metricGUID", dataSetGUID, "dataSetGUID", null, null, null, false, false, new Date(), "setupGovernanceResults");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupGovernanceResults", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceResults(String serverName, String userId, String metricGUID, String dataSetGUID, RelationshipRequestBody requestBody) {
        String methodName = "clearGovernanceResults";
        String metricGUIDParameterName = "metricGUID";
        String dataSetGUIDParameterName = "dataSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceResults");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceResults");
            GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "clearGovernanceResults");
            if (requestBody != null) {
                handler.removeGovernanceResults(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metricGUID, "metricGUID", dataSetGUID, "dataSetGUID", false, false, new Date(), "clearGovernanceResults");
            } else {
                handler.removeGovernanceResults(userId, null, null, metricGUID, "metricGUID", dataSetGUID, "dataSetGUID", false, false, new Date(), "clearGovernanceResults");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceResults", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGovernanceMeasurementsDataSet(String serverName, String userId, String dataSetGUID, ClassificationRequestBody requestBody) {
        String methodName = "setGovernanceMeasurementsDataSet";
        String guidParameter = "dataSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGovernanceMeasurementsDataSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGovernanceMeasurementsDataSet");
            AssetHandler<RelatedElement> handler = instanceHandler.getRelatedAssetHandler(userId, serverName, "setGovernanceMeasurementsDataSet");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceMeasurementsDataSetProperties) {
                    GovernanceMeasurementsDataSetProperties properties = (GovernanceMeasurementsDataSetProperties)requestBody.getProperties();
                    handler.addGovernanceMeasurementsDataSetClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataSetGUID, "dataSetGUID", "DataSet", properties.getDescription(), false, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), null, "setGovernanceMeasurementsDataSet");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceMeasurementsDataSetProperties.class.getName(), "setGovernanceMeasurementsDataSet");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGovernanceMeasurementsDataSet", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGovernanceMeasurementsDataSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceMeasurementsDataSet(String serverName, String userId, String dataSetGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceMeasurementsDataSet";
        String guidParameter = "dataSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceMeasurementsDataSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceMeasurementsDataSet");
            AssetHandler<RelatedElement> handler = instanceHandler.getRelatedAssetHandler(userId, serverName, "clearGovernanceMeasurementsDataSet");
            if (requestBody != null) {
                handler.removeGovernanceMeasurementsDataSetClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataSetGUID, "dataSetGUID", "DataSet", false, false, null, "clearGovernanceMeasurementsDataSet");
            } else {
                handler.removeGovernanceMeasurementsDataSetClassification(userId, null, null, dataSetGUID, "dataSetGUID", "DataSet", false, false, null, "clearGovernanceMeasurementsDataSet");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceMeasurementsDataSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGovernanceExpectations(String serverName, String userId, String elementGUID, ClassificationRequestBody requestBody) {
        String methodName = "setGovernanceExpectations";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGovernanceExpectations");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGovernanceExpectations");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setGovernanceExpectations");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceExpectationsProperties) {
                    GovernanceExpectationsProperties properties = (GovernanceExpectationsProperties)requestBody.getProperties();
                    handler.addGovernanceExpectationsClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", "Referenceable", properties.getCounts(), properties.getValues(), properties.getFlags(), false, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), null, "setGovernanceExpectations");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceExpectationsProperties.class.getName(), "setGovernanceExpectations");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGovernanceExpectations", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGovernanceExpectations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceExpectations(String serverName, String userId, String elementGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceExpectations";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceExpectations");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceExpectations");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearGovernanceExpectations");
            if (requestBody != null) {
                handler.removeGovernanceExpectationsClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", "Referenceable", false, false, null, "clearGovernanceExpectations");
            } else {
                handler.removeGovernanceExpectationsClassification(userId, null, null, elementGUID, "elementGUID", "Referenceable", false, false, null, "clearGovernanceExpectations");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceExpectations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGovernanceMeasurements(String serverName, String userId, String elementGUID, ClassificationRequestBody requestBody) {
        String methodName = "setGovernanceMeasurements";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGovernanceMeasurements");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGovernanceMeasurements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setGovernanceMeasurements");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceMeasurementsProperties) {
                    GovernanceMeasurementsProperties properties = (GovernanceMeasurementsProperties)requestBody.getProperties();
                    handler.addGovernanceMeasurementsClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", "Referenceable", properties.getCounts(), properties.getValues(), properties.getFlags(), false, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), null, "setGovernanceMeasurements");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceMeasurementsProperties.class.getName(), "setGovernanceMeasurements");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGovernanceMeasurements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGovernanceMeasurements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceMeasurements(String serverName, String userId, String elementGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceMeasurements";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceMeasurements");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceMeasurements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearGovernanceMeasurements");
            if (requestBody != null) {
                handler.removeGovernanceMeasurementsClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", "Referenceable", false, false, null, "clearGovernanceMeasurements");
            } else {
                handler.removeGovernanceMeasurementsClassification(userId, null, null, elementGUID, "elementGUID", "Referenceable", false, false, null, "clearGovernanceMeasurements");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceMeasurements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceMetricResponse getGovernanceMetricByGUID(String serverName, String userId, String metricGUID) {
        String methodName = "getGovernanceMetricByGUID";
        String guidParameterName = "metricGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceMetricByGUID");
        GovernanceMetricResponse response = new GovernanceMetricResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceMetricByGUID");
            GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "getGovernanceMetricByGUID");
            response.setElement((GovernanceMetricElement)handler.getGovernanceMetricByGUID(userId, metricGUID, "metricGUID", false, false, new Date(), "getGovernanceMetricByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceMetricByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceMetricListResponse findGovernanceMetrics(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceMetrics";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceMetrics");
        GovernanceMetricListResponse response = new GovernanceMetricListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceMetrics");
                GovernanceMetricHandler<GovernanceMetricElement> handler = instanceHandler.getGovernanceMetricHandler(userId, serverName, "findGovernanceMetrics");
                response.setElements(handler.findGovernanceMetrics(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findGovernanceMetrics"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceMetrics", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceMetrics", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

