/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.converters.GovernanceProgramOMASConverter;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.AssetProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetConverter<B>
extends GovernanceProgramOMASConverter<B> {
    public AssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, null, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, null, null, methodName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof AssetElement) {
                AssetElement bean = (AssetElement)returnBean;
                AssetProperties assetProperties = new AssetProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    assetProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    assetProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    assetProperties.setTechnicalName(this.removeName(instanceProperties));
                    assetProperties.setTechnicalDescription(this.removeDescription(instanceProperties));
                    this.removeOwner(instanceProperties);
                    this.removeOwnerTypeOrdinal(instanceProperties);
                    this.removeZoneMembership(instanceProperties);
                    assetProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    assetProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (relationships != null && supplementaryEntities != null) {
                        for (Relationship relationship : relationships) {
                            EntityProxy termProxy;
                            if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "SupplementaryProperties") || (termProxy = relationship.getEntityTwoProxy()) == null) continue;
                            for (EntityDetail entity : supplementaryEntities) {
                                if (entity == null || !termProxy.getGUID().equals(entity.getGUID())) continue;
                                instanceProperties = entity.getProperties();
                                assetProperties.setDisplayName(this.getDisplayName(instanceProperties));
                                assetProperties.setSummary(this.getSummary(instanceProperties));
                                assetProperties.setDescription(this.getDescription(instanceProperties));
                                assetProperties.setAbbreviation(this.getAbbreviation(instanceProperties));
                                assetProperties.setUsage(this.getUsage(instanceProperties));
                            }
                        }
                    }
                    bean.setProperties(assetProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

