/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.converters.GovernanceProgramOMASConverter;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ProfileElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ActorProfileProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProfileConverter<B>
extends GovernanceProgramOMASConverter<B> {
    public ProfileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProfileElement) {
                ProfileElement bean = (ProfileElement)returnBean;
                ActorProfileProperties profileProperties = new ActorProfileProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    profileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    profileProperties.setKnownName(this.removeName(instanceProperties));
                    profileProperties.setDescription(this.removeDescription(instanceProperties));
                    profileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    profileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    profileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProfileProperties(profileProperties);
                    if (supplementaryEntities != null) {
                        ArrayList<UserIdentityElement> userIdentities = new ArrayList<UserIdentityElement>();
                        ArrayList<ContactMethodElement> contactMethods = new ArrayList<ContactMethodElement>();
                        for (EntityDetail entity : supplementaryEntities) {
                            if (entity != null && entity.getType() != null) {
                                InstanceProperties entityProperties;
                                String entityTypeName = entity.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "UserIdentity")) {
                                    UserIdentityElement userBean = new UserIdentityElement();
                                    UserIdentityProperties userProperties = new UserIdentityProperties();
                                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    userProperties.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    userProperties.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    userProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    userProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    userBean.setProperties(userProperties);
                                    userIdentities.add(userBean);
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "ContactDetails")) continue;
                                ContactMethodElement contactMethodBean = new ContactMethodElement();
                                ContactMethodProperties contactMethodProperties = new ContactMethodProperties();
                                contactMethodBean.setElementHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)entity, methodName));
                                entityProperties = new InstanceProperties(entity.getProperties());
                                contactMethodProperties.setQualifiedName(this.removeQualifiedName(entityProperties));
                                contactMethodProperties.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                contactMethodProperties.setType(this.getContactMethodTypeFromProperties(entityProperties));
                                contactMethodProperties.setService(this.removeContactMethodService(entityProperties));
                                contactMethodProperties.setValue(this.removeContactMethodValue(entityProperties));
                                contactMethodProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                contactMethodProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                contactMethodBean.setProperties(contactMethodProperties);
                                contactMethods.add(contactMethodBean);
                                continue;
                            }
                            this.handleBadEntity(beanClass.getName(), entity, methodName);
                        }
                        if (!userIdentities.isEmpty()) {
                            bean.setUserIdentities(userIdentities);
                        }
                        if (!contactMethods.isEmpty()) {
                            bean.setContactMethods(contactMethods);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        String methodName = "getContactMethodTypeFromProperties";
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "contactMethodType", properties, "getContactMethodTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
                case 99: {
                    contactMethodType = ContactMethodType.OTHER;
                }
            }
        }
        return contactMethodType;
    }
}

