/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class ExternalReferenceRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ExternalReferenceRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createExternalReference(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createExternalReference";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalReference");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ExternalReferenceProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalReference");
                    ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "createExternalReference");
                    ExternalReferenceProperties properties = (ExternalReferenceProperties)requestBody.getProperties();
                    response.setGUID(handler.createExternalReference(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), properties.getQualifiedName(), properties.getDisplayName(), properties.getResourceDescription(), properties.getURI(), properties.getVersion(), properties.getOrganization(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createExternalReference"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ExternalReferenceProperties.class.getName(), "createExternalReference");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalReference", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalReference(String serverName, String userId, String externalReferenceGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateExternalReference";
        String guidParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ExternalReferenceProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalReference");
                    ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "updateExternalReference");
                    ExternalReferenceProperties properties = (ExternalReferenceProperties)requestBody.getProperties();
                    handler.updateExternalReference(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), externalReferenceGUID, "externalReferenceGUID", properties.getQualifiedName(), properties.getDisplayName(), properties.getResourceDescription(), properties.getURI(), properties.getVersion(), properties.getOrganization(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateExternalReference");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ExternalReferenceProperties.class.getName(), "updateExternalReference");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalReference", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteExternalReference(String serverName, String userId, String externalReferenceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteExternalReference";
        String guidParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteExternalReference");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "deleteExternalReference");
            if (requestBody != null) {
                handler.removeExternalReference(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), externalReferenceGUID, "externalReferenceGUID", false, false, new Date(), "deleteExternalReference");
            } else {
                handler.removeExternalReference(userId, null, null, externalReferenceGUID, "externalReferenceGUID", false, false, new Date(), "deleteExternalReference");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkExternalReferenceToElement(String serverName, String userId, String attachedToGUID, String externalReferenceGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkExternalReferenceToElement";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkExternalReferenceToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkExternalReferenceToElement");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "linkExternalReferenceToElement");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ExternalReferenceLinkProperties) {
                    OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "linkExternalReferenceToElement");
                    String serviceName = instanceHandler.getServiceName();
                    ExternalReferenceLinkProperties properties = (ExternalReferenceLinkProperties)requestBody.getProperties();
                    InstanceProperties relationshipProperties = repositoryHelper.addStringPropertyToInstance(serviceName, null, "referenceId", properties.getLinkId(), "linkExternalReferenceToElement");
                    relationshipProperties = repositoryHelper.addStringPropertyToInstance(serviceName, relationshipProperties, "description", properties.getLinkDescription(), "linkExternalReferenceToElement");
                    relationshipProperties = repositoryHelper.addStringPropertyToInstance(serviceName, relationshipProperties, "pages", properties.getPages(), "linkExternalReferenceToElement");
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), attachedToGUID, "attachedToGUID", "Referenceable", externalReferenceGUID, "externalReferenceGUID", "ExternalReference", false, false, "7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", relationshipProperties, properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "linkExternalReferenceToElement");
                } else if (requestBody.getProperties() == null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), attachedToGUID, "attachedToGUID", "Referenceable", externalReferenceGUID, "externalReferenceGUID", "ExternalReference", false, false, "7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", null, null, (Date)null, new Date(), "linkExternalReferenceToElement");
                }
            } else {
                this.restExceptionHandler.handleInvalidPropertiesObject(ExternalReferenceLinkProperties.class.getName(), "linkExternalReferenceToElement");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkExternalReferenceFromElement(String serverName, String userId, String attachedToGUID, String externalReferenceGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkExternalReferenceToElement";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkExternalReferenceToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkExternalReferenceToElement");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "unlinkExternalReferenceToElement");
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), attachedToGUID, "attachedToGUID", "Referenceable", externalReferenceGUID, "externalReferenceGUID", "af536f20-062b-48ef-9c31-1ddd05b04c56", "ExternalReference", false, false, "7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", new Date(), "unlinkExternalReferenceToElement");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, attachedToGUID, "attachedToGUID", "Referenceable", externalReferenceGUID, "externalReferenceGUID", "af536f20-062b-48ef-9c31-1ddd05b04c56", "ExternalReference", false, false, "7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", new Date(), "unlinkExternalReferenceToElement");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceResponse getExternalReferenceByGUID(String serverName, String userId, String externalReferenceGUID) {
        String methodName = "getExternalReferenceByGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferenceByGUID");
        ExternalReferenceResponse response = new ExternalReferenceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferenceByGUID");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "getExternalReferenceByGUID");
            response.setElement((ExternalReferenceElement)handler.getBeanFromRepository(userId, externalReferenceGUID, "externalReferenceGUID", "ExternalReference", false, false, new Date(), "getExternalReferenceByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferenceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceListResponse findExternalReferencesById(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findExternalReferencesById";
        String resourceIdParameterName = "resourceId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findExternalReferencesById");
        ExternalReferenceListResponse response = new ExternalReferenceListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findExternalReferencesById");
                ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "findExternalReferencesById");
                response.setElements(handler.findBeans(userId, requestBody.getSearchString(), "resourceId", "af536f20-062b-48ef-9c31-1ddd05b04c56", "ExternalId", null, startFrom, pageSize, false, false, new Date(), "findExternalReferencesById"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findExternalReferencesById", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findExternalReferencesById", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceListResponse getExternalReferencesByURL(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getExternalReferencesByURL";
        String urlParameterName = "resourceId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferencesByURL");
        ExternalReferenceListResponse response = new ExternalReferenceListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferencesByURL");
                ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "getExternalReferencesByURL");
                response.setElements(handler.getExternalReferencesByURL(userId, requestBody.getName(), "resourceId", startFrom, pageSize, false, false, new Date(), "getExternalReferencesByURL"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferencesByURL", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferencesByURL", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceListResponse retrieveAttachedExternalReferences(String serverName, String userId, String attachedToGUID, int startFrom, int pageSize) {
        String methodName = "retrieveAttachedExternalReferences";
        String guidParameterName = "attachedToGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "retrieveAttachedExternalReferences");
        ExternalReferenceListResponse response = new ExternalReferenceListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "retrieveAttachedExternalReferences");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "retrieveAttachedExternalReferences");
            response.setElements(handler.getAttachedElements(userId, attachedToGUID, "attachedToGUID", "Referenceable", "7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", "ExternalReference", null, null, 2, false, false, startFrom, pageSize, new Date(), "retrieveAttachedExternalReferences"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "retrieveAttachedExternalReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getElementsForExternalReference(String serverName, String userId, String externalReferenceGUID, int startFrom, int pageSize) {
        String methodName = "getElementsForExternalReference";
        String guidParameter = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsForExternalReference");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsForExternalReference");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getElementsForExternalReference");
            response.setElementList(handler.getAttachedElements(userId, externalReferenceGUID, "externalReferenceGUID", "ExternalReference", "7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", "Referenceable", null, null, 1, false, false, startFrom, pageSize, new Date(), "getElementsForExternalReference"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsForExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

