/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionGraph;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricImplementation;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ElementStubListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionGraphResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricImplementationListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceMetricHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.slf4j.LoggerFactory;

public class GovernanceReviewRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceReviewRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GovernanceDefinitionResponse getGovernanceDefinitionByGUID(String serverName, String userId, String definitionGUID) {
        String methodName = "getGovernanceDefinitionByGUID";
        String guidParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionByGUID");
        GovernanceDefinitionResponse response = new GovernanceDefinitionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionByGUID");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernanceDefinitionByGUID");
            response.setElement((GovernanceDefinitionElement)handler.getGovernanceDefinitionByGUID(userId, definitionGUID, "definitionGUID", false, false, new Date(), "getGovernanceDefinitionByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionListResponse getGovernanceDefinitionsForDomain(String serverName, String userId, String typeName, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionsForDomain";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionsForDomain");
        GovernanceDefinitionListResponse response = new GovernanceDefinitionListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionsForDomain");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernanceDefinitionsForDomain");
            response.setElements(handler.getGovernanceDefinitionsByDomain(userId, typeName, domainIdentifier, startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionsForDomain"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionsForDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionListResponse getGovernanceDefinitionsForDocId(String serverName, String userId, String typeName, String docId, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionsForDocId";
        String docIdParameterName = "docId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionsForDocId");
        GovernanceDefinitionListResponse response = new GovernanceDefinitionListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionsForDocId");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernanceDefinitionsForDocId");
            response.setElements(handler.getGovernanceDefinitionsByName(userId, typeName, docId, "docId", startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionsForDocId"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionsForDocId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionGraphResponse getGovernanceDefinitionInContext(String serverName, String userId, String governanceDefinitionGUID) {
        String methodName = "getGovernanceDefinitionInContext";
        String guidParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionInContext");
        GovernanceDefinitionGraphResponse response = new GovernanceDefinitionGraphResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionInContext");
            GovernanceDefinitionHandler<GovernanceDefinitionGraph> handler = instanceHandler.getGovernanceDefinitionGraphHandler(userId, serverName, "getGovernanceDefinitionInContext");
            response.setElement((GovernanceDefinitionGraph)handler.getGovernanceDefinitionInContext(userId, governanceDefinitionGUID, "governanceDefinitionGUID", false, false, new Date(), "getGovernanceDefinitionInContext"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionInContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionListResponse findGovernanceDefinitions(String serverName, String userId, String typeName, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceDefinitions";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceDefinitions");
        GovernanceDefinitionListResponse response = new GovernanceDefinitionListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceDefinitions");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "findGovernanceDefinitions");
            if (requestBody != null) {
                response.setElements(handler.findGovernanceDefinitions(userId, typeName, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findGovernanceDefinitions"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceDefinitions", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceMetricImplementationListResponse getGovernanceDefinitionMetrics(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionMetrics";
        String guidParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionMetrics");
        GovernanceMetricImplementationListResponse response = new GovernanceMetricImplementationListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionMetrics");
            GovernanceMetricHandler<GovernanceMetricImplementation> handler = instanceHandler.getGovernanceMetricImplementationHandler(userId, serverName, "getGovernanceDefinitionMetrics");
            response.setElements(handler.getAttachedGovernanceMetricImplementations(userId, governanceDefinitionGUID, "governanceDefinitionGUID", startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionMetrics"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionMetrics", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubListResponse getGovernanceZoneMembers(String serverName, String userId, String zoneName, String subTypeName, int startFrom, int pageSize) {
        String methodName = "getGovernanceZoneMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZoneMembers");
        ElementStubListResponse response = new ElementStubListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZoneMembers");
            AssetHandler<ElementStub> handler = instanceHandler.getAssetHandler(userId, serverName, "getGovernanceZoneMembers");
            response.setElements(handler.assetZoneScan(userId, zoneName, subTypeName, startFrom, pageSize, false, false, new Date(), "getGovernanceZoneMembers"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceZoneMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

