/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.CertificationTypeElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.CertificationProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.CertificationTypeProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificationTypeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificationTypeResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.CertificationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class CertificationRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CertificationRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createCertificationType(String serverName, String userId, GovernanceDefinitionRequestBody requestBody) {
        String methodName = "createCertificationType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createCertificationType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof CertificationTypeProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createCertificationType");
                    CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "createCertificationType");
                    CertificationTypeProperties properties = (CertificationTypeProperties)requestBody.getProperties();
                    String setGUID = handler.createGovernanceDefinition(userId, properties.getDocumentIdentifier(), properties.getTitle(), properties.getSummary(), properties.getDescription(), properties.getScope(), properties.getDomainIdentifier(), properties.getPriority(), properties.getImplications(), properties.getOutcomes(), properties.getResults(), null, null, null, null, properties.getDetails(), null, properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), null, null, new Date(), "createCertificationType");
                    response.setGUID(setGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CertificationTypeProperties.class.getName(), "createCertificationType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createCertificationType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createCertificationType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCertificationType(String serverName, String userId, String certificationTypeGUID, boolean isMergeUpdate, GovernanceDefinitionRequestBody requestBody) {
        String methodName = "updateCertificationType";
        String guidParameterName = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCertificationType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof CertificationTypeProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCertificationType");
                    CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "updateCertificationType");
                    CertificationTypeProperties properties = (CertificationTypeProperties)requestBody.getProperties();
                    handler.updateGovernanceDefinition(userId, certificationTypeGUID, "certificationTypeGUID", properties.getDocumentIdentifier(), properties.getTitle(), properties.getSummary(), properties.getDescription(), properties.getScope(), properties.getDomainIdentifier(), properties.getPriority(), properties.getImplications(), properties.getOutcomes(), properties.getResults(), null, null, null, null, properties.getDetails(), null, properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateCertificationType");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CertificationTypeProperties.class.getName(), "updateCertificationType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateCertificationType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCertificationType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteCertificationType(String serverName, String userId, String certificationTypeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteCertificationType";
        String guidParameterName = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteCertificationType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteCertificationType");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "deleteCertificationType");
            handler.removeGovernanceDefinition(userId, certificationTypeGUID, "certificationTypeGUID", false, false, new Date(), "deleteCertificationType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteCertificationType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypeResponse getCertificationTypeByGUID(String serverName, String userId, String certificationTypeGUID) {
        String methodName = "getCertificationTypeByGUID";
        String guidParameterName = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypeByGUID");
        CertificationTypeResponse response = new CertificationTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypeByGUID");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypeByGUID");
            response.setElement((CertificationTypeElement)handler.getGovernanceDefinitionByGUID(userId, certificationTypeGUID, "certificationTypeGUID", false, false, new Date(), "getCertificationTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCertificationTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypeResponse getCertificationTypeByDocId(String serverName, String userId, String documentIdentifier) {
        String methodName = "getCertificationTypeByDocId";
        String documentIdParameterName = "documentId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypeByDocId");
        CertificationTypeResponse response = new CertificationTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypeByDocId");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypeByDocId");
            List certificationTypeElements = handler.getGovernanceDefinitionsByName(userId, "CertificationType", documentIdentifier, "documentId", 0, 0, false, false, new Date(), "getCertificationTypeByDocId");
            if (certificationTypeElements != null && !certificationTypeElements.isEmpty()) {
                response.setElement((CertificationTypeElement)certificationTypeElements.get(0));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCertificationTypeByDocId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypeListResponse getCertificationTypesByTitle(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "getCertificationTypesByTitle";
        String titleParameterName = "title";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypesByTitle");
        CertificationTypeListResponse response = new CertificationTypeListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypesByTitle");
                CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypesByTitle");
                response.setElements(handler.findGovernanceDefinitions(userId, "CertificationType", requestBody.getSearchString(), "title", startFrom, pageSize, false, false, new Date(), "getCertificationTypesByTitle"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getCertificationTypesByTitle", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCertificationTypesByTitle", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypeListResponse getCertificationTypeByDomainId(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getCertificationTypeByDomainId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypeByDomainId");
        CertificationTypeListResponse response = new CertificationTypeListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypeByDomainId");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypeByDomainId");
            response.setElements(handler.getGovernanceDefinitionsByDomain(userId, "CertificationType", domainIdentifier, startFrom, pageSize, false, false, new Date(), "getCertificationTypeByDomainId"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCertificationTypeByDomainId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse certifyElement(String serverName, String userId, String elementGUID, String certificationTypeGUID, RelationshipRequestBody requestBody) {
        String methodName = "certifyElement";
        String elementGUIDParameterName = "elementGUID";
        String certificationTypeGUIDParameterName = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "certifyElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof CertificationProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "certifyElement");
                    CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "certifyElement");
                    CertificationProperties properties = (CertificationProperties)requestBody.getProperties();
                    response.setGUID(handler.certifyElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, certificationTypeGUID, "certificationTypeGUID", "CertificationType", properties.getCertificateId(), properties.getStartDate(), properties.getEndDate(), properties.getConditions(), properties.getCertifiedBy(), properties.getCertifiedByTypeName(), properties.getCertifiedByPropertyName(), properties.getCustodian(), properties.getCustodianTypeName(), properties.getCustodianPropertyName(), properties.getRecipient(), properties.getRecipientTypeName(), properties.getRecipientPropertyName(), properties.getNotes(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "certifyElement"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CertificationTypeProperties.class.getName(), "certifyElement");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "certifyElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "certifyElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCertification(String serverName, String userId, String certificationGUID, boolean isMergeUpdate, RelationshipRequestBody requestBody) {
        String methodName = "updateCertification";
        String certificationGUIDParameterName = "certificationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCertification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof CertificationProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCertification");
                    CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "updateCertification");
                    CertificationProperties properties = (CertificationProperties)requestBody.getProperties();
                    handler.updateCertification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), certificationGUID, "certificationGUID", properties.getCertificateId(), properties.getStartDate(), properties.getEndDate(), properties.getConditions(), properties.getCertifiedBy(), properties.getCertifiedByTypeName(), properties.getCertifiedByPropertyName(), properties.getCustodian(), properties.getCustodianTypeName(), properties.getCustodianPropertyName(), properties.getRecipient(), properties.getRecipientTypeName(), properties.getRecipientPropertyName(), properties.getNotes(), isMergeUpdate, null, null, false, false, new Date(), "updateCertification");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CertificationProperties.class.getName(), "updateCertification");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateCertification", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCertification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse decertifyElement(String serverName, String userId, String certificationGUID, RelationshipRequestBody requestBody) {
        String methodName = "decertifyElement";
        String certificationGUIDParameterName = "certificationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "decertifyElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "decertifyElement");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "decertifyElement");
            if (requestBody != null) {
                handler.decertifyElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), certificationGUID, "certificationGUID", false, false, new Date(), "decertifyElement");
            } else {
                handler.decertifyElement(userId, null, null, certificationGUID, "certificationGUID", false, false, new Date(), "decertifyElement");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "decertifyElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getCertifiedElements(String serverName, String userId, String certificationTypeGUID, int startFrom, int pageSize) {
        String methodName = "getCertifiedElements";
        String guidParameter = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertifiedElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertifiedElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getCertifiedElements");
            response.setElementList(handler.getAttachedElements(userId, certificationTypeGUID, "certificationTypeGUID", "CertificationType", "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", OpenMetadataType.REFERENCEABLE.typeName, null, null, 1, false, false, startFrom, pageSize, new Date(), "getCertifiedElements"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCertifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getCertifications(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicences");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicences");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getLicences");
            response.setElementList(handler.getAttachedElements(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", "CertificationType", null, null, 2, false, false, startFrom, pageSize, new Date(), "getLicences"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

