/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PeerDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SupportingDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.LoggerFactory;

public class GovernanceDefinitionRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceDefinitionRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceDefinition(String serverName, String userId, GovernanceDefinitionRequestBody requestBody) {
        String methodName = "createGovernanceDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceDefinition");
                    GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "createGovernanceDefinition");
                    GovernanceDefinitionProperties properties = requestBody.getProperties();
                    String setGUID = handler.createGovernanceDefinition(userId, properties.getDocumentIdentifier(), properties.getTitle(), properties.getSummary(), properties.getDescription(), properties.getScope(), properties.getDomainIdentifier(), properties.getPriority(), properties.getImplications(), properties.getOutcomes(), properties.getResults(), null, null, null, null, null, null, properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), null, null, new Date(), "createGovernanceDefinition");
                    response.setGUID(setGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDefinitionProperties.class.getName(), "createGovernanceDefinition");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceDefinition", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceDefinition(String serverName, String userId, String definitionGUID, boolean isMergeUpdate, GovernanceDefinitionRequestBody requestBody) {
        String methodName = "updateGovernanceDefinition";
        String guidParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceDefinition");
                    GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "updateGovernanceDefinition");
                    GovernanceDefinitionProperties properties = requestBody.getProperties();
                    handler.updateGovernanceDefinition(userId, definitionGUID, "definitionGUID", properties.getDocumentIdentifier(), properties.getTitle(), properties.getSummary(), properties.getDescription(), properties.getScope(), properties.getDomainIdentifier(), properties.getPriority(), properties.getImplications(), properties.getOutcomes(), properties.getResults(), null, null, null, null, null, null, properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateGovernanceDefinition");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceDefinitionProperties.class.getName(), "updateGovernanceDefinition");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceDefinition", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGovernanceDefinitionStatus(String serverName, String userId, String definitionGUID, GovernanceStatusRequestBody requestBody) {
        String methodName = "setGovernanceDefinitionStatus";
        String guidParameterName = "definitionGUID";
        String propertiesParameterName = "newStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGovernanceDefinitionStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setGovernanceDefinitionStatus");
                GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "setGovernanceDefinitionStatus");
                handler.updateBeanStatusInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), definitionGUID, "definitionGUID", "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDefinition", false, false, this.getInstanceStatus(requestBody.getStatus()), "newStatus", new Date(), "setGovernanceDefinitionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGovernanceDefinitionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGovernanceDefinitionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private InstanceStatus getInstanceStatus(GovernanceDefinitionStatus governanceDefinitionStatus) {
        if (governanceDefinitionStatus != null) {
            switch (governanceDefinitionStatus) {
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case DEPRECATED: {
                    return InstanceStatus.DEPRECATED;
                }
                case OTHER: {
                    return InstanceStatus.OTHER;
                }
            }
        }
        return null;
    }

    public VoidResponse deleteGovernanceDefinition(String serverName, String userId, String definitionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteGovernanceDefinition";
        String guidParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceDefinition");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "deleteGovernanceDefinition");
            handler.removeGovernanceDefinition(userId, definitionGUID, "definitionGUID", false, false, new Date(), "deleteGovernanceDefinition");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkPeerDefinitions(String serverName, String userId, String definitionOneGUID, String definitionTwoGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkPeerDefinitions";
        String definitionOneGUIDParameterName = "definitionOneGUID";
        String definitionTwoGUIDParameterName = "definitionTwoGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkPeerDefinitions");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "linkPeerDefinitions");
                GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "linkPeerDefinitions");
                if (requestBody.getProperties() instanceof PeerDefinitionProperties) {
                    PeerDefinitionProperties properties = (PeerDefinitionProperties)requestBody.getProperties();
                    handler.setupPeerRelationship(userId, definitionOneGUID, "definitionOneGUID", "GovernanceDefinition", definitionTwoGUID, "definitionTwoGUID", "GovernanceDefinition", requestBody.getRelationshipName(), properties.getDescription(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "linkPeerDefinitions");
                } else if (requestBody.getProperties() == null) {
                    handler.setupPeerRelationship(userId, definitionOneGUID, "definitionOneGUID", "GovernanceDefinition", definitionTwoGUID, "definitionTwoGUID", "GovernanceDefinition", requestBody.getRelationshipName(), null, null, null, false, false, new Date(), "linkPeerDefinitions");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(PeerDefinitionProperties.class.getName(), "linkPeerDefinitions");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkPeerDefinitions", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkPeerDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkPeerDefinitions(String serverName, String userId, String definitionOneGUID, String definitionTwoGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkPeerDefinitions";
        String definitionOneGUIDParameterName = "definitionOneGUID";
        String definitionTwoGUIDParameterName = "definitionTwoGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkPeerDefinitions");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkPeerDefinitions");
                GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "unlinkPeerDefinitions");
                handler.clearDefinitionRelationship(userId, definitionOneGUID, "definitionOneGUID", "GovernanceDefinition", definitionTwoGUID, "definitionTwoGUID", "GovernanceDefinition", requestBody.getRelationshipName(), false, false, new Date(), "unlinkPeerDefinitions");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unlinkPeerDefinitions", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkPeerDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSupportingDefinition(String serverName, String userId, String definitionGUID, String supportingDefinitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupSupportingDefinition";
        String definitionOneGUIDParameterName = "definitionGUID";
        String definitionTwoGUIDParameterName = "supportingDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSupportingDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSupportingDefinition");
                GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "setupSupportingDefinition");
                if (requestBody.getProperties() instanceof SupportingDefinitionProperties) {
                    SupportingDefinitionProperties properties = (SupportingDefinitionProperties)requestBody.getProperties();
                    handler.setupDelegationRelationship(userId, definitionGUID, "definitionGUID", "GovernanceDefinition", supportingDefinitionGUID, "supportingDefinitionGUID", "GovernanceDefinition", requestBody.getRelationshipName(), properties.getRationale(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupSupportingDefinition");
                } else if (requestBody.getProperties() == null) {
                    handler.setupDelegationRelationship(userId, definitionGUID, "definitionGUID", "GovernanceDefinition", supportingDefinitionGUID, "supportingDefinitionGUID", "GovernanceDefinition", requestBody.getRelationshipName(), null, null, null, false, false, new Date(), "setupSupportingDefinition");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(SupportingDefinitionProperties.class.getName(), "setupSupportingDefinition");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupSupportingDefinition", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupSupportingDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSupportingDefinition(String serverName, String userId, String definitionGUID, String supportingDefinitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "clearSupportingDefinition";
        String definitionOneGUIDParameterName = "definitionGUID";
        String definitionTwoGUIDParameterName = "supportingDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSupportingDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSupportingDefinition");
                GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "clearSupportingDefinition");
                handler.clearDefinitionRelationship(userId, definitionGUID, "definitionGUID", "GovernanceDefinition", supportingDefinitionGUID, "supportingDefinitionGUID", "GovernanceDefinition", requestBody.getRelationshipName(), false, false, new Date(), "clearSupportingDefinition");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearSupportingDefinition", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSupportingDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

