/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.HashMap;
import org.odpi.openmetadata.accessservices.governanceprogram.handlers.AppointmentHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceRoleProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleHistoryResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.LoggerFactory;

public class GovernanceRolesRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceRolesRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceRole(String serverName, String userId, GovernanceRoleRequestBody requestBody) {
        String methodName = "createGovernanceRole";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceRole");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    GovernanceRoleProperties properties = requestBody.getProperties();
                    String typeName = "GovernanceRole";
                    if (properties.getTypeName() != null) {
                        typeName = properties.getTypeName();
                    }
                    HashMap<String, Integer> extendedProperties = properties.getExtendedProperties();
                    if (properties.getDomainIdentifier() != 0) {
                        if (extendedProperties == null) {
                            extendedProperties = new HashMap<String, Integer>();
                        }
                        extendedProperties.put("domainIdentifier", properties.getDomainIdentifier());
                    }
                    PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "createGovernanceRole");
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceRole");
                    response.setGUID(handler.createPersonRole(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getRoleId(), properties.getTitle(), properties.getDescription(), properties.getScope(), properties.getHeadCount(), properties.getHeadCountLimitSet(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), typeName, extendedProperties, properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createGovernanceRole"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceRoleProperties.class.getName(), "createGovernanceRole");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceRole(String serverName, String userId, String governanceRoleGUID, boolean isMergeUpdate, GovernanceRoleRequestBody requestBody) {
        String methodName = "updateGovernanceRole";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String roleIdParameterName = "roleId";
        String titleParameterName = "title";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    GovernanceRoleProperties properties = requestBody.getProperties();
                    HashMap<String, Integer> extendedProperties = properties.getExtendedProperties();
                    if (properties.getDomainIdentifier() != 0) {
                        if (extendedProperties == null) {
                            extendedProperties = new HashMap<String, Integer>();
                        }
                        extendedProperties.put("domainIdentifier", properties.getDomainIdentifier());
                    }
                    PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "updateGovernanceRole");
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceRole");
                    handler.updatePersonRole(userId, null, null, governanceRoleGUID, "governanceRoleGUID", properties.getQualifiedName(), "roleId", properties.getRoleId(), properties.getTitle(), "title", properties.getDescription(), properties.getScope(), properties.getHeadCount(), properties.getHeadCountLimitSet(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), extendedProperties, isMergeUpdate, null, null, false, false, new Date(), "updateGovernanceRole");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceRoleProperties.class.getName(), "updateGovernanceRole");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkRoleToResponsibility(String serverName, String userId, String governanceRoleGUID, String responsibilityGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkRoleToResponsibility";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String responsibilityGUIDParameterName = "responsibilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkRoleToResponsibility");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "linkRoleToResponsibility");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "linkRoleToResponsibility");
                if (requestBody.getProperties() != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceRoleGUID, "governanceRoleGUID", "PersonRole", responsibilityGUID, "responsibilityGUID", "GovernanceResponsibility", false, false, "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "linkRoleToResponsibility");
                } else {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceRoleGUID, "governanceRoleGUID", "PersonRole", responsibilityGUID, "responsibilityGUID", "GovernanceResponsibility", false, false, "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", (InstanceProperties)null, null, null, new Date(), "linkRoleToResponsibility");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkRoleToResponsibility", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkRoleToResponsibility", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkRoleFromResponsibility(String serverName, String userId, String governanceRoleGUID, String responsibilityGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkRoleToResponsibility";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String responsibilityGUIDParameterName = "responsibilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkRoleToResponsibility");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "unlinkRoleToResponsibility");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkRoleToResponsibility");
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceRoleGUID, "governanceRoleGUID", "PersonRole", responsibilityGUID, "responsibilityGUID", "89a76b24-deb8-45bf-9304-a578a610326f", "GovernanceResponsibility", false, false, "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", new Date(), "unlinkRoleToResponsibility");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unlinkRoleToResponsibility", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkRoleToResponsibility", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkRoleToResource(String serverName, String userId, String governanceRoleGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkRoleToResource";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkRoleToResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "linkRoleToResource");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "linkRoleToResource");
                if (requestBody.getProperties() != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, governanceRoleGUID, "governanceRoleGUID", "PersonRole", false, false, "cb10c107-b7af-475d-aab0-d78b8297b982", "GovernanceRoleAssignment", null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "linkRoleToResource");
                } else {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, governanceRoleGUID, "governanceRoleGUID", "PersonRole", false, false, "cb10c107-b7af-475d-aab0-d78b8297b982", "GovernanceRoleAssignment", (InstanceProperties)null, null, null, new Date(), "linkRoleToResource");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkRoleToResource", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkRoleToResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkRoleFromResource(String serverName, String userId, String governanceRoleGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkRoleToResource";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkRoleToResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "unlinkRoleToResource");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkRoleToResource");
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, governanceRoleGUID, "governanceRoleGUID", "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", false, false, "cb10c107-b7af-475d-aab0-d78b8297b982", "GovernanceRoleAssignment", new Date(), "unlinkRoleToResource");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unlinkRoleToResource", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkRoleToResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceRole(String serverName, String userId, String governanceRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteGovernanceRole";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "deleteGovernanceRole");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceRole");
            if (requestBody != null) {
                handler.removePersonRole(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceRoleGUID, "governanceRoleGUID", false, false, new Date(), "deleteGovernanceRole");
            } else {
                handler.removePersonRole(userId, null, null, governanceRoleGUID, "governanceRoleGUID", false, false, new Date(), "deleteGovernanceRole");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleResponse getGovernanceRoleByGUID(String serverName, String userId, String governanceRoleGUID) {
        String methodName = "getGovernanceRoleByGUID";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceRoleByGUID");
        GovernanceRoleResponse response = new GovernanceRoleResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "getGovernanceRoleByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceRoleByGUID");
            response.setElement((GovernanceRoleElement)handler.getBeanFromRepository(userId, governanceRoleGUID, "governanceRoleGUID", "PersonRole", false, false, new Date(), "getGovernanceRoleByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceRoleByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleHistoryResponse getGovernanceRoleHistoryByGUID(String serverName, String userId, String governanceRoleGUID) {
        String methodName = "getGovernanceRoleHistoryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceRoleHistoryByGUID");
        GovernanceRoleHistoryResponse response = new GovernanceRoleHistoryResponse();
        AuditLog auditLog = null;
        try {
            AppointmentHandler handler = instanceHandler.getAppointmentHandler(userId, serverName, "getGovernanceRoleHistoryByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceRoleHistoryByGUID");
            response.setElement(handler.getGovernanceRoleHistoryByGUID(userId, governanceRoleGUID, "getGovernanceRoleHistoryByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceRoleHistoryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleListResponse getGovernanceRoleByRoleId(String serverName, String userId, String roleId) {
        String methodName = "getGovernanceRoleByRoleId";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceRoleByRoleId");
        GovernanceRoleListResponse response = new GovernanceRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "getGovernanceRoleByRoleId");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceRoleByRoleId");
            response.setElements(handler.getPersonRolesByName(userId, roleId, "governanceRoleGUID", 0, 0, false, false, new Date(), "getGovernanceRoleByRoleId"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceRoleByRoleId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleListResponse getGovernanceRolesByDomainId(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getGovernanceRolesByDomainId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceRolesByDomainId");
        GovernanceRoleListResponse response = new GovernanceRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "getGovernanceRolesByDomainId");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceRolesByDomainId");
            response.setElements(handler.getPersonRolesForDomainId(userId, domainIdentifier, startFrom, pageSize, false, false, new Date(), "getGovernanceRolesByDomainId"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceRolesByDomainId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleListResponse getGovernanceRolesByTitle(String serverName, String userId, String title, int startFrom, int pageSize) {
        String methodName = "getGovernanceRolesByTitle";
        String titleParameterName = "title";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceRolesByTitle");
        GovernanceRoleListResponse response = new GovernanceRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "getGovernanceRolesByTitle");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceRolesByTitle");
            response.setElements(handler.getPersonRolesForTitle(userId, title, "title", startFrom, pageSize, false, false, new Date(), "getGovernanceRolesByTitle"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceRolesByTitle", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleAppointeeListResponse getCurrentGovernanceRoleAppointments(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getActiveGovernanceRoles";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveGovernanceRoles");
        GovernanceRoleAppointeeListResponse response = new GovernanceRoleAppointeeListResponse();
        AuditLog auditLog = null;
        try {
            AppointmentHandler handler = instanceHandler.getAppointmentHandler(userId, serverName, "getActiveGovernanceRoles");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveGovernanceRoles");
            response.setElements(handler.getCurrentGovernanceRoleAppointments(userId, domainIdentifier, startFrom, pageSize, "getActiveGovernanceRoles"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveGovernanceRoles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse appointGovernanceRole(String serverName, String userId, String governanceRoleGUID, AppointmentRequestBody requestBody) {
        String methodName = "appointGovernanceRole";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "appointGovernanceRole");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "appointGovernanceRole");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "appointGovernanceRole");
                String appointmentGUID = handler.appointPersonToRole(userId, null, null, requestBody.getProfileGUID(), "profileGUID", governanceRoleGUID, "governanceRoleGUID", true, requestBody.getEffectiveDate(), null, false, false, null, "appointGovernanceRole");
                response.setGUID(appointmentGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "appointGovernanceRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "appointGovernanceRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse relieveGovernanceRole(String serverName, String userId, String governanceRoleGUID, String appointmentGUID, AppointmentRequestBody requestBody) {
        String methodName = "relieveGovernanceRole";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String profileGUIDParameterName = "profileGUID";
        String appointmentGUIDParameterName = "appointmentGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "relieveGovernanceRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "relieveGovernanceRole");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "relieveGovernanceRole");
                handler.relievePersonFromRole(userId, null, null, requestBody.getProfileGUID(), "profileGUID", governanceRoleGUID, "governanceRoleGUID", appointmentGUID, "appointmentGUID", requestBody.getEffectiveDate(), null, "relieveGovernanceRole");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "relieveGovernanceRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "relieveGovernanceRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

