/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.AssignmentScopeProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ResourceListProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.StakeholderProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class RelatedElementRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RelatedElementRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setupMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupMoreInformation");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupMoreInformation");
                } else {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", null, null, false, false, new Date(), "setupMoreInformation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupMoreInformation", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearMoreInformation");
            if (requestBody != null) {
                handler.removeMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            } else {
                handler.removeMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getMoreInformation(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMoreInformation");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getMoreInformation");
            response.setElementList(handler.getMoreInformation(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getMoreInformation"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getDescriptiveElements(String serverName, String userId, String detailGUID, int startFrom, int pageSize) {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDescriptiveElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDescriptiveElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getDescriptiveElements");
            response.setElementList(handler.getDescriptiveElements(userId, detailGUID, "detailGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getDescriptiveElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDescriptiveElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernedBy(String serverName, String userId, String elementGUID, String governanceDefinitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernedBy";
        String elementGUIDParameterName = "elementGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernedBy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernedBy");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupGovernedBy");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addGovernedBy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernedBy");
                } else {
                    handler.addGovernedBy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", null, null, false, false, new Date(), "setupGovernedBy");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupGovernedBy", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupGovernedBy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernedBy(String serverName, String userId, String elementGUID, String governanceDefinitionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernedBy";
        String elementGUIDParameterName = "elementGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernedBy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernedBy");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearGovernedBy");
            if (requestBody != null) {
                handler.removeGovernedBy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", false, false, new Date(), "clearGovernedBy");
            } else {
                handler.removeGovernedBy(userId, null, null, governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", false, false, new Date(), "clearGovernedBy");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernedBy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionListResponse getGovernanceDefinitionsForElement(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionsForElement";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionsForElement");
        GovernanceDefinitionListResponse response = new GovernanceDefinitionListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionsForElement");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernanceDefinitionsForElement");
            response.setElements(handler.getGoverningDefinitions(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "GovernanceDefinition", startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionsForElement"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionsForElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getGovernedElements(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize) {
        String methodName = "getGovernedElements";
        String guidPropertyName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernedElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getGovernedElements");
            response.setElementList(handler.getGovernedElements(userId, governanceDefinitionGUID, "governanceDefinitionGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getGovernedElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernanceDefinitionScope(String serverName, String userId, String governanceDefinitionGUID, String scopeGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernanceDefinitionScope";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernanceDefinitionScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernanceDefinitionScope");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupGovernanceDefinitionScope");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addGovernanceDefinitionScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernanceDefinitionScope");
                } else {
                    handler.addGovernanceDefinitionScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", null, null, false, false, new Date(), "setupGovernanceDefinitionScope");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupGovernanceDefinitionScope", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupGovernanceDefinitionScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceDefinitionScope(String serverName, String userId, String governanceDefinitionGUID, String scopeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceDefinitionScope";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceDefinitionScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceDefinitionScope");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearGovernanceDefinitionScope");
            if (requestBody != null) {
                handler.removeGovernanceDefinitionScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearGovernanceDefinitionScope");
            } else {
                handler.removeGovernanceDefinitionScope(userId, null, null, governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearGovernanceDefinitionScope");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceDefinitionScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getGovernanceDefinitionScopes(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionScopes";
        String guidPropertyName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionScopes");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionScopes");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getGovernanceDefinitionScopes");
            response.setElementList(handler.getGovernanceDefinitionScope(userId, governanceDefinitionGUID, "governanceDefinitionGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionScopes"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceDefinitionScopes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionListResponse getScopedGovernanceDefinitions(String serverName, String userId, String scopeGUID, int startFrom, int pageSize) {
        String methodName = "getScopedGovernanceDefinitions";
        String guidPropertyName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getScopedGovernanceDefinitions");
        GovernanceDefinitionListResponse response = new GovernanceDefinitionListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getScopedGovernanceDefinitions");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getScopedGovernanceDefinitions");
            response.setElements(handler.getScopedGovernanceDefinitions(userId, scopeGUID, "scopeGUID", OpenMetadataType.REFERENCEABLE.typeName, "GovernanceDefinition", startFrom, pageSize, false, false, new Date(), "getScopedGovernanceDefinitions"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getScopedGovernanceDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernanceResponsibilityAssignment(String serverName, String userId, String governanceResponsibilityGUID, String personRoleGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernanceResponsibilityAssignment";
        String governanceResponsibilityGUIDParameterName = "governanceResponsibilityGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernanceResponsibilityAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernanceResponsibilityAssignment");
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "setupGovernanceResponsibilityAssignment");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addGovernanceResponsibility(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personRoleGUID, "personRoleGUID", governanceResponsibilityGUID, "governanceResponsibilityGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernanceResponsibilityAssignment");
                } else {
                    handler.addGovernanceResponsibility(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personRoleGUID, "personRoleGUID", governanceResponsibilityGUID, "governanceResponsibilityGUID", null, null, false, false, new Date(), "setupGovernanceResponsibilityAssignment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupGovernanceResponsibilityAssignment", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupGovernanceResponsibilityAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceResponsibilityAssignment(String serverName, String userId, String governanceResponsibilityGUID, String personRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceResponsibilityAssignment";
        String governanceResponsibilityGUIDParameterName = "governanceResponsibilityGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceResponsibilityAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceResponsibilityAssignment");
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "clearGovernanceResponsibilityAssignment");
            if (requestBody != null) {
                handler.removeGovernanceResponsibility(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceResponsibilityGUID, "governanceResponsibilityGUID", personRoleGUID, "personRoleGUID", false, false, new Date(), "clearGovernanceResponsibilityAssignment");
            } else {
                handler.removeGovernanceResponsibility(userId, null, null, governanceResponsibilityGUID, "governanceResponsibilityGUID", personRoleGUID, "personRoleGUID", false, false, new Date(), "clearGovernanceResponsibilityAssignment");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGovernanceResponsibilityAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRoleListResponse getResponsibleRoles(String serverName, String userId, String governanceResponsibilityGUID, int startFrom, int pageSize) {
        String methodName = "getResponsibleRoles";
        String guidPropertyName = "governanceResponsibilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResponsibleRoles");
        GovernanceRoleListResponse response = new GovernanceRoleListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResponsibleRoles");
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "getResponsibleRoles");
            response.setElements(handler.getRolesWithGovernanceResponsibility(userId, governanceResponsibilityGUID, "governanceResponsibilityGUID", startFrom, pageSize, false, false, new Date(), "getResponsibleRoles"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getResponsibleRoles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionListResponse getRoleResponsibilities(String serverName, String userId, String personRoleGUID, int startFrom, int pageSize) {
        String methodName = "getRoleResponsibilities";
        String guidPropertyName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRoleResponsibilities");
        GovernanceDefinitionListResponse response = new GovernanceDefinitionListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRoleResponsibilities");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getRoleResponsibilities");
            response.setElements(handler.getGovernanceResponsibilitiesForRole(userId, personRoleGUID, "personRoleGUID", startFrom, pageSize, false, false, new Date(), "getRoleResponsibilities"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRoleResponsibilities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupStakeholder");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupStakeholder");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof StakeholderProperties) {
                    StakeholderProperties properties = (StakeholderProperties)requestBody.getProperties();
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", properties.getStakeholderRole(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupStakeholder");
                } else if (requestBody.getProperties() == null) {
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", null, null, null, false, false, new Date(), "setupStakeholder");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(StakeholderProperties.class.getName(), "setupStakeholder");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupStakeholder", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearStakeholder");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearStakeholder");
            if (requestBody != null) {
                handler.removeStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            } else {
                handler.removeStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getStakeholders(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholders");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholders");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholders");
            response.setElementList(handler.getStakeholders(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholders"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getStakeholders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getStakeholderCommissionedElements(String serverName, String userId, String stakeholderGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholderCommissionedElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholderCommissionedElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholderCommissionedElements");
            response.setElementList(handler.getCommissionedByStakeholder(userId, stakeholderGUID, "stakeholderGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholderCommissionedElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getStakeholderCommissionedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssignmentScope(String serverName, String userId, String elementGUID, String scopeGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssignmentScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssignmentScope");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupAssignmentScope");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof AssignmentScopeProperties) {
                    AssignmentScopeProperties properties = (AssignmentScopeProperties)requestBody.getProperties();
                    handler.addAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", properties.getAssignmentType(), properties.getDescription(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupAssignmentScope");
                } else if (requestBody.getProperties() == null) {
                    handler.addAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", null, null, null, null, false, false, new Date(), "setupAssignmentScope");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(AssignmentScopeProperties.class.getName(), "setupAssignmentScope");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAssignmentScope", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAssignmentScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssignmentScope(String serverName, String userId, String elementGUID, String scopeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssignmentScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssignmentScope");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearAssignmentScope");
            if (requestBody != null) {
                handler.removeAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearAssignmentScope");
            } else {
                handler.removeAssignmentScope(userId, null, null, elementGUID, "elementGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearAssignmentScope");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAssignmentScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getAssignedScopes(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getAssignedScopes";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssignedScopes");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedScopes");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssignedScopes");
            response.setElementList(handler.getAssignmentScope(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getAssignedScopes"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssignedScopes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getAssignedActors(String serverName, String userId, String scopeGUID, int startFrom, int pageSize) {
        String methodName = "getAssignedActors";
        String guidPropertyName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssignedActors");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedActors");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssignedActors");
            response.setElementList(handler.getAssignedActors(userId, scopeGUID, "scopeGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getAssignedActors"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssignedActors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupResource(String serverName, String userId, String elementGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupResource");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ResourceListProperties) {
                    ResourceListProperties properties = (ResourceListProperties)relationshipProperties;
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", properties.getResourceUse(), properties.getResourceUseDescription(), properties.getResourceUseProperties(), properties.getWatchResource(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupResource");
                } else if (requestBody.getProperties() == null) {
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", null, null, null, false, null, null, false, false, new Date(), "setupResource");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearResource(String serverName, String userId, String elementGUID, String resourceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearResource");
            if (requestBody != null) {
                handler.removeResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            } else {
                handler.removeResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getResourceList(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResourceList");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceList");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getResourceList");
            response.setElementList(handler.getResourceList(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getResourceList"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getResourceList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getSupportedByResource(String serverName, String userId, String resourceGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSupportedByResource");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSupportedByResource");
            response.setElementList(handler.getSupportedByResource(userId, resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getSupportedByResource"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSupportedByResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

