/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.handlers;

import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDomain;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GovernanceProgramEnumHandler {
    private static final Logger log = LoggerFactory.getLogger(GovernanceProgramEnumHandler.class);
    private final String serviceName;
    private final OMRSRepositoryHelper repositoryHelper;

    GovernanceProgramEnumHandler(String serviceName, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.repositoryHelper = repositoryHelper;
    }

    InstanceProperties addGovernanceDomainToProperties(InstanceProperties properties, GovernanceDomain governanceDomain, String propertyName, String methodName) {
        int ordinal = 999;
        String symbolicName = null;
        String description = null;
        log.debug("Governance domain: " + governanceDomain.getName());
        boolean element1Ordinal = false;
        String element1Value = "Unclassified";
        String element1Description = "The governance domain is not specified.";
        boolean element2Ordinal = true;
        String element2Value = "Data";
        String element2Description = "The data (information) governance domain.";
        int element3Ordinal = 2;
        String element3Value = "Privacy";
        String element3Description = "The data privacy domain.";
        int element4Ordinal = 3;
        String element4Value = "Security";
        String element4Description = "The security governance domain.";
        int element5Ordinal = 4;
        String element5Value = "ITInfrastructure";
        String element5Description = "The IT infrastructure governance domain.";
        int element6Ordinal = 5;
        String element6Value = "SoftwareDevelopment";
        String element6Description = "The software development lifecycle governance domain.";
        int element7Ordinal = 6;
        String element7Value = "Corporate";
        String element7Description = "The corporate governance domain.";
        int element8Ordinal = 7;
        String element8Value = "AssetManagement";
        String element8Description = "The physical asset management governance domain.";
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another governance domain.";
        switch (governanceDomain) {
            case UNCLASSIFIED: {
                ordinal = 0;
                symbolicName = "Unclassified";
                description = "The governance domain is not specified.";
                break;
            }
            case DATA: {
                ordinal = 1;
                symbolicName = "Data";
                description = "The data (information) governance domain.";
                break;
            }
            case PRIVACY: {
                ordinal = 2;
                symbolicName = "Privacy";
                description = "The data privacy domain.";
                break;
            }
            case SECURITY: {
                ordinal = 3;
                symbolicName = "Security";
                description = "The security governance domain.";
                break;
            }
            case IT_INFRASTRUCTURE: {
                ordinal = 4;
                symbolicName = "ITInfrastructure";
                description = "The IT infrastructure governance domain.";
                break;
            }
            case SOFTWARE_DEVELOPMENT: {
                ordinal = 5;
                symbolicName = "SoftwareDevelopment";
                description = "The software development lifecycle governance domain.";
                break;
            }
            case CORPORATE: {
                ordinal = 6;
                symbolicName = "Corporate";
                description = "The corporate governance domain.";
                break;
            }
            case ASSET_MANAGEMENT: {
                ordinal = 7;
                symbolicName = "AssetManagement";
                description = "The physical asset management governance domain.";
                break;
            }
            case OTHER: {
                ordinal = 99;
                symbolicName = "Other";
                description = "Another governance domain.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, propertyName, GovernanceDomain.getOpenTypeGUID(), GovernanceDomain.getOpenTypeName(), ordinal, symbolicName, description, methodName);
    }

    GovernanceDomain getGovernanceDomainFromProperties(InstanceProperties properties, String propertyName, String methodName) {
        InstancePropertyValue instancePropertyValue;
        GovernanceDomain governanceDomain = GovernanceDomain.OTHER;
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceDomain = GovernanceDomain.UNCLASSIFIED;
                    break;
                }
                case 1: {
                    governanceDomain = GovernanceDomain.DATA;
                    break;
                }
                case 2: {
                    governanceDomain = GovernanceDomain.PRIVACY;
                    break;
                }
                case 3: {
                    governanceDomain = GovernanceDomain.SECURITY;
                    break;
                }
                case 4: {
                    governanceDomain = GovernanceDomain.IT_INFRASTRUCTURE;
                    break;
                }
                case 5: {
                    governanceDomain = GovernanceDomain.SOFTWARE_DEVELOPMENT;
                    break;
                }
                case 6: {
                    governanceDomain = GovernanceDomain.CORPORATE;
                    break;
                }
                case 7: {
                    governanceDomain = GovernanceDomain.ASSET_MANAGEMENT;
                    break;
                }
                case 99: {
                    governanceDomain = GovernanceDomain.OTHER;
                }
            }
        }
        log.debug("Governance domain: " + governanceDomain.getName() + " for method " + methodName);
        return governanceDomain;
    }
}

