/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceZoneDefinitionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceZoneResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceZonesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ElementStubConverter;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceZoneHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceZoneDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceZoneElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceZoneProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.LoggerFactory;

public class GovernanceZoneRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceZoneRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceZone(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createGovernanceZone";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceZone");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof GovernanceZoneProperties) {
                    GovernanceZoneProperties properties = (GovernanceZoneProperties)referenceableProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceZone");
                    GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "createGovernanceZone");
                    String zoneGUID = handler.createGovernanceZone(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getZoneName(), properties.getDisplayName(), properties.getDescription(), properties.getCriteria(), properties.getScope(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), new Date(), "createGovernanceZone");
                    response.setGUID(zoneGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceZoneProperties.class.getName(), "createGovernanceZone");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceZone", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createGovernanceZone", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceZone(String serverName, String userId, String zoneGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateGovernanceZone";
        String guidParameter = "zoneGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceZone");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof GovernanceZoneProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceZone");
                    GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "updateGovernanceZone");
                    GovernanceZoneProperties properties = (GovernanceZoneProperties)requestBody.getProperties();
                    handler.updateGovernanceZone(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), zoneGUID, "zoneGUID", properties.getQualifiedName(), properties.getZoneName(), properties.getDisplayName(), properties.getDescription(), properties.getCriteria(), properties.getScope(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), isMergeUpdate, "updateGovernanceZone");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GovernanceZoneProperties.class.getName(), "updateGovernanceZone");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceZone", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateGovernanceZone", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceZone(String serverName, String userId, String zoneGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteGovernanceZone";
        String guidParameter = "zoneGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceZone");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceZone");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "deleteGovernanceZone");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, false, null, null, false, false, new Date(), "deleteGovernanceZone");
            } else {
                handler.deleteBeanInRepository(userId, null, null, zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, false, null, null, false, false, new Date(), "deleteGovernanceZone");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteGovernanceZone", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkZonesInHierarchy(String serverName, String userId, String parentZoneGUID, String childZoneGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkZonesInHierarchy";
        String parentZoneGUIDParameterName = "parentZoneGUID";
        String childZoneGUIDParameterName = "childZoneGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkZonesInHierarchy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkZonesInHierarchy");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "linkZonesInHierarchy");
            if (requestBody.getProperties() != null) {
                handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentZoneGUID, "parentZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, childZoneGUID, "childZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeName, null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "linkZonesInHierarchy");
            } else {
                handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentZoneGUID, "parentZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, childZoneGUID, "childZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkZonesInHierarchy");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkZonesInHierarchy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkZonesInHierarchy(String serverName, String userId, String parentZoneGUID, String childZoneGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkZonesInHierarchy";
        String parentZoneGUIDParameterName = "parentZoneGUID";
        String childZoneGUIDParameterName = "childZoneGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkZonesInHierarchy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkZonesInHierarchy");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "unlinkZonesInHierarchy");
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentZoneGUID, "parentZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, childZoneGUID, "childZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeName, null, "unlinkZonesInHierarchy");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, parentZoneGUID, "parentZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, childZoneGUID, "childZoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeName, null, "unlinkZonesInHierarchy");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unlinkZonesInHierarchy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkZoneToGovernanceDefinition(String serverName, String userId, String zoneGUID, String definitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkZoneToGovernanceDefinition";
        String zoneGUIDParameterName = "zoneGUID";
        String definitionGUIDParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkZoneToGovernanceDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkZoneToGovernanceDefinition");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "linkZoneToGovernanceDefinition");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "linkZoneToGovernanceDefinition");
                } else {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkZoneToGovernanceDefinition");
                }
            } else {
                handler.linkElementToElement(userId, null, null, zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkZoneToGovernanceDefinition");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkZoneToGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkZoneFromGovernanceDefinition(String serverName, String userId, String zoneGUID, String definitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkZoneToGovernanceDefinition";
        String zoneGUIDParameterName = "zoneGUID";
        String definitionGUIDParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkZoneToGovernanceDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkZoneToGovernanceDefinition");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "unlinkZoneToGovernanceDefinition");
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, null, "unlinkZoneToGovernanceDefinition");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, null, "unlinkZoneToGovernanceDefinition");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unlinkZoneToGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceZoneResponse getGovernanceZoneByGUID(String serverName, String userId, String zoneGUID) {
        String methodName = "getGovernanceZoneByGUID";
        String zoneGUIDParameterName = "zoneGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZoneByGUID");
        GovernanceZoneResponse response = new GovernanceZoneResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZoneByGUID");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZoneByGUID");
            response.setElement((GovernanceZoneElement)handler.getBeanFromRepository(userId, zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, new Date(), "getGovernanceZoneByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernanceZoneByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceZoneResponse getGovernanceZoneByName(String serverName, String userId, String qualifiedName) {
        String methodName = "getGovernanceZoneByName";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZoneByName");
        GovernanceZoneResponse response = new GovernanceZoneResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZoneByName");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZoneByName");
            response.setElement((GovernanceZoneElement)handler.getGovernanceZone(userId, qualifiedName, "qualifiedName", "getGovernanceZoneByName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernanceZoneByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceZonesResponse getGovernanceZonesForDomain(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getGovernanceZonesForDomain";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZonesForDomain");
        GovernanceZonesResponse response = new GovernanceZonesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZonesForDomain");
            GovernanceZoneHandler<GovernanceZoneElement> handler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZonesForDomain");
            List zones = handler.getGovernanceZonesByDomain(userId, domainIdentifier, startFrom, pageSize, "getGovernanceZonesForDomain");
            response.setGovernanceZone(zones);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernanceZonesForDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceZoneDefinitionResponse getGovernanceZoneDefinitionByGUID(String serverName, String userId, String zoneGUID) {
        String methodName = "getGovernanceZoneDefinitionByGUID";
        String zoneGUIDParameterName = "zoneGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceZoneDefinitionByGUID");
        GovernanceZoneDefinitionResponse response = new GovernanceZoneDefinitionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceZoneDefinitionByGUID");
            GovernanceZoneHandler<GovernanceZoneElement> zoneHandler = instanceHandler.getGovernanceZoneHandler(userId, serverName, "getGovernanceZoneDefinitionByGUID");
            GovernanceZoneElement element = (GovernanceZoneElement)zoneHandler.getBeanFromRepository(userId, zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, new Date(), "getGovernanceZoneDefinitionByGUID");
            if (element != null) {
                GovernanceZoneDefinition zoneDefinition = new GovernanceZoneDefinition(element);
                ElementStubConverter<ElementStub> elementStubConverter = instanceHandler.getElementStubConverter(userId, serverName, "getGovernanceZoneDefinitionByGUID");
                Relationship relationship = zoneHandler.getGovernanceZoneParentGUID(userId, zoneGUID, "zoneGUID", "getGovernanceZoneDefinitionByGUID");
                if (relationship != null) {
                    zoneDefinition.setParentGovernanceZone((ElementStub)elementStubConverter.getNewBean(ElementStub.class, relationship, true, "getGovernanceZoneDefinitionByGUID"));
                }
                List relationships = zoneHandler.getGovernanceZoneChildrenGUIDs(userId, zoneGUID, "zoneGUID", "getGovernanceZoneDefinitionByGUID");
                zoneDefinition.setNestedGovernanceZones(elementStubConverter.getNewBeans(ElementStub.class, relationships, false, "getGovernanceZoneDefinitionByGUID"));
                GovernanceDefinitionHandler<GovernanceDefinitionElement> definitionHandler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernanceZoneDefinitionByGUID");
                relationships = definitionHandler.getGoverningDefinitionLinks(userId, zoneGUID, "zoneGUID", OpenMetadataType.GOVERNANCE_ZONE.typeName, null, 0, 0, false, false, new Date(), "getGovernanceZoneDefinitionByGUID");
                zoneDefinition.setAssociatedGovernanceDefinitions(elementStubConverter.getNewBeans(ElementStub.class, relationships, true, "getGovernanceZoneDefinitionByGUID"));
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernanceZoneDefinitionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

