/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.AssignmentScopeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.StakeholderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class RelatedElementRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RelatedElementRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setupMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupMoreInformation");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupMoreInformation");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupMoreInformation");
                } else {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", null, null, false, false, new Date(), "setupMoreInformation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupMoreInformation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearMoreInformation");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearMoreInformation");
            if (requestBody != null) {
                handler.removeMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            } else {
                handler.removeMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getMoreInformation(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMoreInformation");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getMoreInformation");
            response.setElements(handler.getMoreInformation(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getMoreInformation"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getDescriptiveElements(String serverName, String userId, String detailGUID, int startFrom, int pageSize) {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDescriptiveElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDescriptiveElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getDescriptiveElements");
            response.setElements(handler.getDescriptiveElements(userId, detailGUID, "detailGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getDescriptiveElements"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDescriptiveElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernedBy(String serverName, String userId, String elementGUID, String governanceDefinitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernedBy";
        String elementGUIDParameterName = "elementGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernedBy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernedBy");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupGovernedBy");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addGovernedBy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernedBy");
                } else {
                    handler.addGovernedBy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", null, null, false, false, new Date(), "setupGovernedBy");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupGovernedBy", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupGovernedBy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernedBy(String serverName, String userId, String elementGUID, String governanceDefinitionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernedBy";
        String elementGUIDParameterName = "elementGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernedBy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernedBy");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearGovernedBy");
            if (requestBody != null) {
                handler.removeGovernedBy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", false, false, new Date(), "clearGovernedBy");
            } else {
                handler.removeGovernedBy(userId, null, null, governanceDefinitionGUID, "governanceDefinitionGUID", elementGUID, "elementGUID", false, false, new Date(), "clearGovernedBy");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGovernedBy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionsResponse getGovernanceDefinitionsForElement(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionsForElement";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionsForElement");
        GovernanceDefinitionsResponse response = new GovernanceDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionsForElement");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernanceDefinitionsForElement");
            response.setElements(handler.getGoverningDefinitions(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionsForElement"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernanceDefinitionsForElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getGovernedElements(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize) {
        String methodName = "getGovernedElements";
        String guidPropertyName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernedElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getGovernedElements");
            response.setElements(handler.getGovernedElements(userId, governanceDefinitionGUID, "governanceDefinitionGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getGovernedElements"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernanceDefinitionScope(String serverName, String userId, String governanceDefinitionGUID, String scopeGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernanceDefinitionScope";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernanceDefinitionScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernanceDefinitionScope");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupGovernanceDefinitionScope");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addGovernanceDefinitionScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernanceDefinitionScope");
                } else {
                    handler.addGovernanceDefinitionScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", null, null, false, false, new Date(), "setupGovernanceDefinitionScope");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupGovernanceDefinitionScope", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupGovernanceDefinitionScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceDefinitionScope(String serverName, String userId, String governanceDefinitionGUID, String scopeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceDefinitionScope";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceDefinitionScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceDefinitionScope");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearGovernanceDefinitionScope");
            if (requestBody != null) {
                handler.removeGovernanceDefinitionScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearGovernanceDefinitionScope");
            } else {
                handler.removeGovernanceDefinitionScope(userId, null, null, governanceDefinitionGUID, "governanceDefinitionGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearGovernanceDefinitionScope");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGovernanceDefinitionScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getGovernanceDefinitionScopes(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize) {
        String methodName = "getGovernanceDefinitionScopes";
        String guidPropertyName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceDefinitionScopes");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceDefinitionScopes");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getGovernanceDefinitionScopes");
            response.setElements(handler.getGovernanceDefinitionScope(userId, governanceDefinitionGUID, "governanceDefinitionGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getGovernanceDefinitionScopes"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernanceDefinitionScopes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionsResponse getScopedGovernanceDefinitions(String serverName, String userId, String scopeGUID, int startFrom, int pageSize) {
        String methodName = "getScopedGovernanceDefinitions";
        String guidPropertyName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getScopedGovernanceDefinitions");
        GovernanceDefinitionsResponse response = new GovernanceDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getScopedGovernanceDefinitions");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getScopedGovernanceDefinitions");
            response.setElements(handler.getScopedGovernanceDefinitions(userId, scopeGUID, "scopeGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, startFrom, pageSize, false, false, new Date(), "getScopedGovernanceDefinitions"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getScopedGovernanceDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupGovernanceResponsibilityAssignment(String serverName, String userId, String governanceResponsibilityGUID, String personRoleGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupGovernanceResponsibilityAssignment";
        String governanceResponsibilityGUIDParameterName = "governanceResponsibilityGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupGovernanceResponsibilityAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupGovernanceResponsibilityAssignment");
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "setupGovernanceResponsibilityAssignment");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addGovernanceResponsibility(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personRoleGUID, "personRoleGUID", governanceResponsibilityGUID, "governanceResponsibilityGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupGovernanceResponsibilityAssignment");
                } else {
                    handler.addGovernanceResponsibility(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personRoleGUID, "personRoleGUID", governanceResponsibilityGUID, "governanceResponsibilityGUID", null, null, false, false, new Date(), "setupGovernanceResponsibilityAssignment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupGovernanceResponsibilityAssignment", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupGovernanceResponsibilityAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGovernanceResponsibilityAssignment(String serverName, String userId, String governanceResponsibilityGUID, String personRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearGovernanceResponsibilityAssignment";
        String governanceResponsibilityGUIDParameterName = "governanceResponsibilityGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGovernanceResponsibilityAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGovernanceResponsibilityAssignment");
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "clearGovernanceResponsibilityAssignment");
            if (requestBody != null) {
                handler.removeGovernanceResponsibility(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), governanceResponsibilityGUID, "governanceResponsibilityGUID", personRoleGUID, "personRoleGUID", false, false, new Date(), "clearGovernanceResponsibilityAssignment");
            } else {
                handler.removeGovernanceResponsibility(userId, null, null, governanceResponsibilityGUID, "governanceResponsibilityGUID", personRoleGUID, "personRoleGUID", false, false, new Date(), "clearGovernanceResponsibilityAssignment");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGovernanceResponsibilityAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceRolesResponse getResponsibleRoles(String serverName, String userId, String governanceResponsibilityGUID, int startFrom, int pageSize) {
        String methodName = "getResponsibleRoles";
        String guidPropertyName = "governanceResponsibilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResponsibleRoles");
        GovernanceRolesResponse response = new GovernanceRolesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResponsibleRoles");
            PersonRoleHandler<GovernanceRoleElement> handler = instanceHandler.getGovernanceRoleHandler(userId, serverName, "getResponsibleRoles");
            response.setElements(handler.getRolesWithGovernanceResponsibility(userId, governanceResponsibilityGUID, "governanceResponsibilityGUID", startFrom, pageSize, false, false, new Date(), "getResponsibleRoles"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getResponsibleRoles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionsResponse getRoleResponsibilities(String serverName, String userId, String personRoleGUID, int startFrom, int pageSize) {
        String methodName = "getRoleResponsibilities";
        String guidPropertyName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRoleResponsibilities");
        GovernanceDefinitionsResponse response = new GovernanceDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRoleResponsibilities");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getRoleResponsibilities");
            response.setElements(handler.getGovernanceResponsibilitiesForRole(userId, personRoleGUID, "personRoleGUID", startFrom, pageSize, false, false, new Date(), "getRoleResponsibilities"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRoleResponsibilities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupStakeholder");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupStakeholder");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof StakeholderProperties) {
                    StakeholderProperties properties = (StakeholderProperties)relationshipProperties;
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", properties.getStakeholderRole(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupStakeholder");
                } else if (requestBody.getProperties() == null) {
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", null, null, null, false, false, new Date(), "setupStakeholder");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(StakeholderProperties.class.getName(), "setupStakeholder");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupStakeholder", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearStakeholder");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearStakeholder");
            if (requestBody != null) {
                handler.removeStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            } else {
                handler.removeStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getStakeholders(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholders");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholders");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholders");
            response.setElements(handler.getStakeholders(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholders"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getStakeholders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getStakeholderCommissionedElements(String serverName, String userId, String stakeholderGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholderCommissionedElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholderCommissionedElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholderCommissionedElements");
            response.setElements(handler.getCommissionedByStakeholder(userId, stakeholderGUID, "stakeholderGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholderCommissionedElements"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getStakeholderCommissionedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssignmentScope(String serverName, String userId, String elementGUID, String scopeGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssignmentScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssignmentScope");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupAssignmentScope");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof AssignmentScopeProperties) {
                    AssignmentScopeProperties properties = (AssignmentScopeProperties)relationshipProperties;
                    handler.addAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", properties.getAssignmentType(), properties.getDescription(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupAssignmentScope");
                } else if (requestBody.getProperties() == null) {
                    handler.addAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", null, null, null, null, false, false, new Date(), "setupAssignmentScope");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(AssignmentScopeProperties.class.getName(), "setupAssignmentScope");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAssignmentScope", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupAssignmentScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssignmentScope(String serverName, String userId, String elementGUID, String scopeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssignmentScope");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssignmentScope");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearAssignmentScope");
            if (requestBody != null) {
                handler.removeAssignmentScope(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearAssignmentScope");
            } else {
                handler.removeAssignmentScope(userId, null, null, elementGUID, "elementGUID", scopeGUID, "scopeGUID", false, false, new Date(), "clearAssignmentScope");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAssignmentScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getAssignedScopes(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getAssignedScopes";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssignedScopes");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedScopes");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssignedScopes");
            response.setElements(handler.getAssignmentScope(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getAssignedScopes"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssignedScopes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getAssignedActors(String serverName, String userId, String scopeGUID, int startFrom, int pageSize) {
        String methodName = "getAssignedActors";
        String guidPropertyName = "scopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssignedActors");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedActors");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssignedActors");
            response.setElements(handler.getAssignedActors(userId, scopeGUID, "scopeGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getAssignedActors"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssignedActors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupResource(String serverName, String userId, String elementGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupResource");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ResourceListProperties) {
                    ResourceListProperties properties = (ResourceListProperties)relationshipProperties;
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", properties.getResourceUse(), properties.getResourceUseDescription(), properties.getResourceUseProperties(), properties.getWatchResource(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupResource");
                } else if (requestBody.getProperties() == null) {
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", null, null, null, false, null, null, false, false, new Date(), "setupResource");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearResource(String serverName, String userId, String elementGUID, String resourceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearResource");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearResource");
            if (requestBody != null) {
                handler.removeResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            } else {
                handler.removeResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getResourceList(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResourceList");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceList");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getResourceList");
            response.setElements(handler.getResourceList(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getResourceList"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getResourceList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSupportedByResource(String serverName, String userId, String resourceGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSupportedByResource");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByResource");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSupportedByResource");
            response.setElements(handler.getSupportedByResource(userId, resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getSupportedByResource"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSupportedByResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

