/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SubjectAreaResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SubjectAreasResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ElementStubConverter;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SubjectAreaHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SubjectAreaDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SubjectAreaElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.LoggerFactory;

public class SubjectAreaRESTServices {
    private static final GovernanceProgramInstanceHandler instanceHandler = new GovernanceProgramInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SubjectAreaRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createSubjectArea(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSubjectArea");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof SubjectAreaProperties) {
                    SubjectAreaProperties properties = (SubjectAreaProperties)referenceableProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createSubjectArea");
                    SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "createSubjectArea");
                    String subjectAreaGUID = handler.createSubjectArea(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getSubjectAreaName(), properties.getDisplayName(), properties.getDescription(), properties.getUsage(), properties.getScope(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), new Date(), "createSubjectArea");
                    response.setGUID(subjectAreaGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaProperties.class.getName(), "createSubjectArea");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSubjectArea", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSubjectArea(String serverName, String userId, String subjectAreaGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateSubjectArea";
        String guidParameter = "subjectAreaGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof SubjectAreaProperties) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSubjectArea");
                    SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "updateSubjectArea");
                    SubjectAreaProperties properties = (SubjectAreaProperties)requestBody.getProperties();
                    handler.updateSubjectArea(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), subjectAreaGUID, "subjectAreaGUID", properties.getQualifiedName(), properties.getSubjectAreaName(), properties.getDisplayName(), properties.getDescription(), properties.getUsage(), properties.getScope(), properties.getDomainIdentifier(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), isMergeUpdate, "updateSubjectArea");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaProperties.class.getName(), "updateSubjectArea");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSubjectArea", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteSubjectArea(String serverName, String userId, String subjectAreaGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteSubjectArea";
        String guidParameter = "subjectAreaGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteSubjectArea");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "deleteSubjectArea");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, null, null, false, false, new Date(), "deleteSubjectArea");
            } else {
                handler.deleteBeanInRepository(userId, null, null, subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.descriptionGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, null, null, false, false, new Date(), "deleteSubjectArea");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkSubjectAreasInHierarchy(String serverName, String userId, String parentSubjectAreaGUID, String childSubjectAreaGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkSubjectAreasInHierarchy";
        String parentSubjectAreaGUIDParameterName = "parentSubjectAreaGUID";
        String childSubjectAreaGUIDParameterName = "childSubjectAreaGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkSubjectAreasInHierarchy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkSubjectAreasInHierarchy");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "linkSubjectAreasInHierarchy");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentSubjectAreaGUID, "parentSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, childSubjectAreaGUID, "childSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "linkSubjectAreasInHierarchy");
                } else {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentSubjectAreaGUID, "parentSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, childSubjectAreaGUID, "childSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkSubjectAreasInHierarchy");
                }
            } else {
                handler.linkElementToElement(userId, null, null, parentSubjectAreaGUID, "parentSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, childSubjectAreaGUID, "childSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkSubjectAreasInHierarchy");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkSubjectAreasInHierarchy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkSubjectAreasInHierarchy(String serverName, String userId, String parentSubjectAreaGUID, String childSubjectAreaGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkSubjectAreasInHierarchy";
        String parentSubjectAreaGUIDParameterName = "parentSubjectAreaGUID";
        String childSubjectAreaGUIDParameterName = "childSubjectAreaGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkSubjectAreasInHierarchy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkSubjectAreasInHierarchy");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "unlinkSubjectAreasInHierarchy");
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentSubjectAreaGUID, "parentSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, childSubjectAreaGUID, "childSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, null, "unlinkSubjectAreasInHierarchy");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, parentSubjectAreaGUID, "parentSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, childSubjectAreaGUID, "childSubjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, null, "unlinkSubjectAreasInHierarchy");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unlinkSubjectAreasInHierarchy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkSubjectAreaToGovernanceDefinition(String serverName, String userId, String subjectAreaGUID, String definitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkSubjectAreaToGovernanceDefinition";
        String subjectAreaGUIDParameterName = "subjectAreaGUID";
        String definitionGUIDParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkSubjectAreaToGovernanceDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkSubjectAreaToGovernanceDefinition");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "linkSubjectAreaToGovernanceDefinition");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, null, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "linkSubjectAreaToGovernanceDefinition");
                } else {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkSubjectAreaToGovernanceDefinition");
                }
            } else {
                handler.linkElementToElement(userId, null, null, subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "linkSubjectAreaToGovernanceDefinition");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkSubjectAreaToGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkSubjectAreaFromGovernanceDefinition(String serverName, String userId, String subjectAreaGUID, String definitionGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkSubjectAreaToGovernanceDefinition";
        String subjectAreaGUIDParameterName = "subjectAreaGUID";
        String definitionGUIDParameterName = "definitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkSubjectAreaToGovernanceDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkSubjectAreaToGovernanceDefinition");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "unlinkSubjectAreaToGovernanceDefinition");
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, null, "unlinkSubjectAreaToGovernanceDefinition");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, definitionGUID, "definitionGUID", OpenMetadataType.GOVERNANCE_DEFINITION.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, false, false, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, null, "unlinkSubjectAreaToGovernanceDefinition");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unlinkSubjectAreaToGovernanceDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaResponse getSubjectAreaByGUID(String serverName, String userId, String subjectAreaGUID) {
        String methodName = "getSubjectAreaByGUID";
        String subjectAreaGUIDParameterName = "subjectAreaGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubjectAreaByGUID");
        SubjectAreaResponse response = new SubjectAreaResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubjectAreaByGUID");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "getSubjectAreaByGUID");
            response.setElement((SubjectAreaElement)handler.getBeanFromRepository(userId, subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, new Date(), "getSubjectAreaByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSubjectAreaByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaResponse getSubjectAreaByName(String serverName, String userId, String qualifiedName) {
        String methodName = "getSubjectAreaByName";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubjectAreaByName");
        SubjectAreaResponse response = new SubjectAreaResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubjectAreaByName");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "getSubjectAreaByName");
            response.setElement((SubjectAreaElement)handler.getSubjectArea(userId, qualifiedName, "qualifiedName", false, false, new Date(), "getSubjectAreaByName"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSubjectAreaByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreasResponse getSubjectAreasForDomain(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getSubjectAreasForDomain";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubjectAreasForDomain");
        SubjectAreasResponse response = new SubjectAreasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubjectAreasForDomain");
            SubjectAreaHandler<SubjectAreaElement> handler = instanceHandler.getSubjectAreaHandler(userId, serverName, "getSubjectAreasForDomain");
            List subjectAreas = handler.getSubjectAreasByDomain(userId, domainIdentifier, startFrom, pageSize, false, false, new Date(), "getSubjectAreasForDomain");
            response.setElements(subjectAreas);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSubjectAreasForDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaDefinitionResponse getSubjectAreaDefinitionByGUID(String serverName, String userId, String subjectAreaGUID) {
        String methodName = "getSubjectAreaDefinitionByGUID";
        String subjectAreaGUIDParameterName = "subjectAreaGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubjectAreaDefinitionByGUID");
        SubjectAreaDefinitionResponse response = new SubjectAreaDefinitionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubjectAreaDefinitionByGUID");
            SubjectAreaHandler<SubjectAreaElement> subjectAreaHandler = instanceHandler.getSubjectAreaHandler(userId, serverName, "getSubjectAreaDefinitionByGUID");
            SubjectAreaElement element = (SubjectAreaElement)subjectAreaHandler.getBeanFromRepository(userId, subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, new Date(), "getSubjectAreaDefinitionByGUID");
            if (element != null) {
                SubjectAreaDefinition subjectAreaDefinition = new SubjectAreaDefinition(element);
                subjectAreaDefinition.setParentSubjectAreaGUID(subjectAreaHandler.getSubjectAreaParentGUID(userId, subjectAreaGUID, "subjectAreaGUID", false, false, new Date(), "getSubjectAreaDefinitionByGUID"));
                subjectAreaDefinition.setNestedSubjectAreaGUIDs(subjectAreaHandler.getSubjectAreaChildrenGUIDs(userId, subjectAreaGUID, "subjectAreaGUID", false, false, new Date(), "getSubjectAreaDefinitionByGUID"));
                GovernanceDefinitionHandler<GovernanceDefinitionElement> definitionHandler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getSubjectAreaDefinitionByGUID");
                ElementStubConverter<ElementStub> elementStubConverter = instanceHandler.getElementStubConverter(userId, serverName, "getSubjectAreaDefinitionByGUID");
                List relationships = definitionHandler.getGoverningDefinitionLinks(userId, subjectAreaGUID, "subjectAreaGUID", OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, null, 0, 0, false, false, new Date(), "getSubjectAreaDefinitionByGUID");
                List definitions = elementStubConverter.getNewBeans(ElementStub.class, relationships, true, "getSubjectAreaDefinitionByGUID");
                subjectAreaDefinition.setAssociatedGovernanceDefinitions(definitions);
                response.setProperties(subjectAreaDefinition);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSubjectAreaDefinitionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSubjectAreaMemberClassification(String serverName, String userId, String elementGUID, ClassificationRequestBody requestBody) {
        String methodName = "addSubjectAreaMemberClassification";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSubjectAreaMemberClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSubjectAreaMemberClassification");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "addSubjectAreaMemberClassification");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof SubjectAreaClassificationProperties) {
                    SubjectAreaClassificationProperties properties = (SubjectAreaClassificationProperties)requestBody.getProperties();
                    handler.addSubjectAreaClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getSubjectAreaName(), false, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), null, "addSubjectAreaMemberClassification");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaClassificationProperties.class.getName(), "addSubjectAreaMemberClassification");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addSubjectAreaMemberClassification", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSubjectAreaMemberClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteSubjectAreaMemberClassification(String serverName, String userId, String elementGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteSubjectAreaMemberClassification";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteSubjectAreaMemberClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteSubjectAreaMemberClassification");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "deleteSubjectAreaMemberClassification");
            if (requestBody != null) {
                handler.removeSubjectAreaClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, false, false, null, "deleteSubjectAreaMemberClassification");
            } else {
                handler.removeSubjectAreaClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, false, false, null, "deleteSubjectAreaMemberClassification");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteSubjectAreaMemberClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getMembersOfSubjectArea(String serverName, String userId, String subjectAreaName, int startFrom, int pageSize) {
        String methodName = "getMembersOfSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMembersOfSubjectArea");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMembersOfSubjectArea");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getMembersOfSubjectArea");
            response.setElements(handler.getSubjectAreaMembers(userId, subjectAreaName, startFrom, pageSize, false, false, null, "getMembersOfSubjectArea"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMembersOfSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

