/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/governance-program/users/{userId}/leadership"})
public class GovernanceProgramOMASGovernanceLeadershipResource {
    private GovernanceProgramRESTServices restAPI = new GovernanceProgramRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/personal-profiles"})
    public GUIDResponse createPersonalProfile(@PathVariable String userId, @RequestBody PersonalDetailsRequestBody requestBody) {
        return this.restAPI.createPersonalProfile(userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/personal-profiles/{profileGUID}"})
    public VoidResponse updatePersonalProfile(@PathVariable String userId, @PathVariable String profileGUID, @RequestBody PersonalDetailsRequestBody requestBody) {
        return this.restAPI.updatePersonalProfile(userId, profileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/personal-profiles/{profileGUID}/delete"})
    public VoidResponse deletePersonalProfile(@PathVariable String userId, @PathVariable String profileGUID, @RequestBody PersonalProfileValidatorRequestBody requestBody) {
        return this.restAPI.deletePersonalProfile(userId, profileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/{profileGUID}"})
    public PersonalProfileResponse getPersonalProfileByGUID(@PathVariable String userId, @PathVariable String profileGUID) {
        return this.restAPI.getPersonalProfileByGUID(userId, profileGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/by-employee-number/{employeeNumber}"})
    public PersonalProfileResponse getPersonalProfileByEmployeeNumber(@PathVariable String userId, @PathVariable String employeeNumber) {
        return this.restAPI.getPersonalProfileByEmployeeNumber(userId, employeeNumber);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/by-name/{name}"})
    public PersonalProfileListResponse getPersonalProfilesByName(@PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getPersonalProfilesByName(userId, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers"})
    public GUIDResponse createGovernanceOfficer(@PathVariable String userId, @RequestBody GovernanceOfficerDetailsRequestBody requestBody) {
        return this.restAPI.createGovernanceOfficer(userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}"})
    public VoidResponse updateGovernanceOfficer(@PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody GovernanceOfficerDetailsRequestBody requestBody) {
        return this.restAPI.updateGovernanceOfficer(userId, governanceOfficerGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}/delete"})
    public VoidResponse deleteGovernanceOfficer(@PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody GovernanceOfficerValidatorRequestBody requestBody) {
        return this.restAPI.deleteGovernanceOfficer(userId, governanceOfficerGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers/{governanceOfficerGUID}"})
    public GovernanceOfficerResponse getGovernanceOfficerByGUID(@PathVariable String userId, @PathVariable String governanceOfficerGUID) {
        return this.restAPI.getGovernanceOfficerByGUID(userId, governanceOfficerGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers/by-appointment-id/{appointmentId}"})
    public GovernanceOfficerResponse getGovernanceOfficerByAppointmentId(@PathVariable String userId, @PathVariable String appointmentId) {
        return this.restAPI.getGovernanceOfficerByAppointmentId(userId, appointmentId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers"})
    public GovernanceOfficerListResponse getGovernanceOfficers(@PathVariable String userId) {
        return this.restAPI.getGovernanceOfficers(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers/active"})
    public GovernanceOfficerListResponse getActiveGovernanceOfficers(@PathVariable String userId) {
        return this.restAPI.getActiveGovernanceOfficers(userId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/by-domain"})
    public GovernanceOfficerListResponse getGovernanceOfficersByDomain(@PathVariable String userId, @RequestBody GovernanceDomainRequestBody requestBody) {
        return this.restAPI.getGovernanceOfficersByDomain(userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}/appoint"})
    public VoidResponse appointGovernanceOfficer(@PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.appointGovernanceOfficer(userId, governanceOfficerGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}/relieve"})
    public VoidResponse relieveGovernanceOfficer(@PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.relieveGovernanceOfficer(userId, governanceOfficerGUID, requestBody);
    }
}

