/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}/leadership"})
public class GovernanceLeadershipResource {
    private GovernanceProgramRESTServices restAPI = new GovernanceProgramRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers"})
    public GUIDResponse createGovernanceOfficer(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceOfficerDetailsRequestBody requestBody) {
        return this.restAPI.createGovernanceOfficer(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}"})
    public VoidResponse updateGovernanceOfficer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody GovernanceOfficerDetailsRequestBody requestBody) {
        return this.restAPI.updateGovernanceOfficer(serverName, userId, governanceOfficerGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}/delete"})
    public VoidResponse deleteGovernanceOfficer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody GovernanceOfficerValidatorRequestBody requestBody) {
        return this.restAPI.deleteGovernanceOfficer(serverName, userId, governanceOfficerGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers/{governanceOfficerGUID}"})
    public GovernanceOfficerResponse getGovernanceOfficerByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceOfficerGUID) {
        return this.restAPI.getGovernanceOfficerByGUID(serverName, userId, governanceOfficerGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers/by-appointment-id/{appointmentId}"})
    public GovernanceOfficerResponse getGovernanceOfficerByAppointmentId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String appointmentId) {
        return this.restAPI.getGovernanceOfficerByAppointmentId(serverName, userId, appointmentId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers"})
    public GovernanceOfficerListResponse getGovernanceOfficers(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGovernanceOfficers(serverName, userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/governance-officers/active"})
    public GovernanceOfficerListResponse getActiveGovernanceOfficers(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getActiveGovernanceOfficers(serverName, userId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/by-domain"})
    public GovernanceOfficerListResponse getGovernanceOfficersByDomain(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceDomainRequestBody requestBody) {
        return this.restAPI.getGovernanceOfficersByDomain(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}/appoint"})
    public VoidResponse appointGovernanceOfficer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.appointGovernanceOfficer(serverName, userId, governanceOfficerGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/governance-officers/{governanceOfficerGUID}/relieve"})
    public VoidResponse relieveGovernanceOfficer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceOfficerGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.relieveGovernanceOfficer(serverName, userId, governanceOfficerGUID, requestBody);
    }
}

