/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceZoneRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.ZoneListResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.ZoneRequestBody;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.ZoneResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}/governance-zone-manager"})
public class GovernanceZonesResource {
    private GovernanceZoneRESTServices restAPI = new GovernanceZoneRESTServices();

    @PostMapping(path={"/governance-zones"})
    public VoidResponse createGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @RequestBody ZoneRequestBody requestBody) {
        return this.restAPI.createGovernanceZone(serverName, userId, requestBody);
    }

    @GetMapping(path={"/governance-zones"})
    public ZoneListResponse getGovernanceZones(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getGovernanceZones(serverName, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/governance-zones/name/{qualifiedName}"})
    public ZoneResponse getGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getGovernanceZone(serverName, userId, qualifiedName);
    }
}

