/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ZoneListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ZoneResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceZoneRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}/governance-zone-manager"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.\n", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/governance-program/"))
public class GovernanceZonesResource {
    private GovernanceZoneRESTServices restAPI = new GovernanceZoneRESTServices();

    @PostMapping(path={"/governance-zones"})
    public VoidResponse createGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceZoneProperties requestBody) {
        return this.restAPI.createGovernanceZone(serverName, userId, requestBody);
    }

    @GetMapping(path={"/governance-zones"})
    public ZoneListResponse getGovernanceZones(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getGovernanceZones(serverName, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/governance-zones/name/{qualifiedName}"})
    public ZoneResponse getGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getGovernanceZone(serverName, userId, qualifiedName);
    }
}

