/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceZoneRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.\n", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/governance-program/"))
public class GovernanceZonesResource {
    private GovernanceZoneRESTServices restAPI = new GovernanceZoneRESTServices();

    @PostMapping(path={"/governance-zones"})
    public GUIDResponse createGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceZoneProperties requestBody) {
        return this.restAPI.createGovernanceZone(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-zones/{zoneGUID}"})
    public VoidResponse updateGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneGUID, @RequestParam boolean isMergeUpdate, @RequestBody GovernanceZoneProperties requestBody) {
        return this.restAPI.updateGovernanceZone(serverName, userId, zoneGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/governance-zones/{zoneGUID}/delete"})
    public VoidResponse deleteGovernanceZone(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteGovernanceZone(serverName, userId, zoneGUID, requestBody);
    }

    @PostMapping(path={"/governance-zones/{parentZoneGUID}/nested-zone/{childZoneGUID}/link"})
    public VoidResponse linkZonesInHierarchy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentZoneGUID, @PathVariable String childZoneGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.linkZonesInHierarchy(serverName, userId, parentZoneGUID, childZoneGUID, requestBody);
    }

    @PostMapping(path={"/governance-zones/{parentZoneGUID}/nested-zone/{childZoneGUID}/unlink"})
    public VoidResponse unlinkZonesInHierarchy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentZoneGUID, @PathVariable String childZoneGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkZonesInHierarchy(serverName, userId, parentZoneGUID, childZoneGUID, requestBody);
    }

    @PostMapping(path={"/governance-zones/{zoneGUID}/governed-by/{definitionGUID}/link"})
    public VoidResponse linkZoneToGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneGUID, @PathVariable String definitionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.linkZoneToGovernanceDefinition(serverName, userId, zoneGUID, definitionGUID, requestBody);
    }

    @PostMapping(path={"/governance-zones/{zoneGUID}/governed-by/{definitionGUID}/unlink"})
    public VoidResponse unlinkZoneFromGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneGUID, @PathVariable String definitionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkZoneFromGovernanceDefinition(serverName, userId, zoneGUID, definitionGUID, requestBody);
    }

    @GetMapping(path={"/governance-zones/{zoneGUID}"})
    public GovernanceZoneResponse getGovernanceZoneByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneGUID) {
        return this.restAPI.getGovernanceZoneByGUID(serverName, userId, zoneGUID);
    }

    @GetMapping(path={"/governance-zones/name/{qualifiedName}"})
    public GovernanceZoneResponse getGovernanceZoneByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getGovernanceZoneByName(serverName, userId, qualifiedName);
    }

    @GetMapping(path={"/governance-zones/for-domain"})
    public GovernanceZoneListResponse getGovernanceZonesForDomain(@PathVariable String serverName, @PathVariable String userId, @RequestParam int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceZonesForDomain(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-zones/{zoneGUID}/with-definitions"})
    public GovernanceZoneDefinitionResponse getGovernanceZoneDefinitionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneGUID) {
        return this.restAPI.getGovernanceZoneDefinitionByGUID(serverName, userId, zoneGUID);
    }
}

