/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.ExternalReferenceRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceExternalReferenceResource {
    private final ExternalReferenceRESTServices restAPI = new ExternalReferenceRESTServices();

    @PostMapping(path={"/external-references"})
    public GUIDResponse createExternalReference(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createExternalReference(serverName, userId, requestBody);
    }

    @PostMapping(path={"/external-references/{externalReferenceGUID}/update"})
    public VoidResponse updateExternalReference(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateExternalReference(serverName, userId, externalReferenceGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/external-references/{externalReferenceGUID}/delete"})
    public VoidResponse deleteExternalReference(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteExternalReference(serverName, userId, externalReferenceGUID, requestBody);
    }

    @PostMapping(path={"/elements/{attachedToGUID}/external-references/{externalReferenceGUID}/link"})
    public VoidResponse linkExternalReferenceToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String attachedToGUID, @PathVariable String externalReferenceGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.linkExternalReferenceToElement(serverName, userId, attachedToGUID, externalReferenceGUID, requestBody);
    }

    @PostMapping(path={"/elements/{attachedToGUID}/external-references/{externalReferenceGUID}/unlink"})
    public VoidResponse unlinkExternalReferenceFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String attachedToGUID, @PathVariable String externalReferenceGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.unlinkExternalReferenceFromElement(serverName, userId, attachedToGUID, externalReferenceGUID, requestBody);
    }

    @GetMapping(path={"/external-references/{externalReferenceGUID}"})
    public ExternalReferenceResponse getExternalReferenceByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID) {
        return this.restAPI.getExternalReferenceByGUID(serverName, userId, externalReferenceGUID);
    }

    @PostMapping(path={"/external-references/by-resource-id"})
    public ExternalReferenceListResponse findExternalReferencesById(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findExternalReferencesById(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/by-url"})
    public ExternalReferenceListResponse getExternalReferencesByURL(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getExternalReferencesByURL(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/elements/{attachedToGUID}/external-references"})
    public ExternalReferenceListResponse retrieveAttachedExternalReferences(@PathVariable String serverName, @PathVariable String userId, @PathVariable String attachedToGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.retrieveAttachedExternalReferences(serverName, userId, attachedToGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/elements/external-references/{externalReferenceGUID}"})
    public RelatedElementListResponse getElementsForExternalReference(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getElementsForExternalReference(serverName, userId, externalReferenceGUID, startFrom, pageSize);
    }
}

