/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SubjectAreaProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.SubjectAreaRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/governance-program/"))
public class SubjectAreaResource {
    private SubjectAreaRESTServices restAPI = new SubjectAreaRESTServices();

    @PostMapping(path={"/subject-areas"})
    public GUIDResponse createSubjectArea(@PathVariable String serverName, @PathVariable String userId, @RequestBody SubjectAreaProperties requestBody) {
        return this.restAPI.createSubjectArea(serverName, userId, requestBody);
    }

    @PostMapping(path={"/subject-areas/{subjectAreaGUID}"})
    public VoidResponse updateSubjectArea(@PathVariable String serverName, @PathVariable String userId, @PathVariable String subjectAreaGUID, @RequestParam boolean isMergeUpdate, @RequestBody SubjectAreaProperties requestBody) {
        return this.restAPI.updateSubjectArea(serverName, userId, subjectAreaGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/subject-areas/{subjectAreaGUID}/delete"})
    public VoidResponse deleteSubjectArea(@PathVariable String serverName, @PathVariable String userId, @PathVariable String subjectAreaGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteSubjectArea(serverName, userId, subjectAreaGUID, requestBody);
    }

    @PostMapping(path={"/subject-areas/{parentSubjectAreaGUID}/nested-subject area/{childSubjectAreaGUID}/link"})
    public VoidResponse linkSubjectAreasInHierarchy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentSubjectAreaGUID, @PathVariable String childSubjectAreaGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.linkSubjectAreasInHierarchy(serverName, userId, parentSubjectAreaGUID, childSubjectAreaGUID, requestBody);
    }

    @PostMapping(path={"/subject-areas/{parentSubjectAreaGUID}/nested-subject area/{childSubjectAreaGUID}/unlink"})
    public VoidResponse unlinkSubjectAreasInHierarchy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentSubjectAreaGUID, @PathVariable String childSubjectAreaGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkSubjectAreasInHierarchy(serverName, userId, parentSubjectAreaGUID, childSubjectAreaGUID, requestBody);
    }

    @PostMapping(path={"/subject-areas/{subjectAreaGUID}/governed-by/{definitionGUID}/link"})
    public VoidResponse linkSubjectAreaToGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String subjectAreaGUID, @PathVariable String definitionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.linkSubjectAreaToGovernanceDefinition(serverName, userId, subjectAreaGUID, definitionGUID, requestBody);
    }

    @PostMapping(path={"/subject-areas/{subjectAreaGUID}/governed-by/{definitionGUID}/unlink"})
    public VoidResponse unlinkSubjectAreaFromGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String subjectAreaGUID, @PathVariable String definitionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkSubjectAreaFromGovernanceDefinition(serverName, userId, subjectAreaGUID, definitionGUID, requestBody);
    }

    @GetMapping(path={"/subject-areas/{subjectAreaGUID}"})
    public SubjectAreaResponse getSubjectAreaByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String subjectAreaGUID) {
        return this.restAPI.getSubjectAreaByGUID(serverName, userId, subjectAreaGUID);
    }

    @GetMapping(path={"/subject-areas/name/{qualifiedName}"})
    public SubjectAreaResponse getSubjectAreaByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getSubjectAreaByName(serverName, userId, qualifiedName);
    }

    @GetMapping(path={"/subject-areas/for-domain"})
    public SubjectAreaListResponse getSubjectAreasForDomain(@PathVariable String serverName, @PathVariable String userId, @RequestParam int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSubjectAreasForDomain(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @GetMapping(path={"/subject-areas/{subjectAreaGUID}/with-definitions"})
    public SubjectAreaDefinitionResponse getSubjectAreaDefinitionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String subjectAreaGUID) {
        return this.restAPI.getSubjectAreaDefinitionByGUID(serverName, userId, subjectAreaGUID);
    }
}

