/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ElementStubListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionGraphResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricImplementationListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceReviewRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceReviewResource {
    private final GovernanceReviewRESTServices restAPI = new GovernanceReviewRESTServices();

    @GetMapping(path={"/review/governance-definitions/{definitionGUID}"})
    public GovernanceDefinitionResponse getGovernanceDefinitionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID) {
        return this.restAPI.getGovernanceDefinitionByGUID(serverName, userId, definitionGUID);
    }

    @GetMapping(path={"/review/governance-definitions/{typeName}/for-domain"})
    public GovernanceDefinitionListResponse getGovernanceDefinitionsForDomain(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestParam int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceDefinitionsForDomain(serverName, userId, typeName, domainIdentifier, startFrom, pageSize);
    }

    @GetMapping(path={"/review/governance-definitions/{typeName}/for-document-id/{docId}"})
    public GovernanceDefinitionListResponse getGovernanceDefinitionsForDocId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @PathVariable String docId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceDefinitionsForDocId(serverName, userId, typeName, docId, startFrom, pageSize);
    }

    @GetMapping(path={"/review/governance-definitions/{governanceDefinitionGUID}/in-context"})
    public GovernanceDefinitionGraphResponse getGovernanceDefinitionInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID) {
        return this.restAPI.getGovernanceDefinitionInContext(serverName, userId, governanceDefinitionGUID);
    }

    @PostMapping(path={"/review/governance-definitions/{typeName}/by-search-string"})
    public GovernanceDefinitionListResponse findGovernanceDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceDefinitions(serverName, userId, typeName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/review/governance-definitions/{governanceDefinitionGUID}/metrics-implementation"})
    public GovernanceMetricImplementationListResponse getGovernanceDefinitionMetrics(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceDefinitionMetrics(serverName, userId, governanceDefinitionGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/review/governance-zones/{zoneName}/members/{subTypeName}"})
    public ElementStubListResponse getGovernanceZoneMembers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String zoneName, @PathVariable String subTypeName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceZoneMembers(serverName, userId, zoneName, subTypeName, startFrom, pageSize);
    }
}

