/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificationTypeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificationTypeResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.CertificationRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceCertificationsResource {
    private final CertificationRESTServices restAPI = new CertificationRESTServices();

    @PostMapping(path={"/certification-types"})
    public GUIDResponse createCertificationType(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceDefinitionRequestBody requestBody) {
        return this.restAPI.createCertificationType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/certification-types/{certificationTypeGUID}/update"})
    public VoidResponse updateCertificationType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody GovernanceDefinitionRequestBody requestBody) {
        return this.restAPI.updateCertificationType(serverName, userId, certificationTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/certification-types/{certificationTypeGUID}/delete"})
    public VoidResponse deleteCertificationType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationTypeGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteCertificationType(serverName, userId, certificationTypeGUID, requestBody);
    }

    @GetMapping(path={"/certification-types/{certificationTypeGUID}"})
    public CertificationTypeResponse getCertificationTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationTypeGUID) {
        return this.restAPI.getCertificationTypeByGUID(serverName, userId, certificationTypeGUID);
    }

    @GetMapping(path={"/certification-types/by-document-id/{documentIdentifier}"})
    public CertificationTypeResponse getCertificationTypeByDocId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String documentIdentifier) {
        return this.restAPI.getCertificationTypeByDocId(serverName, userId, documentIdentifier);
    }

    @PostMapping(path={"/certification-types/by-title"})
    public CertificationTypeListResponse getCertificationTypesByTitle(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.getCertificationTypesByTitle(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/certification-types/by-domain/{domainIdentifier}"})
    public CertificationTypeListResponse getCertificationTypeByDomainId(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCertificationTypeByDomainId(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @PostMapping(path={"/elements/{elementGUID}/certification-types/{certificationTypeGUID}/certify"})
    public GUIDResponse certifyElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String certificationTypeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.certifyElement(serverName, userId, elementGUID, certificationTypeGUID, requestBody);
    }

    @PostMapping(path={"/certifications/{certificationGUID}/update"})
    public VoidResponse updateCertification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationGUID, @RequestParam boolean isMergeUpdate, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateCertification(serverName, userId, certificationGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/certifications/{certificationGUID}/delete"})
    public VoidResponse decertifyElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.decertifyElement(serverName, userId, certificationGUID, requestBody);
    }

    @GetMapping(path={"/elements/certifications/{certificationGUID}"})
    public RelatedElementListResponse getCertifiedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCertifiedElements(serverName, userId, certificationGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/elements/{elementGUID}/certifications"})
    public RelatedElementListResponse getCertifications(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCertifications(serverName, userId, elementGUID, startFrom, pageSize);
    }
}

