/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.LicenseRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceLicensesResource {
    private final LicenseRESTServices restAPI = new LicenseRESTServices();

    @PostMapping(path={"/license-types"})
    public GUIDResponse createLicenseType(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceDefinitionRequestBody requestBody) {
        return this.restAPI.createLicenseType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/license-types/{licenseTypeGUID}/update"})
    public VoidResponse updateLicenseType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody GovernanceDefinitionRequestBody requestBody) {
        return this.restAPI.updateLicenseType(serverName, userId, licenseTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/license-types/{licenseTypeGUID}/delete"})
    public VoidResponse deleteLicenseType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseTypeGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteLicenseType(serverName, userId, licenseTypeGUID, requestBody);
    }

    @GetMapping(path={"/license-types/{licenseTypeGUID}"})
    public LicenseTypeResponse getLicenseTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseTypeGUID) {
        return this.restAPI.getLicenseTypeByGUID(serverName, userId, licenseTypeGUID);
    }

    @GetMapping(path={"/license-types/by-document-id/{documentIdentifier}"})
    public LicenseTypeResponse getLicenseTypeByDocId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String documentIdentifier) {
        return this.restAPI.getLicenseTypeByDocId(serverName, userId, documentIdentifier);
    }

    @PostMapping(path={"/license-types/by-title"})
    public LicenseTypeListResponse getLicenseTypesByTitle(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.getLicenseTypesByTitle(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/license-types/by-domain/{domainIdentifier}"})
    public LicenseTypeListResponse getLicenseTypeByDomainId(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLicenseTypeByDomainId(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @PostMapping(path={"/elements/{elementGUID}/license-types/{licenseTypeGUID}/license"})
    public GUIDResponse licenseElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String licenseTypeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.licenseElement(serverName, userId, elementGUID, licenseTypeGUID, requestBody);
    }

    @PostMapping(path={"/licenses/{licenseGUID}/update"})
    public VoidResponse updateLicense(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseGUID, @RequestParam boolean isMergeUpdate, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateLicense(serverName, userId, licenseGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/licenses/{licenseGUID}/delete"})
    public VoidResponse unlicenseElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.unlicenseElement(serverName, userId, licenseGUID, requestBody);
    }

    @GetMapping(path={"/elements/licenses/{licenseGUID}"})
    public RelatedElementListResponse getCertifiedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLicensedElements(serverName, userId, licenseGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/elements/{elementGUID}/licenses"})
    public RelatedElementListResponse getLicenses(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLicenses(serverName, userId, elementGUID, startFrom, pageSize);
    }
}

