/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceMetricsRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceMetricsResource {
    private final GovernanceMetricsRESTServices restAPI = new GovernanceMetricsRESTServices();

    @PostMapping(path={"/governance-metrics"})
    public GUIDResponse createGovernanceMetric(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createGovernanceMetric(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-metrics/{metricGUID}/update"})
    public VoidResponse updateGovernanceMetric(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateGovernanceMetric(serverName, userId, metricGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/governance-metrics/{metricGUID}/delete"})
    public VoidResponse deleteGovernanceMetric(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteGovernanceMetric(serverName, userId, metricGUID, requestBody);
    }

    @PostMapping(path={"/governance-metrics/{metricGUID}/governance-definitions/{governanceDefinitionGUID}/link"})
    public VoidResponse setupGovernanceDefinitionMetric(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID, @PathVariable String governanceDefinitionGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupGovernanceDefinitionMetric(serverName, userId, metricGUID, governanceDefinitionGUID, requestBody);
    }

    @PostMapping(path={"/governance-metrics/{metricGUID}/governance-definitions/{governanceDefinitionGUID}/unlink"})
    public VoidResponse clearGovernanceDefinitionMetric(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID, @PathVariable String governanceDefinitionGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.clearGovernanceDefinitionMetric(serverName, userId, metricGUID, governanceDefinitionGUID, requestBody);
    }

    @PostMapping(path={"/governance-metrics/{metricGUID}/governance-results/{dataSetGUID}/link"})
    public VoidResponse setupGovernanceResults(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID, @PathVariable String dataSetGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupGovernanceResults(serverName, userId, metricGUID, dataSetGUID, requestBody);
    }

    @PostMapping(path={"/governance-metrics/{metricGUID}/governance-results/{dataSetGUID}/unlink"})
    public VoidResponse clearGovernanceResults(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID, @PathVariable String dataSetGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.clearGovernanceResults(serverName, userId, metricGUID, dataSetGUID, requestBody);
    }

    @PostMapping(path={"/data-sets/{dataSetGUID}/classify-as-governance-measurements-set"})
    public VoidResponse setGovernanceMeasurementsDataSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSetGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGovernanceMeasurementsDataSet(serverName, userId, dataSetGUID, requestBody);
    }

    @PostMapping(path={"/data-sets/{dataSetGUID}/classify-as-governance-measurements-set/delete"})
    public VoidResponse clearGovernanceMeasurementsDataSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSetGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearGovernanceMeasurementsDataSet(serverName, userId, dataSetGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/classify-with-governance-expectations"})
    public VoidResponse setGovernanceExpectations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGovernanceExpectations(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/classify-with-governance-expectations/delete"})
    public VoidResponse clearGovernanceExpectations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearGovernanceExpectations(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/classify-with-governance-measurements"})
    public VoidResponse setGovernanceMeasurements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGovernanceMeasurements(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/classify-with-governance-measurements/delete"})
    public VoidResponse clearGovernanceMeasurements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearGovernanceMeasurements(serverName, userId, elementGUID, requestBody);
    }

    @GetMapping(path={"/governance-metrics/{metricGUID}"})
    public GovernanceMetricResponse getGovernanceMetricByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metricGUID) {
        return this.restAPI.getGovernanceMetricByGUID(serverName, userId, metricGUID);
    }

    @PostMapping(path={"/governance-metrics/by-search-string"})
    public GovernanceMetricListResponse findGovernanceMetrics(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceMetrics(serverName, userId, startFrom, pageSize, requestBody);
    }
}

