/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleHistoryResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceRolesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.\n", externalDocs=@ExternalDocumentation(description="Governance Program Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceRolesResource {
    private final GovernanceRolesRESTServices restAPI = new GovernanceRolesRESTServices();

    @PostMapping(path={"/governance-roles"})
    public GUIDResponse createGovernanceRole(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceRoleRequestBody requestBody) {
        return this.restAPI.createGovernanceRole(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}"})
    public VoidResponse updateGovernanceRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @RequestParam boolean isMergeUpdate, @RequestBody GovernanceRoleRequestBody requestBody) {
        return this.restAPI.updateGovernanceRole(serverName, userId, governanceRoleGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/governance-responsibility/{responsibilityGUID}/link"})
    public VoidResponse linkRoleToResponsibility(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @PathVariable String responsibilityGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.linkRoleToResponsibility(serverName, userId, governanceRoleGUID, responsibilityGUID, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/governance-responsibility/{responsibilityGUID}/unlink"})
    public VoidResponse unlinkRoleFromResponsibility(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @PathVariable String responsibilityGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.unlinkRoleFromResponsibility(serverName, userId, governanceRoleGUID, responsibilityGUID, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/resource/{resourceGUID}/link"})
    public VoidResponse linkRoleToResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @PathVariable String resourceGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.linkRoleToResource(serverName, userId, governanceRoleGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/resource/{resourceGUID}/unlink"})
    public VoidResponse unlinkRoleFromResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @PathVariable String resourceGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.unlinkRoleFromResource(serverName, userId, governanceRoleGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/delete"})
    public VoidResponse deleteGovernanceRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteGovernanceRole(serverName, userId, governanceRoleGUID, requestBody);
    }

    @GetMapping(path={"/governance-roles/{governanceRoleGUID}"})
    public GovernanceRoleResponse getGovernanceRoleByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID) {
        return this.restAPI.getGovernanceRoleByGUID(serverName, userId, governanceRoleGUID);
    }

    @GetMapping(path={"/governance-roles/{governanceRoleGUID}/history"})
    public GovernanceRoleHistoryResponse getGovernanceRoleHistoryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID) {
        return this.restAPI.getGovernanceRoleHistoryByGUID(serverName, userId, governanceRoleGUID);
    }

    @GetMapping(path={"/governance-roles/by-role-id/{roleId}"})
    public GovernanceRoleListResponse getGovernanceRoleByRoleId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String roleId) {
        return this.restAPI.getGovernanceRoleByRoleId(serverName, userId, roleId);
    }

    @GetMapping(path={"/governance-roles/by-domain/{domainIdentifier}"})
    public GovernanceRoleListResponse getGovernanceRolesByDomainId(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceRolesByDomainId(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-roles/by-title/{title}"})
    public GovernanceRoleListResponse getGovernanceRolesByTitle(@PathVariable String serverName, @PathVariable String userId, @PathVariable String title, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceRolesByTitle(serverName, userId, title, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-roles/by-domain/{domainIdentifier}/current-appointments"})
    public GovernanceRoleAppointeeListResponse getCurrentGovernanceRoleAppointments(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCurrentGovernanceRoleAppointments(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/appoint"})
    public GUIDResponse appointGovernanceRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.appointGovernanceRole(serverName, userId, governanceRoleGUID, requestBody);
    }

    @PostMapping(path={"/governance-roles/{governanceRoleGUID}/relieve/{appointmentGUID}"})
    public VoidResponse relieveGovernanceRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceRoleGUID, @PathVariable String appointmentGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.relieveGovernanceRole(serverName, userId, governanceRoleGUID, appointmentGUID, requestBody);
    }
}

