/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceDefinitionRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDefinitionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Metadata Access Server: Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceDefinitionsResource {
    private final GovernanceDefinitionRESTServices restAPI = new GovernanceDefinitionRESTServices();

    @PostMapping(path={"/governance-definitions"})
    public GUIDResponse createGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceDefinitionRequestBody requestBody) {
        return this.restAPI.createGovernanceDefinition(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionGUID}/update"})
    public VoidResponse updateGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @RequestParam boolean isMergeUpdate, @RequestBody GovernanceDefinitionRequestBody requestBody) {
        return this.restAPI.updateGovernanceDefinition(serverName, userId, definitionGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionGUID}/update-status"})
    public VoidResponse setGovernanceDefinitionStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @RequestBody GovernanceStatusRequestBody requestBody) {
        return this.restAPI.setGovernanceDefinitionStatus(serverName, userId, definitionGUID, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionGUID}/delete"})
    public VoidResponse deleteGovernanceDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteGovernanceDefinition(serverName, userId, definitionGUID, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionOneGUID}/peers/{definitionTwoGUID}/link"})
    public VoidResponse linkPeerDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionOneGUID, @PathVariable String definitionTwoGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.linkPeerDefinitions(serverName, userId, definitionOneGUID, definitionTwoGUID, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionOneGUID}/peers/{definitionTwoGUID}/unlink"})
    public VoidResponse unlinkPeerDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionOneGUID, @PathVariable String definitionTwoGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.unlinkPeerDefinitions(serverName, userId, definitionOneGUID, definitionTwoGUID, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionGUID}/supporting-definitions/{supportingDefinitionGUID}/link"})
    public VoidResponse setupSupportingDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @PathVariable String supportingDefinitionGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupSupportingDefinition(serverName, userId, definitionGUID, supportingDefinitionGUID, requestBody);
    }

    @PostMapping(path={"/governance-definitions/{definitionGUID}/supporting-definitions/{supportingDefinitionGUID}/unlink"})
    public VoidResponse clearSupportingDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @PathVariable String supportingDefinitionGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.clearSupportingDefinition(serverName, userId, definitionGUID, supportingDefinitionGUID, requestBody);
    }
}

