/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceDomainRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDomainResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDomainSetResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDomainSetsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDomainsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Metadata Access Server: Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceDomainsResource {
    private final GovernanceDomainRESTServices restAPI = new GovernanceDomainRESTServices();

    @PostMapping(path={"/governance-domain-sets"})
    public GUIDResponse createGovernanceDomainSet(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createGovernanceDomainSet(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-domain-sets/{governanceDomainSetGUID}/update"})
    public VoidResponse updateGovernanceDomainSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainSetGUID, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateGovernanceDomainSet(serverName, userId, governanceDomainSetGUID, requestBody);
    }

    @PostMapping(path={"/governance-domain-sets/{governanceDomainSetGUID}/delete"})
    public VoidResponse removeGovernanceDomainSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainSetGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeGovernanceDomainSet(serverName, userId, governanceDomainSetGUID, requestBody);
    }

    @PostMapping(path={"/governance-domain-sets/by-search-string"})
    public GovernanceDomainSetsResponse findGovernanceDomainSets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceDomainSets(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-domain-sets/by-name"})
    public GovernanceDomainSetsResponse getGovernanceDomainSetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceDomainSetsByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-domain-sets/{governanceDomainSetGUID}"})
    public GovernanceDomainSetResponse getGovernanceDomainSetByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainSetGUID) {
        return this.restAPI.getGovernanceDomainSetByGUID(serverName, userId, governanceDomainSetGUID);
    }

    @PostMapping(path={"/governance-domain-sets/governance-domains"})
    public GUIDResponse createGovernanceDomain(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createGovernanceDomain(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-domains/{governanceDomainGUID}/update"})
    public VoidResponse updateGovernanceDomain(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainGUID, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateGovernanceDomain(serverName, userId, governanceDomainGUID, requestBody);
    }

    @PostMapping(path={"/governance-domains/{governanceDomainGUID}/delete"})
    public VoidResponse deleteGovernanceDomain(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteGovernanceDomain(serverName, userId, governanceDomainGUID, requestBody);
    }

    @PostMapping(path={"/governance-domain-sets/{governanceDomainSetGUID}/governance-domains/{governanceDomainGUID}"})
    public VoidResponse addDomainToSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainSetGUID, @PathVariable String governanceDomainGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.addDomainToSet(serverName, userId, governanceDomainSetGUID, governanceDomainGUID, requestBody);
    }

    @PostMapping(path={"/governance-domain-sets/{governanceDomainSetGUID}/governance-domains/{governanceDomainGUID}/delete"})
    public VoidResponse removeDomainFromSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainSetGUID, @PathVariable String governanceDomainGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.removeDomainFromSet(serverName, userId, governanceDomainSetGUID, governanceDomainGUID, (ExternalSourceRequestBody)requestBody);
    }

    @GetMapping(path={"/governance-domains"})
    public GovernanceDomainsResponse getGovernanceDomains(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceDomains(serverName, userId, startFrom, pageSize);
    }

    @PostMapping(path={"/governance-domain/by-search-string"})
    public GovernanceDomainsResponse findGovernanceDomains(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceDomains(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-domain-sets/by-governance-domains/{governanceDomainGUID}"})
    public GovernanceDomainSetsResponse getSetsForGovernanceDomain(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSetsForGovernanceDomain(serverName, userId, governanceDomainGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/governance-domain/by-name"})
    public GovernanceDomainsResponse getGovernanceDomainsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceDomainsByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-domains/{governanceDomainGUID}"})
    public GovernanceDomainResponse getGovernanceDomainByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDomainGUID) {
        return this.restAPI.getGovernanceDomainByGUID(serverName, userId, governanceDomainGUID);
    }

    @GetMapping(path={"/governance-domains/by-identifier/{domainIdentifier}"})
    public GovernanceDomainResponse getGovernanceDomainByIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier) {
        return this.restAPI.getGovernanceDomainByIdentifier(serverName, userId, domainIdentifier);
    }
}

