/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceprogram.server.RelatedElementRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-program/users/{userId}"})
@Tag(name="Metadata Access Server: Governance Program OMAS", description="The Governance Program OMAS provides APIs and events for tools and applications focused on defining a data strategy, planning support for a regulation and/or developing a governance program for the data landscape.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/governance-program/overview/"))
public class GovernanceProgramResource {
    private final RelatedElementRESTServices restAPI = new RelatedElementRESTServices();

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}"})
    public VoidResponse setupMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}/delete"})
    public VoidResponse clearMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/more-information/by-descriptive-element/{elementGUID}"})
    public RelatedElementsResponse getMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMoreInformation(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/more-information/by-detail-element/{detailGUID}"})
    public RelatedElementsResponse getDescriptiveElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String detailGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDescriptiveElements(serverName, userId, detailGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/governed-by/{governanceDefinitionGUID}"})
    public VoidResponse setupGovernedBy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String governanceDefinitionGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupGovernedBy(serverName, userId, elementGUID, governanceDefinitionGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/governed-by/{governanceDefinitionGUID}/delete"})
    public VoidResponse clearGovernedBy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String governanceDefinitionGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearGovernedBy(serverName, userId, elementGUID, governanceDefinitionGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/governed-by/by-element/{elementGUID}"})
    public GovernanceDefinitionsResponse getGovernanceDefinitionsForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceDefinitionsForElement(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/governed-by/by-governance-definition/{governanceDefinitionGUID}"})
    public RelatedElementsResponse getGovernedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernedElements(serverName, userId, governanceDefinitionGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{governanceDefinitionGUID}/governance-definition-scopes/{scopeGUID}"})
    public VoidResponse setupGovernanceDefinitionScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @PathVariable String scopeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupGovernanceDefinitionScope(serverName, userId, governanceDefinitionGUID, scopeGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{governanceDefinitionGUID}/governance-definition-scopes/{scopeGUID}/delete"})
    public VoidResponse clearGovernanceDefinitionScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @PathVariable String scopeGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearGovernanceDefinitionScope(serverName, userId, governanceDefinitionGUID, scopeGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/governance-definition-scopes/by-governance-definition/{governanceDefinitionGUID}"})
    public RelatedElementsResponse getGovernanceDefinitionScopes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceDefinitionScopes(serverName, userId, governanceDefinitionGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/governance-definition-scopes/by-scope/{scopeGUID}"})
    public GovernanceDefinitionsResponse getScopedGovernanceDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String scopeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getScopedGovernanceDefinitions(serverName, userId, scopeGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{governanceResponsibilityGUID}/governance-responsibility-assignments/{personRoleGUID}"})
    public VoidResponse setupGovernanceResponsibilityAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceResponsibilityGUID, @PathVariable String personRoleGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupGovernanceResponsibilityAssignment(serverName, userId, governanceResponsibilityGUID, personRoleGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{governanceResponsibilityGUID}/governance-responsibility-assignments/{personRoleGUID}/delete"})
    public VoidResponse clearGovernanceResponsibilityAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceResponsibilityGUID, @PathVariable String personRoleGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearGovernanceResponsibilityAssignment(serverName, userId, governanceResponsibilityGUID, personRoleGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/governance-responsibility-assignments/by-responsibility/{governanceResponsibilityGUID}"})
    public GovernanceRolesResponse getResponsibleRoles(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceResponsibilityGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getResponsibleRoles(serverName, userId, governanceResponsibilityGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/governance-responsibility-assignments/by-role/{personRoleGUID}"})
    public GovernanceDefinitionsResponse getRoleResponsibilities(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getRoleResponsibilities(serverName, userId, personRoleGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}"})
    public VoidResponse setupStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}/delete"})
    public VoidResponse clearStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-commissioned-element/{elementGUID}"})
    public RelatedElementsResponse getStakeholders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholders(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-stakeholder/{stakeholderGUID}"})
    public RelatedElementsResponse getStakeholderCommissionedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String stakeholderGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholderCommissionedElements(serverName, userId, stakeholderGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/assignment-scopes/{scopeGUID}"})
    public VoidResponse setupAssignmentScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String scopeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAssignmentScope(serverName, userId, elementGUID, scopeGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/assignment-scopes/{scopeGUID}/delete"})
    public VoidResponse clearAssignmentScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String scopeGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearAssignmentScope(serverName, userId, elementGUID, scopeGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/assignment-scopes/by-assigned-actor/{elementGUID}"})
    public RelatedElementsResponse getAssignedScopes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssignedScopes(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/assignment-scopes/by-assigned-scope/{scopeGUID}"})
    public RelatedElementsResponse getAssignedActors(@PathVariable String serverName, @PathVariable String userId, @PathVariable String scopeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssignedActors(serverName, userId, scopeGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}"})
    public VoidResponse setupResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}/delete"})
    public VoidResponse clearResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/resource-list/by-assignee/{elementGUID}"})
    public RelatedElementsResponse getResourceList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getResourceList(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/resource-list/by-resource/{resourceGUID}"})
    public RelatedElementsResponse getSupportedByResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String resourceGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSupportedByResource(serverName, userId, resourceGUID, startFrom, pageSize);
    }
}

