/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GovernanceServerEventType {
    UNKNOWN_GOVERNANCE_SERVER_EVENT(0, "Unknown Event", "An event that is not recognized by the local server."),
    REFRESH_GOVERNANCE_ENGINE_EVENT(1, "Refresh Governance Engine Configuration", "The configuration for a Governance Engine has changed."),
    REFRESH_GOVERNANCE_SERVICE_EVENT(2, "Refresh Governance Service Configuration", "The configuration for a governance service has changed."),
    REFRESH_INTEGRATION_GROUP_EVENT(1, "Refresh Integration Group Configuration", "The configuration for an Integration Group has changed."),
    REFRESH_INTEGRATION_CONNECTOR_EVENT(2, "Refresh Integration Connector Configuration", "The configuration for am Integration Connector has changed."),
    REQUESTED_ENGINE_ACTION_EVENT(5, "Requested Engine Action", "New request to run a governance service."),
    CANCELLED_ENGINE_ACTION_EVENT(5, "Cancelled Engine Action", "Request to stop a governance service.");

    private final int eventTypeCode;
    private final String eventTypeName;
    private final String eventTypeDescription;

    private GovernanceServerEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "GovernanceServerEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + "', eventTypeDescription='" + this.eventTypeDescription + "'}";
    }
}

