/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.fvt.duplicates;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateDuplicatesTest {
    private static final String testCaseName = "CreateDuplicatesTest";
    private static final String testCaseNameProperty = "TestCaseName";
    private static final String qualifiedNameProperty = "qualifiedName";
    private static final String nameProperty = "name";
    private static final String displayNameProperty = "displayName";
    private static final String keywordProperty = "keyword";
    private static final String descriptionProperty = "description";
    private static final String additionalPropertiesProperty = "additionalProperties";
    private static final int maxPageSize = 100;
    private static final String assetTypeName = "Asset";
    private static final String keywordTypeName = "SearchKeyword";
    private static final String keywordLinkTypeName = "SearchKeywordLink";
    private static final String schemaTypeTypeName = "SchemaType";
    private static final String assetSchemaTypeTypeName = "AssetSchemaType";
    private static final String firstAssetName = "FirstAsset";
    private static final String firstAssetDescription = "FirstAssetDescription";
    private static final String duplicatePrefix = "Dup:";
    private static final String mementoPrefix = "Memento:";
    private static final String ineffectivePrefix = "Ineffective:";
    private static final String expiredPrefix = "Expired:";
    final PropertyHelper propertyHelper = new PropertyHelper();

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateDuplicatesTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        CreateDuplicatesTest thisTest = new CreateDuplicatesTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceCode(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceName(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceDescription(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceWiki());
        GAFRESTClient restClient = new GAFRESTClient(serverName, serverPlatformRootURL, auditLog);
        GovernanceContextClient governanceContextClient = new GovernanceContextClient(serverName, serverPlatformRootURL, restClient, 100);
        OpenMetadataStoreClient openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformRootURL, 100);
        String activityName = "SimpleDuplicate - create first entity";
        String firstAssetGUID = thisTest.createAsset(openMetadataStoreClient, userId, assetTypeName, "", firstAssetName, firstAssetDescription, null, null, null, activityName, testCaseName);
        activityName = "SimpleDuplicate - create duplicate entity";
        try {
            Thread.sleep(1L);
        }
        catch (Exception interruption) {
            System.out.println("Interrupted sleep in: " + activityName + " Exception: " + interruption);
        }
        String firstAssetDuplicateGUID = thisTest.createAsset(openMetadataStoreClient, userId, assetTypeName, duplicatePrefix, firstAssetName, firstAssetDescription, null, null, null, activityName, testCaseName);
        activityName = "SimpleDuplicate - link duplicate entities";
        thisTest.linkDuplicates(governanceContextClient, userId, firstAssetGUID, firstAssetDuplicateGUID, 1, testCaseName, activityName);
        activityName = "SimpleDuplicate - retrieve first entity - deDup=true";
        OpenMetadataElement firstAsset = thisTest.getMetadataElementByGUID(openMetadataStoreClient, userId, assetTypeName, firstAssetGUID, firstAssetGUID, "", firstAssetName, false, true, null, activityName, testCaseName);
        thisTest.validateMetadataElement(firstAsset, assetTypeName, firstAssetGUID, "", firstAssetName, activityName, testCaseName);
        activityName = "SimpleDuplicate - retrieve second entity - deDup=true";
        OpenMetadataElement firstAssetDuplicate = thisTest.getMetadataElementByGUID(openMetadataStoreClient, userId, assetTypeName, firstAssetDuplicateGUID, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, false, true, null, activityName, testCaseName);
        thisTest.validateMetadataElement(firstAssetDuplicate, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
        activityName = "SimpleDuplicate - retrieve first entity - deDup=false - second entity returned";
        OpenMetadataElement deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, false, false, null, null);
        thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
        List retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, null, 0, 0);
        thisTest.validateMetadataElements(retrievedElements, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
        activityName = "SimpleDuplicate - create memento asset";
        String mementoAssetGUID = thisTest.createAsset(openMetadataStoreClient, userId, assetTypeName, mementoPrefix, firstAssetName, firstAssetDescription, null, null, null, activityName, testCaseName);
        activityName = "SimpleDuplicate - link memento entity as duplicate";
        thisTest.linkDuplicates(governanceContextClient, userId, firstAssetGUID, mementoAssetGUID, 1, testCaseName, activityName);
        openMetadataStoreClient.classifyMetadataElementInStore(userId, mementoAssetGUID, "Memento", true, true, null, null, null, null);
        try {
            openMetadataStoreClient.getMetadataElementByGUID(userId, mementoAssetGUID, false, true, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "Memento metadata element returned by " + activityName);
        }
        catch (Exception exception) {
            System.out.println(activityName + ": metadata element " + mementoAssetGUID + " hidden by memento classification");
            OpenMetadataElement mementoElement = openMetadataStoreClient.getMetadataElementByGUID(userId, mementoAssetGUID, true, true, null, null);
            thisTest.validateMetadataElement(mementoElement, assetTypeName, mementoAssetGUID, mementoPrefix, firstAssetName, activityName, testCaseName);
            activityName = "SimpleDuplicate - retrieve first entity - deDup=false - second entity returned because not lineage";
            deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, false, false, null, null);
            thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
            retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, null, 0, 0);
            thisTest.validateMetadataElements(retrievedElements, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
            activityName = "SimpleDuplicate - retrieve first entity - deDup=false; lineage=true - memento entity returned";
            deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, true, false, null, null);
            thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, mementoAssetGUID, mementoPrefix, firstAssetName, activityName, testCaseName);
            retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, true, false, null, 0, 0);
            thisTest.validateMetadataElements(retrievedElements, assetTypeName, mementoAssetGUID, mementoPrefix, firstAssetName, activityName, testCaseName);
            activityName = "SimpleDuplicate - create ineffective asset";
            String ineffectiveAssetGUID = thisTest.createAsset(openMetadataStoreClient, userId, assetTypeName, ineffectivePrefix, firstAssetName, firstAssetDescription, null, new Date(10L), null, activityName, testCaseName);
            activityName = "SimpleDuplicate - link ineffective entity as duplicate";
            thisTest.linkDuplicates(governanceContextClient, userId, firstAssetGUID, ineffectiveAssetGUID, 1, testCaseName, activityName);
            try {
                openMetadataStoreClient.getMetadataElementByGUID(userId, ineffectiveAssetGUID, false, true, null, new Date());
                throw new FVTUnexpectedCondition(testCaseName, "Ineffective metadata element returned by " + activityName);
            }
            catch (Exception exception2) {
                System.out.println(activityName + ": metadata element " + ineffectiveAssetGUID + " hidden by effectivity date");
                OpenMetadataElement ineffectiveElement = openMetadataStoreClient.getMetadataElementByGUID(userId, ineffectiveAssetGUID, true, true, null, null);
                thisTest.validateMetadataElement(ineffectiveElement, assetTypeName, ineffectiveAssetGUID, ineffectivePrefix, firstAssetName, activityName, testCaseName);
                System.out.println("Effective Date: " + ineffectiveElement.getEffectiveToTime());
                activityName = "SimpleDuplicate - retrieve first entity - deDup=false; lineage=false; effectivity date now  - second entity returned because not lineage and NOW";
                deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, false, false, null, new Date());
                System.out.println(" firstAssetGUID: " + firstAssetGUID);
                System.out.println(" firstAssetDuplicateGUID: " + firstAssetDuplicateGUID);
                System.out.println(" mementoAssetGUID: " + mementoAssetGUID);
                System.out.println(" ineffectiveAssetGUID: " + ineffectiveAssetGUID);
                thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
                retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), 0, 0);
                thisTest.validateMetadataElements(retrievedElements, assetTypeName, firstAssetDuplicateGUID, duplicatePrefix, firstAssetName, activityName, testCaseName);
                activityName = "SimpleDuplicate - retrieve first entity - deDup=false; lineage=true; effectivity date now - memento entity returned";
                deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, true, false, null, new Date());
                thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, mementoAssetGUID, mementoPrefix, firstAssetName, activityName, testCaseName);
                retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, true, false, new Date(), 0, 0);
                thisTest.validateMetadataElements(retrievedElements, assetTypeName, mementoAssetGUID, mementoPrefix, firstAssetName, activityName, testCaseName);
                activityName = "SimpleDuplicate - retrieve first entity - deDup=false; lineage=false; no effectivity date - ineffective entity returned";
                deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, false, false, null, null);
                thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, ineffectiveAssetGUID, ineffectivePrefix, firstAssetName, activityName, testCaseName);
                retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, null, 0, 0);
                thisTest.validateMetadataElements(retrievedElements, assetTypeName, ineffectiveAssetGUID, ineffectivePrefix, firstAssetName, activityName, testCaseName);
                activityName = "SimpleDuplicate - retrieve first entity - deDup=false; lineage=true; no effectivity date - ineffective entity returned";
                deDuplicatedAsset = openMetadataStoreClient.getMetadataElementByGUID(userId, firstAssetGUID, true, false, null, null);
                thisTest.validateMetadataElement(deDuplicatedAsset, assetTypeName, ineffectiveAssetGUID, ineffectivePrefix, firstAssetName, activityName, testCaseName);
                retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, firstAssetName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, true, false, null, 0, 0);
                thisTest.validateMetadataElements(retrievedElements, assetTypeName, ineffectiveAssetGUID, ineffectivePrefix, firstAssetName, activityName, testCaseName);
                activityName = "Keyword Creation";
                String firstAssetKeywordIneffectiveGUID = thisTest.createSearchKeyword(openMetadataStoreClient, userId, expiredPrefix, "Expired:Keyword for firstAsset", null, new Date(), firstAssetGUID, activityName, testCaseName);
                String firstAssetDuplicateKeywordGUID = thisTest.createSearchKeyword(openMetadataStoreClient, userId, duplicatePrefix, "Dup:Keyword for firstAsset", null, null, firstAssetDuplicateGUID, activityName, testCaseName);
                String firstAssetMementoKeywordGUID = thisTest.createSearchKeyword(openMetadataStoreClient, userId, mementoPrefix, "Memento:Keyword for firstAsset", null, null, mementoAssetGUID, activityName, testCaseName);
                String firstAssetIneffectiveKeywordGUID = thisTest.createSearchKeyword(openMetadataStoreClient, userId, ineffectivePrefix, "Ineffective:Keyword for firstAsset", null, null, ineffectiveAssetGUID, activityName, testCaseName);
                activityName = "Keyword test - all returned";
                RelatedMetadataElementList relatedMetadataElements = openMetadataStoreClient.getRelatedMetadataElements(userId, firstAssetGUID, 1, keywordLinkTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, true, false, null, 0, 0);
                if (relatedMetadataElements == null || relatedMetadataElements.getElementList() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "No keywords returned by " + activityName);
                }
                if (relatedMetadataElements.getElementList().size() != 4) {
                    throw new FVTUnexpectedCondition(testCaseName, relatedMetadataElements.getElementList().size() + " keywords: " + relatedMetadataElements + " returned by " + activityName);
                }
                activityName = "Keyword test - memento not returned";
                relatedMetadataElements = openMetadataStoreClient.getRelatedMetadataElements(userId, firstAssetGUID, 1, keywordLinkTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, null, 0, 0);
                if (relatedMetadataElements == null || relatedMetadataElements.getElementList() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "No keywords returned by " + activityName);
                }
                if (relatedMetadataElements.getElementList().size() != 3) {
                    throw new FVTUnexpectedCondition(testCaseName, relatedMetadataElements.getElementList().size() + " keywords: " + relatedMetadataElements + " returned by " + activityName);
                }
                activityName = "Keyword test - none returned";
                relatedMetadataElements = openMetadataStoreClient.getRelatedMetadataElements(userId, firstAssetGUID, 1, keywordLinkTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, true, new Date(), 0, 0);
                if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null && !relatedMetadataElements.getElementList().isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, relatedMetadataElements.getElementList().size() + " unexpected keywords returned by " + activityName);
                }
                activityName = "Keyword test - ineffective not returned";
                relatedMetadataElements = openMetadataStoreClient.getRelatedMetadataElements(userId, firstAssetGUID, 1, keywordLinkTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, true, false, new Date(), 0, 0);
                if (relatedMetadataElements == null || relatedMetadataElements.getElementList() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "No keywords returned by " + activityName);
                }
                if (relatedMetadataElements.getElementList().size() != 2) {
                    throw new FVTUnexpectedCondition(testCaseName, relatedMetadataElements.getElementList().size() + " keywords returned by " + activityName);
                }
                activityName = "Keyword test - active returned";
                relatedMetadataElements = openMetadataStoreClient.getRelatedMetadataElements(userId, firstAssetGUID, 1, keywordLinkTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), 0, 0);
                if (relatedMetadataElements == null || relatedMetadataElements.getElementList() == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "No keywords returned by " + activityName);
                }
                if (relatedMetadataElements.getElementList().size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, relatedMetadataElements.getElementList().size() + " keywords returned by " + activityName);
                }
                return;
            }
        }
    }

    private String createAsset(OpenMetadataStoreClient openMetadataStoreClient, String userId, String typeName, String prefix, String name, String description, Date effectiveFrom, Date effectiveTo, String templateGUID, String activityName, String testCaseName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        ElementProperties properties = this.propertyHelper.addStringProperty(null, qualifiedNameProperty, this.getQualifiedName(typeName, prefix, name));
        properties = this.propertyHelper.addStringProperty(properties, nameProperty, name);
        properties = this.propertyHelper.addStringProperty(properties, descriptionProperty, description);
        properties = this.propertyHelper.addStringMapProperty(properties, additionalPropertiesProperty, this.getAdditionalProperties(testCaseName));
        String assetGUID = openMetadataStoreClient.createMetadataElementInStore(userId, typeName, ElementStatus.ACTIVE, effectiveFrom, effectiveTo, properties);
        this.getMetadataElementByGUID(openMetadataStoreClient, userId, typeName, assetGUID, assetGUID, prefix, name, false, false, null, activityName, testCaseName);
        this.getMetadataElementByName(openMetadataStoreClient, userId, typeName, name, assetGUID, prefix, name, false, false, null, activityName, testCaseName);
        return assetGUID;
    }

    private String createSearchKeyword(OpenMetadataStoreClient openMetadataStoreClient, String userId, String keyword, String description, Date effectiveFrom, Date effectiveTo, String assetGUID, String activityName, String testCaseName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        OpenMetadataElement retrievedElement;
        ElementProperties properties = this.propertyHelper.addStringProperty(null, keywordProperty, keyword);
        String keywordGUID = openMetadataStoreClient.createMetadataElementInStore(userId, keywordTypeName, ElementStatus.ACTIVE, effectiveFrom, effectiveTo, properties = this.propertyHelper.addStringProperty(properties, descriptionProperty, description));
        if (!keywordGUID.equals((retrievedElement = openMetadataStoreClient.getMetadataElementByGUID(userId, keywordGUID, false, false, null, null)).getElementGUID())) {
            throw new FVTUnexpectedCondition(testCaseName, "Different Keyword GUID - Metadata element GUID of " + retrievedElement.getElementGUID() + " rather than " + keywordGUID + " returned by " + activityName);
        }
        openMetadataStoreClient.createRelatedElementsInStore(userId, keywordLinkTypeName, assetGUID, keywordGUID, true, true, effectiveFrom, effectiveTo, null, null);
        return keywordGUID;
    }

    private String createSchemaType(OpenMetadataStoreClient openMetadataStoreClient, String userId, String prefix, String name, String description, String assetGUID, Date effectiveFrom, Date effectiveTo, String activityName, String testCaseName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        ElementProperties properties = this.propertyHelper.addStringProperty(null, qualifiedNameProperty, this.getQualifiedName(keywordTypeName, prefix, name));
        properties = this.propertyHelper.addStringProperty(properties, displayNameProperty, prefix + name);
        properties = this.propertyHelper.addStringProperty(properties, descriptionProperty, description);
        properties = this.propertyHelper.addStringMapProperty(properties, additionalPropertiesProperty, this.getAdditionalProperties(testCaseName));
        String schemaTypeGUID = openMetadataStoreClient.createMetadataElementInStore(userId, keywordTypeName, ElementStatus.ACTIVE, effectiveFrom, effectiveTo, properties);
        this.getMetadataElementByGUID(openMetadataStoreClient, userId, schemaTypeTypeName, schemaTypeGUID, schemaTypeGUID, prefix, name, false, false, null, activityName, testCaseName);
        this.getMetadataElementByName(openMetadataStoreClient, userId, schemaTypeTypeName, name, schemaTypeGUID, prefix, name, false, false, null, activityName, testCaseName);
        openMetadataStoreClient.createRelatedElementsInStore(userId, assetSchemaTypeTypeName, assetGUID, schemaTypeGUID, true, true, null, null, null, null);
        return schemaTypeGUID;
    }

    private OpenMetadataElement getMetadataElementByGUID(OpenMetadataStoreClient openMetadataStoreClient, String userId, String typeName, String guid, String retrievedGUID, String retrievedPrefix, String retrievedName, boolean forLineage, boolean forDeduplication, Date effectiveDate, String activityName, String testCaseName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        OpenMetadataElement retrievedElement = openMetadataStoreClient.getMetadataElementByGUID(userId, guid, forLineage, forDeduplication, null, effectiveDate);
        this.validateMetadataElement(retrievedElement, typeName, retrievedGUID, retrievedPrefix, retrievedName, activityName, testCaseName);
        return retrievedElement;
    }

    private OpenMetadataElement getMetadataElementByName(OpenMetadataStoreClient openMetadataStoreClient, String userId, String typeName, String name, String retrievedGUID, String retrievedPrefix, String retrievedName, boolean forLineage, boolean forDeduplication, Date effectiveDate, String activityName, String testCaseName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        List retrievedElements = openMetadataStoreClient.findMetadataElementsWithString(userId, name, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDeduplication, effectiveDate, 0, 0);
        return this.validateMetadataElements(retrievedElements, typeName, retrievedGUID, retrievedPrefix, retrievedName, activityName, testCaseName);
    }

    private void linkDuplicates(GovernanceContextClient client, String userId, String element1GUID, String element2GUID, int statusIdentifier, String testCaseName, String activityName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        client.linkElementsAsPeerDuplicates(userId, element1GUID, element2GUID, statusIdentifier, testCaseName, null, null, testCaseName, null, true);
        System.out.println(activityName + ": linking " + element1GUID + " to " + element2GUID);
    }

    private void validateMetadataElement(OpenMetadataElement metadataElement, String typeName, String retrievedGUID, String retrievedPrefix, String retrievedName, String activityName, String testCaseName) throws FVTUnexpectedCondition {
        String methodName = "validateMetadataElement";
        if (metadataElement == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null metadata element returned by " + activityName);
        }
        if (metadataElement.getElementGUID() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null metadata element GUID returned by " + activityName);
        }
        if (!metadataElement.getElementGUID().equals(retrievedGUID)) {
            throw new FVTUnexpectedCondition(testCaseName, "Different GUID - Metadata element GUID of " + metadataElement.getElementGUID() + " rather than " + retrievedGUID + " returned by " + activityName);
        }
        if (!metadataElement.getType().getTypeName().equals(typeName)) {
            throw new FVTUnexpectedCondition(testCaseName, "Different TypeName - Metadata element GUID of " + metadataElement.getType() + " rather than " + typeName + " returned by " + activityName);
        }
        if (metadataElement.getElementProperties() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null metadata element properties returned by " + activityName);
        }
        this.validateQualifiedName(typeName, retrievedPrefix, retrievedName, activityName, testCaseName, this.propertyHelper.getStringProperty(testCaseName, qualifiedNameProperty, metadataElement.getElementProperties(), "validateMetadataElement"));
        this.validateDisplayName(retrievedName, activityName, testCaseName, this.propertyHelper.getStringProperty(testCaseName, nameProperty, metadataElement.getElementProperties(), "validateMetadataElement"));
        this.validateAdditionalProperties(activityName, testCaseName, this.propertyHelper.getStringMapFromProperty(testCaseName, additionalPropertiesProperty, metadataElement.getElementProperties(), "validateMetadataElement"));
    }

    private OpenMetadataElement validateMetadataElements(List<OpenMetadataElement> metadataElements, String typeName, String retrievedGUID, String retrievedPrefix, String retrievedName, String activityName, String testCaseName) throws FVTUnexpectedCondition {
        OpenMetadataElement matchingElement = null;
        if (metadataElements == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null metadata elements returned by " + activityName);
        }
        if (metadataElements.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, "Empty metadata elements returned by " + activityName);
        }
        for (OpenMetadataElement metadataElement : metadataElements) {
            if (metadataElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, "Null metadata element returned in list by " + activityName);
            }
            if (metadataElement.getElementGUID() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "Null metadata element GUID returned in list by " + activityName);
            }
            if (!metadataElement.getElementGUID().equals(retrievedGUID)) continue;
            if (matchingElement == null) {
                matchingElement = metadataElement;
                this.validateMetadataElement(metadataElement, typeName, retrievedGUID, retrievedPrefix, retrievedName, activityName, testCaseName);
                continue;
            }
            throw new FVTUnexpectedCondition(testCaseName, "Duplicate metadata element GUID returned in list by " + activityName);
        }
        if (matchingElement == null) {
            throw new FVTUnexpectedCondition(testCaseName, "No matching metadata element returned in list by " + activityName + ".  Elements: " + metadataElements);
        }
        return matchingElement;
    }

    private String getQualifiedName(String typeName, String prefix, String name) {
        return typeName + ":" + prefix + name;
    }

    private void validateQualifiedName(String typeName, String prefix, String name, String activityName, String testCaseName, String qualifiedName) throws FVTUnexpectedCondition {
        if (qualifiedName == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null qualifiedName returned by " + activityName);
        }
        if (qualifiedName.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, "Empty qualifiedName returned by " + activityName);
        }
        if (!qualifiedName.equals(this.getQualifiedName(typeName, prefix, name))) {
            throw new FVTUnexpectedCondition(testCaseName, "Invalid qualified name of " + qualifiedName + " returned by " + activityName + ".  Expected value is: " + this.getQualifiedName(typeName, prefix, name));
        }
    }

    private void validateDisplayName(String name, String activityName, String testCaseName, String displayName) throws FVTUnexpectedCondition {
        if (displayName == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null displayName returned by " + activityName);
        }
        if (displayName.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, "Empty displayName returned by " + activityName);
        }
        if (!displayName.equals(name)) {
            throw new FVTUnexpectedCondition(testCaseName, "Invalid display name of " + displayName + " returned by " + activityName + ".  Expected value is: " + name);
        }
    }

    private Map<String, String> getAdditionalProperties(String testCaseName) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put(testCaseNameProperty, testCaseName);
        return additionalProperties;
    }

    private void validateAdditionalProperties(String activityName, String testCaseName, Map<String, String> additionalProperties) throws FVTUnexpectedCondition {
        if (additionalProperties == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Null additional properties returned by " + activityName);
        }
        if (additionalProperties.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, "Empty additional properties returned by " + activityName);
        }
        String testCaseNamePropertyValue = additionalProperties.get(testCaseNameProperty);
        if (testCaseNamePropertyValue == null) {
            throw new FVTUnexpectedCondition(testCaseName, "Missing test case name in additional properties returned by " + activityName + ".  Content is: " + additionalProperties);
        }
        if (!testCaseNamePropertyValue.equals(testCaseName)) {
            throw new FVTUnexpectedCondition(testCaseName, "Invalid test case name of " + testCaseNamePropertyValue + " in additional properties returned by " + activityName + ".  Content is: " + additionalProperties);
        }
    }
}

