/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.governanceserver.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.governanceserver.fvt.duplicates.CreateDuplicatesTest;
import org.odpi.openmetadata.accessservices.governanceserver.fvt.engines.CreateEngineTest;
import org.odpi.openmetadata.accessservices.governanceserver.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class GovernanceServerOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = GovernanceServerOMASFVTSuite.getUrl((String[])args);
            String serverName = GovernanceServerOMASFVTSuite.getServerName((String[])args);
            String userId = GovernanceServerOMASFVTSuite.getUserId((String[])args);
            GovernanceServerOMASFVTSuite fvtSuite = new GovernanceServerOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = CreateDuplicatesTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateEngineTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

