/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceServerEventClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String callerId = "TestCallerId";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceCode(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceName(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceDescription(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceWiki());
        thisTest.testGovernanceEngineEventClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testGovernanceEngineEventClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        GAFRESTClient restClient = new GAFRESTClient(serverName, serverPlatformRootURL);
        new GovernanceServerEventClient(serverName, serverPlatformRootURL, (OCFRESTClient)restClient, 100, auditLog, callerId);
    }
}

