/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceserver.connectors.outtopic.GovernanceServerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.governanceserver.connectors.outtopic.GovernanceServerOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.governanceserver.ffdc.GovernanceServerAuditCode;
import org.odpi.openmetadata.accessservices.governanceserver.ffdc.GovernanceServerErrorCode;
import org.odpi.openmetadata.accessservices.governanceserver.outtopic.GovernanceServerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.governanceserver.outtopic.GovernanceServerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.governanceserver.server.GovernanceServerInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceServerAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private GovernanceServerInstance instance = null;
    private String serverName = null;
    private GovernanceServerOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", GovernanceServerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = super.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = super.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = super.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new GovernanceServerInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
            if (outTopicEventBusConnection != null) {
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getServerSideOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceFullName(), GovernanceServerOutTopicServerProvider.class.getName(), auditLog);
                GovernanceServerOutTopicServerConnector outTopicServerConnector = (GovernanceServerOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, GovernanceServerOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new GovernanceServerOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog);
                this.registerWithEnterpriseTopic(AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new GovernanceServerOMRSTopicListener(AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceFullName(), this.instance.getEngineActionHandler(), this.eventPublisher, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("initialize", GovernanceServerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}));
        }
        catch (OMAGConfigurationErrorException error) {
            auditLog.logException("initialize", GovernanceServerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", GovernanceServerAuditCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new OMAGConfigurationErrorException(GovernanceServerErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), AccessServiceDescription.GOVERNANCE_SERVER_OMAS.getAccessServiceFullName(), this.serverName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        this.auditLog.logMessage("shutdown", GovernanceServerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

