/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.outtopic;

import org.odpi.openmetadata.accessservices.governanceserver.ffdc.GovernanceServerAuditCode;
import org.odpi.openmetadata.accessservices.governanceserver.outtopic.GovernanceServerOutTopicPublisher;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceServerOMRSTopicListener
extends OMRSTopicListenerBase {
    private final GovernanceServerOutTopicPublisher eventPublisher;
    private final OMRSRepositoryHelper repositoryHelper;
    private final EngineActionHandler<EngineActionElement> engineActionHandler;

    public GovernanceServerOMRSTopicListener(String serviceName, EngineActionHandler<EngineActionElement> engineActionHandler, GovernanceServerOutTopicPublisher eventPublisher, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.engineActionHandler = engineActionHandler;
        this.eventPublisher = eventPublisher;
        this.repositoryHelper = repositoryHelper;
    }

    private boolean processGovernanceEngineEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.GOVERNANCE_ENGINE.typeName)) {
            this.eventPublisher.publishRefreshGovernanceEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationGroupEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_GROUP.typeName)) {
            this.eventPublisher.publishRefreshIntegrationGroupEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationConnectorEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_CONNECTOR.typeName)) {
            this.eventPublisher.publishRefreshIntegrationConnectorEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processGovernanceEngineEvent(String sourceName, EntityProxy entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.GOVERNANCE_ENGINE.typeName)) {
            this.eventPublisher.publishRefreshGovernanceEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getUniqueProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationGroupEvent(String sourceName, EntityProxy entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_GROUP.typeName)) {
            this.eventPublisher.publishRefreshIntegrationGroupEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getUniqueProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationConnectorEvent(String sourceName, EntityProxy entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_CONNECTOR.typeName)) {
            this.eventPublisher.publishRefreshIntegrationConnectorEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getUniqueProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processSupportedGovernanceService(String sourceName, Relationship relationship, String methodName) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName)) {
            EntityProxy governanceEngineEntityProxy = relationship.getEntityOneProxy();
            EntityProxy governanceServiceEntityProxy = relationship.getEntityTwoProxy();
            if (governanceEngineEntityProxy != null) {
                this.eventPublisher.publishRefreshGovernanceServiceEvent(governanceEngineEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceEngineEntityProxy.getUniqueProperties(), methodName), governanceServiceEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.REQUEST_TYPE.name, relationship.getProperties(), methodName));
                return true;
            }
        }
        return false;
    }

    private boolean processRegisteredIntegrationConnector(String sourceName, Relationship relationship, String methodName) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null) {
            EntityProxy integrationConnectorEntityProxy;
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "RegisteredIntegrationConnector")) {
                EntityProxy integrationConnectorEntityProxy2 = relationship.getEntityTwoProxy();
                if (integrationConnectorEntityProxy2 != null) {
                    this.eventPublisher.publishRefreshIntegrationConnectorEvent(integrationConnectorEntityProxy2.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrationConnectorEntityProxy2.getUniqueProperties(), methodName));
                    return true;
                }
            } else if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "CatalogTarget") && (integrationConnectorEntityProxy = relationship.getEntityOneProxy()) != null) {
                this.eventPublisher.publishRefreshIntegrationConnectorEvent(integrationConnectorEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrationConnectorEntityProxy.getUniqueProperties(), methodName));
                return true;
            }
        }
        return false;
    }

    private boolean processEngineActionEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.ENGINE_ACTION.typeName)) {
            EngineActionStatus status = this.engineActionHandler.getActionStatus(OpenMetadataProperty.ACTION_STATUS.name, entity.getProperties());
            if (status == EngineActionStatus.APPROVED) {
                String governanceEngineGUID = this.repositoryHelper.getStringProperty(sourceName, "executorEngineGUID", entity.getProperties(), methodName);
                String governanceEngineName = this.repositoryHelper.getStringProperty(sourceName, "executorEngineName", entity.getProperties(), methodName);
                this.eventPublisher.publishNewEngineAction(governanceEngineGUID, governanceEngineName, entity.getGUID());
            } else if (status == EngineActionStatus.CANCELLED) {
                String governanceEngineGUID = this.repositoryHelper.getStringProperty(sourceName, "executorEngineGUID", entity.getProperties(), methodName);
                String governanceEngineName = this.repositoryHelper.getStringProperty(sourceName, "executorEngineName", entity.getProperties(), methodName);
                this.eventPublisher.publishCancelledEngineAction(governanceEngineGUID, governanceEngineName, entity.getGUID());
            }
            return true;
        }
        return false;
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processNewEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processNewEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processNewEntityEvent")) {
            this.auditLog.logMessage("processNewEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processIntegrationGroupEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processEngineActionEvent(sourceName, newEntity, "processUpdatedEntityEvent")) {
            this.auditLog.logMessage("processUpdatedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{newEntity.getGUID()}));
        }
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processUndoneEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processUndoneEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processUndoneEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processUndoneEntityEvent")) {
            this.auditLog.logMessage("processUndoneEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processClassifiedEntityEvent")) {
            this.auditLog.logMessage("processClassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processClassifiedEntityEvent(proxy)") || this.processIntegrationGroupEvent(sourceName, entity, "processClassifiedEntityEvent(proxy)") || this.processIntegrationConnectorEvent(sourceName, entity, "processClassifiedEntityEvent(proxy)")) {
            this.auditLog.logMessage("processClassifiedEntityEvent(proxy)", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processDeclassifiedEntityEvent")) {
            this.auditLog.logMessage("processDeclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeclassifiedEntityEvent")) {
            this.auditLog.logMessage("processDeclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReclassifiedEntityEvent")) {
            this.auditLog.logMessage("processReclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReclassifiedEntityEvent")) {
            this.auditLog.logMessage("processReclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeletedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeletedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeletedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processDeletedEntityEvent")) {
            this.auditLog.logMessage("processDeletedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processDeletePurgedEntityEvent")) {
            this.auditLog.logMessage("processDeletePurgedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processRestoredEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processRestoredEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processRestoredEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processRestoredEntityEvent")) {
            this.auditLog.logMessage("processRestoredEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReIdentifiedEntityEvent")) {
            this.auditLog.logMessage("processReIdentifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReTypedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReTypedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReTypedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReTypedEntityEvent")) {
            this.auditLog.logMessage("processReTypedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReHomedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReHomedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReHomedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReHomedEntityEvent")) {
            this.auditLog.logMessage("processReHomedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processRefreshEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processRefreshEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processRefreshEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processRefreshEntityEvent")) {
            this.auditLog.logMessage("processRefreshEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processNewRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processNewRelationshipEvent")) {
            this.auditLog.logMessage("processNewRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, newRelationship, "processUpdatedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, newRelationship, "processUpdatedRelationshipEvent")) {
            this.auditLog.logMessage("processUpdatedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{newRelationship.getGUID()}));
        }
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processUndoneRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processUndoneRelationshipEvent")) {
            this.auditLog.logMessage("processUndoneRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processDeletedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processDeletedRelationshipEvent")) {
            this.auditLog.logMessage("processDeletedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletePurgedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processDeletePurgedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processDeletePurgedRelationshipEvent")) {
            this.auditLog.logMessage("processDeletePurgedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processRestoredRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processRestoredRelationshipEvent")) {
            this.auditLog.logMessage("processRestoredRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processReIdentifiedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processReIdentifiedRelationshipEvent")) {
            this.auditLog.logMessage("processReIdentifiedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processReTypedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processReTypedRelationshipEvent")) {
            this.auditLog.logMessage("processReTypedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processReHomedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processReHomedRelationshipEvent")) {
            this.auditLog.logMessage("processReHomedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processRefreshRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processRefreshRelationshipEvent")) {
            this.auditLog.logMessage("processRefreshRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
    }
}

