/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.converters;

import java.util.Map;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworkservices.omf.converters.OpenMetadataStoreConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceServerOMASConverter<B>
extends OpenMetadataStoreConverter<B> {
    public GovernanceServerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected GovernanceActionStatus removeGovernanceActionStatus(String propertyName, InstanceProperties properties) {
        GovernanceActionStatus actionStatus = this.getGovernanceActionStatus(propertyName, properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(propertyName);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return actionStatus;
    }

    private GovernanceActionStatus getGovernanceActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                }
            }
        }
        return governanceActionStatus;
    }
}

