/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.outtopic;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceserver.converters.GovernanceServerOMASConverter;
import org.odpi.openmetadata.accessservices.governanceserver.ffdc.GovernanceServerAuditCode;
import org.odpi.openmetadata.accessservices.governanceserver.outtopic.GovernanceServerOutTopicPublisher;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementVersions;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.omf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceServerOMRSTopicListener
extends OMRSTopicListenerBase {
    private final GovernanceServerOutTopicPublisher eventPublisher;
    private final OMRSRepositoryHelper repositoryHelper;
    private final EngineActionHandler<EngineActionElement> engineActionHandler;
    private final MetadataElementHandler<OpenMetadataElement> metadataElementHandler;
    private final String userId;
    private final String serverName;
    private final GovernanceServerOMASConverter<MetadataElement> converter;

    public GovernanceServerOMRSTopicListener(String serviceName, String serverName, String userId, EngineActionHandler<EngineActionElement> engineActionHandler, MetadataElementHandler<OpenMetadataElement> metadataElementHandler, GovernanceServerOutTopicPublisher eventPublisher, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.metadataElementHandler = metadataElementHandler;
        this.userId = userId;
        this.serverName = serverName;
        this.engineActionHandler = engineActionHandler;
        this.eventPublisher = eventPublisher;
        this.repositoryHelper = repositoryHelper;
        this.converter = new GovernanceServerOMASConverter(repositoryHelper, serviceName, metadataElementHandler.getServerName());
    }

    private boolean processGovernanceEngineEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.GOVERNANCE_ENGINE.typeName)) {
            this.eventPublisher.publishRefreshGovernanceEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationGroupEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_GROUP.typeName)) {
            this.eventPublisher.publishRefreshIntegrationGroupEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationConnectorEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_CONNECTOR.typeName)) {
            this.eventPublisher.publishRefreshIntegrationConnectorEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processGovernanceEngineEvent(String sourceName, EntityProxy entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.GOVERNANCE_ENGINE.typeName)) {
            this.eventPublisher.publishRefreshGovernanceEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getUniqueProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationGroupEvent(String sourceName, EntityProxy entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_GROUP.typeName)) {
            this.eventPublisher.publishRefreshIntegrationGroupEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getUniqueProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processIntegrationConnectorEvent(String sourceName, EntityProxy entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.INTEGRATION_CONNECTOR.typeName)) {
            this.eventPublisher.publishRefreshIntegrationConnectorEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getUniqueProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean processSupportedGovernanceService(String sourceName, Relationship relationship, String methodName) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName)) {
            EntityProxy governanceEngineEntityProxy = relationship.getEntityOneProxy();
            EntityProxy governanceServiceEntityProxy = relationship.getEntityTwoProxy();
            if (governanceEngineEntityProxy != null) {
                this.eventPublisher.publishRefreshGovernanceServiceEvent(governanceEngineEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceEngineEntityProxy.getUniqueProperties(), methodName), governanceServiceEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.REQUEST_TYPE.name, relationship.getProperties(), methodName));
                return true;
            }
        }
        return false;
    }

    private boolean processRegisteredIntegrationConnector(String sourceName, Relationship relationship, String methodName) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null) {
            EntityProxy integrationConnectorEntityProxy;
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.REGISTERED_INTEGRATION_CONNECTOR_RELATIONSHIP.typeName)) {
                EntityProxy integrationConnectorEntityProxy2 = relationship.getEntityTwoProxy();
                if (integrationConnectorEntityProxy2 != null) {
                    this.eventPublisher.publishRefreshIntegrationConnectorEvent(integrationConnectorEntityProxy2.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrationConnectorEntityProxy2.getUniqueProperties(), methodName));
                    return true;
                }
            } else if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.CATALOG_TARGET_RELATIONSHIP.typeName) && (integrationConnectorEntityProxy = relationship.getEntityOneProxy()) != null) {
                this.eventPublisher.publishRefreshIntegrationConnectorEvent(integrationConnectorEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrationConnectorEntityProxy.getUniqueProperties(), methodName));
                return true;
            }
        }
        return false;
    }

    private AttachedClassification getClassification(Classification classification) {
        if (classification != null) {
            AttachedClassification beanClassification = new AttachedClassification();
            this.converter.fillElementControlHeader((ElementControlHeader)beanClassification, (InstanceAuditHeader)classification);
            beanClassification.setClassificationName(classification.getName());
            if (classification.getProperties() != null) {
                beanClassification.setClassificationProperties(this.converter.mapElementProperties(classification.getProperties()));
                beanClassification.setEffectiveFromTime(classification.getProperties().getEffectiveFromTime());
                beanClassification.setEffectiveToTime(classification.getProperties().getEffectiveToTime());
            }
            return beanClassification;
        }
        return null;
    }

    private OpenMetadataRelationship getRelatedElements(Relationship relationship) {
        if (relationship != null) {
            TypeDef typeDef;
            OpenMetadataRelationship openMetadataRelationship = new OpenMetadataRelationship();
            this.converter.fillElementControlHeader((ElementControlHeader)openMetadataRelationship, (InstanceAuditHeader)relationship);
            openMetadataRelationship.setRelationshipGUID(relationship.getGUID());
            openMetadataRelationship.setRelationshipType(this.converter.getElementType((InstanceAuditHeader)relationship));
            if (relationship.getProperties() != null) {
                openMetadataRelationship.setRelationshipProperties(this.converter.mapElementProperties(relationship.getProperties()));
                openMetadataRelationship.setEffectiveFromTime(relationship.getProperties().getEffectiveFromTime());
                openMetadataRelationship.setEffectiveToTime(relationship.getProperties().getEffectiveToTime());
            }
            if (relationship.getEntityOneProxy() != null) {
                openMetadataRelationship.setElementGUIDAtEnd1(relationship.getEntityOneProxy().getGUID());
                OpenMetadataElementStub elementStub = new OpenMetadataElementStub();
                this.fillElementControlHeader((ElementControlHeader)elementStub, (InstanceAuditHeader)relationship.getEntityOneProxy());
                elementStub.setUniqueName(this.getQualifiedName(relationship.getEntityOneProxy().getUniqueProperties()));
                openMetadataRelationship.setElementAtEnd1(elementStub);
            }
            if (relationship.getEntityTwoProxy() != null) {
                openMetadataRelationship.setElementGUIDAtEnd2(relationship.getEntityTwoProxy().getGUID());
            }
            if ((typeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, relationship.getType().getTypeDefName())) instanceof RelationshipDef) {
                RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                openMetadataRelationship.setLabelAtEnd1(relationshipDef.getEndDef1().getAttributeName());
                openMetadataRelationship.setLabelAtEnd2(relationshipDef.getEndDef2().getAttributeName());
            }
            return openMetadataRelationship;
        }
        return null;
    }

    public void fillElementControlHeader(ElementControlHeader elementControlHeader, InstanceAuditHeader header) {
        if (header != null) {
            elementControlHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementControlHeader.setType(this.getElementType(header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementControlHeader.setOrigin(elementOrigin);
            elementControlHeader.setVersions(this.getElementVersions(header));
        }
    }

    protected ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            return switch (instanceStatus) {
                default -> throw new IncompatibleClassChangeError();
                case InstanceStatus.UNKNOWN -> ElementStatus.UNKNOWN;
                case InstanceStatus.DRAFT -> ElementStatus.DRAFT;
                case InstanceStatus.PREPARED -> ElementStatus.PREPARED;
                case InstanceStatus.PROPOSED -> ElementStatus.PROPOSED;
                case InstanceStatus.APPROVED -> ElementStatus.APPROVED;
                case InstanceStatus.REJECTED -> ElementStatus.REJECTED;
                case InstanceStatus.APPROVED_CONCEPT -> ElementStatus.APPROVED_CONCEPT;
                case InstanceStatus.UNDER_DEVELOPMENT -> ElementStatus.UNDER_DEVELOPMENT;
                case InstanceStatus.DEVELOPMENT_COMPLETE -> ElementStatus.DEVELOPMENT_COMPLETE;
                case InstanceStatus.APPROVED_FOR_DEPLOYMENT -> ElementStatus.APPROVED_FOR_DEPLOYMENT;
                case InstanceStatus.STANDBY -> ElementStatus.STANDBY;
                case InstanceStatus.ACTIVE -> ElementStatus.ACTIVE;
                case InstanceStatus.FAILED -> ElementStatus.FAILED;
                case InstanceStatus.DISABLED -> ElementStatus.DISABLED;
                case InstanceStatus.COMPLETE -> ElementStatus.COMPLETE;
                case InstanceStatus.DEPRECATED -> ElementStatus.DEPRECATED;
                case InstanceStatus.DELETED -> ElementStatus.DELETED;
                case InstanceStatus.OTHER -> ElementStatus.OTHER;
            };
        }
        return ElementStatus.UNKNOWN;
    }

    public ElementType getElementType(InstanceAuditHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            String typeDefName = instanceType.getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, typeDefName);
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(typeDefName);
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            elementType.setTypeDescription(typeDef.getDescription());
            List typeDefSuperTypes = this.repositoryHelper.getSuperTypes(this.serviceName, typeDefName);
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    protected ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            return switch (instanceProvenanceType) {
                default -> throw new IncompatibleClassChangeError();
                case InstanceProvenanceType.DEREGISTERED_REPOSITORY -> ElementOriginCategory.DEREGISTERED_REPOSITORY;
                case InstanceProvenanceType.EXTERNAL_SOURCE -> ElementOriginCategory.EXTERNAL_SOURCE;
                case InstanceProvenanceType.EXPORT_ARCHIVE -> ElementOriginCategory.EXPORT_ARCHIVE;
                case InstanceProvenanceType.LOCAL_COHORT -> ElementOriginCategory.LOCAL_COHORT;
                case InstanceProvenanceType.CONTENT_PACK -> ElementOriginCategory.CONTENT_PACK;
                case InstanceProvenanceType.CONFIGURATION -> ElementOriginCategory.CONFIGURATION;
                case InstanceProvenanceType.UNKNOWN -> ElementOriginCategory.UNKNOWN;
            };
        }
        return ElementOriginCategory.UNKNOWN;
    }

    protected ElementVersions getElementVersions(InstanceAuditHeader header) {
        ElementVersions elementVersions = new ElementVersions();
        elementVersions.setCreatedBy(header.getCreatedBy());
        elementVersions.setCreateTime(header.getCreateTime());
        elementVersions.setUpdatedBy(header.getUpdatedBy());
        elementVersions.setUpdateTime(header.getUpdateTime());
        elementVersions.setMaintainedBy(header.getMaintainedBy());
        elementVersions.setVersion(header.getVersion());
        return elementVersions;
    }

    protected String getQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "getQualifiedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, instanceProperties, "getQualifiedName");
        }
        return null;
    }

    private boolean processEngineActionEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), OpenMetadataType.ENGINE_ACTION.typeName)) {
            EngineActionStatus status = this.engineActionHandler.getActionStatus(OpenMetadataProperty.ACTION_STATUS.name, entity.getProperties());
            if (status == EngineActionStatus.APPROVED) {
                String governanceEngineGUID = this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.EXECUTOR_ENGINE_GUID.name, entity.getProperties(), methodName);
                String governanceEngineName = this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.EXECUTOR_ENGINE_NAME.name, entity.getProperties(), methodName);
                this.eventPublisher.publishNewEngineAction(governanceEngineGUID, governanceEngineName, entity.getGUID());
            } else if (status == EngineActionStatus.CANCELLED) {
                String governanceEngineGUID = this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.EXECUTOR_ENGINE_GUID.name, entity.getProperties(), methodName);
                String governanceEngineName = this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.EXECUTOR_ENGINE_NAME.name, entity.getProperties(), methodName);
                this.eventPublisher.publishCancelledEngineAction(governanceEngineGUID, governanceEngineName, entity.getGUID());
            }
            return true;
        }
        return false;
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntityDetail entity, EntityDetail previousEntity, String methodName) {
        if (entity != null) {
            try {
                WatchdogMetadataElementEvent watchdogEvent = new WatchdogMetadataElementEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement((OpenMetadataElement)this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName));
                if (previousEntity != null) {
                    watchdogEvent.setPreviousMetadataElement((OpenMetadataElement)this.metadataElementHandler.getMetadataElementByGUID(this.userId, previousEntity.getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceServerAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceServerAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntitySummary entity, Classification classification, Classification previousClassification, String methodName) {
        if (entity != null) {
            try {
                WatchdogClassificationEvent watchdogEvent = new WatchdogClassificationEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement((OpenMetadataElement)this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName));
                watchdogEvent.setChangedClassification(this.getClassification(classification));
                if (previousClassification != null) {
                    watchdogEvent.setChangedClassification(this.getClassification(previousClassification));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceServerAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceServerAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, Relationship relationship, Relationship previousRelationship, String methodName) {
        if (relationship != null) {
            try {
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityOneProxy().getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName);
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityTwoProxy().getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName);
                WatchdogRelatedElementsEvent watchdogEvent = new WatchdogRelatedElementsEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setRelatedMetadataElements(this.getRelatedElements(relationship));
                if (previousRelationship != null) {
                    watchdogEvent.setPreviousRelatedMetadataElements(this.getRelatedElements(previousRelationship));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceServerAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, relationship.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceServerAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, relationship.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processNewEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processNewEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processNewEntityEvent")) {
            this.auditLog.logMessage("processNewEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_ELEMENT, entity, null, "processNewEntityEvent");
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processIntegrationGroupEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processEngineActionEvent(sourceName, newEntity, "processUpdatedEntityEvent")) {
            this.auditLog.logMessage("processUpdatedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{newEntity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, newEntity, oldEntity, "processUpdatedEntityEvent");
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processUndoneEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processUndoneEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processUndoneEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processUndoneEntityEvent")) {
            this.auditLog.logMessage("processUndoneEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, entity, null, "processUndoneEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        if (!OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName.equals(classification.getName()) && (this.processGovernanceEngineEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processClassifiedEntityEvent"))) {
            this.auditLog.logMessage("processClassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, (EntitySummary)entity, classification, null, "processClassifiedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        if (!OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName.equals(classification.getName()) && (this.processGovernanceEngineEvent(sourceName, entity, "processClassifiedEntityEvent(proxy)") || this.processIntegrationGroupEvent(sourceName, entity, "processClassifiedEntityEvent(proxy)") || this.processIntegrationConnectorEvent(sourceName, entity, "processClassifiedEntityEvent(proxy)"))) {
            this.auditLog.logMessage("processClassifiedEntityEvent(proxy)", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, (EntitySummary)entity, classification, null, "processClassifiedEntityEvent(proxy)");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processDeclassifiedEntityEvent")) {
            this.auditLog.logMessage("processDeclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, (EntitySummary)entity, originalClassification, null, "processDeclassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeclassifiedEntityEvent")) {
            this.auditLog.logMessage("processDeclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, (EntitySummary)entity, originalClassification, null, "processDeclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (!OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName.equals(classification.getName()) && (this.processGovernanceEngineEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReclassifiedEntityEvent"))) {
            this.auditLog.logMessage("processReclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, (EntitySummary)entity, classification, originalClassification, "processReclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (!OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName.equals(classification.getName()) && (this.processGovernanceEngineEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReclassifiedEntityEvent"))) {
            this.auditLog.logMessage("processReclassifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, (EntitySummary)entity, classification, originalClassification, "processReclassifiedEntityEvent");
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeletedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeletedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeletedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processDeletedEntityEvent")) {
            this.auditLog.logMessage("processDeletedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, null, "processDeletedEntityEvent");
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processDeletePurgedEntityEvent")) {
            this.auditLog.logMessage("processDeletePurgedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, null, "processDeletePurgedEntityEvent");
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processRestoredEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processRestoredEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processRestoredEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processRestoredEntityEvent")) {
            this.auditLog.logMessage("processRestoredEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processRestoredEntityEvent");
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReIdentifiedEntityEvent")) {
            this.auditLog.logMessage("processReIdentifiedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processReIdentifiedEntityEvent");
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReTypedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReTypedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReTypedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReTypedEntityEvent")) {
            this.auditLog.logMessage("processReTypedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processReTypedEntityEvent");
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processReHomedEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processReHomedEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processReHomedEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processReHomedEntityEvent")) {
            this.auditLog.logMessage("processReHomedEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processReHomedEntityEvent");
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        if (this.processGovernanceEngineEvent(sourceName, entity, "processRefreshEntityEvent") || this.processIntegrationGroupEvent(sourceName, entity, "processRefreshEntityEvent") || this.processIntegrationConnectorEvent(sourceName, entity, "processRefreshEntityEvent") || this.processEngineActionEvent(sourceName, entity, "processRefreshEntityEvent")) {
            this.auditLog.logMessage("processRefreshEntityEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{entity.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processRefreshEntityEvent");
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processNewRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processNewRelationshipEvent")) {
            this.auditLog.logMessage("processNewRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_RELATIONSHIP, relationship, null, "processNewRelationshipEvent");
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, newRelationship, "processUpdatedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, newRelationship, "processUpdatedRelationshipEvent")) {
            this.auditLog.logMessage("processUpdatedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{newRelationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES, newRelationship, oldRelationship, "processUpdatedRelationshipEvent");
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processUndoneRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processUndoneRelationshipEvent")) {
            this.auditLog.logMessage("processUndoneRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processUndoneRelationshipEvent");
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processDeletedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processDeletedRelationshipEvent")) {
            this.auditLog.logMessage("processDeletedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, null, "processDeletedRelationshipEvent");
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletePurgedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processDeletePurgedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processDeletePurgedRelationshipEvent")) {
            this.auditLog.logMessage("processDeletePurgedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, null, "processDeletePurgedRelationshipEvent");
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processRestoredRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processRestoredRelationshipEvent")) {
            this.auditLog.logMessage("processRestoredRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processRestoredRelationshipEvent");
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processReIdentifiedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processReIdentifiedRelationshipEvent")) {
            this.auditLog.logMessage("processReIdentifiedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processReIdentifiedRelationshipEvent");
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processReTypedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processReTypedRelationshipEvent")) {
            this.auditLog.logMessage("processReTypedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processReTypedRelationshipEvent");
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processReHomedRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processReHomedRelationshipEvent")) {
            this.auditLog.logMessage("processReHomedRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processReHomedRelationshipEvent");
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        if (this.processSupportedGovernanceService(sourceName, relationship, "processRefreshRelationshipEvent") || this.processRegisteredIntegrationConnector(sourceName, relationship, "processRefreshRelationshipEvent")) {
            this.auditLog.logMessage("processRefreshRelationshipEvent", GovernanceServerAuditCode.INTERESTING_EVENT.getMessageDefinition(new String[]{relationship.getGUID()}));
        }
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processRefreshRelationshipEvent");
    }
}

