/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.outtopic;

import org.odpi.openmetadata.accessservices.governanceserver.connectors.outtopic.GovernanceServerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.governanceserver.events.EngineActionEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceServerEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceServerEventType;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.IntegrationConnectorConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.IntegrationGroupConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.accessservices.governanceserver.ffdc.GovernanceServerAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class GovernanceServerOutTopicPublisher {
    private final GovernanceServerOutTopicServerConnector outTopicServerConnector;
    private final AuditLog outTopicAuditLog;
    private final String outTopicName;
    private final String actionDescription = "Out topic event publishing";

    public GovernanceServerOutTopicPublisher(GovernanceServerOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    void publishRefreshIntegrationGroupEvent(String integrationGroupGUID, String integrationGroupName) {
        String methodName = "publishRefreshIntegrationGroupEvent";
        if (this.outTopicServerConnector != null) {
            try {
                IntegrationGroupConfigurationEvent newEvent = new IntegrationGroupConfigurationEvent();
                newEvent.setEventType(GovernanceServerEventType.REFRESH_INTEGRATION_GROUP_EVENT);
                newEvent.setIntegrationGroupGUID(integrationGroupGUID);
                newEvent.setIntegrationGroupName(integrationGroupName);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.REFRESH_INTEGRATION_DAEMON.getMessageDefinition(new String[]{newEvent.getEventType().getEventTypeName(), integrationGroupName, integrationGroupGUID, OpenMetadataType.INTEGRATION_GROUP.typeName}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishRefreshIntegrationGroupEvent");
            }
        }
    }

    void publishRefreshIntegrationConnectorEvent(String integrationConnectorGUID, String integrationConnectorName) {
        String methodName = "publishRefreshIntegrationConnectorEvent";
        if (this.outTopicServerConnector != null) {
            try {
                IntegrationConnectorConfigurationEvent newEvent = new IntegrationConnectorConfigurationEvent();
                newEvent.setEventType(GovernanceServerEventType.REFRESH_INTEGRATION_CONNECTOR_EVENT);
                newEvent.setIntegrationConnectorGUID(integrationConnectorGUID);
                newEvent.setIntegrationConnectorName(integrationConnectorName);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.REFRESH_INTEGRATION_DAEMON.getMessageDefinition(new String[]{newEvent.getEventType().getEventTypeName(), integrationConnectorName, integrationConnectorGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishRefreshIntegrationConnectorEvent");
            }
        }
    }

    void publishRefreshGovernanceEngineEvent(String governanceEngineGUID, String governanceEngineName) {
        String methodName = "publishRefreshGovernanceEngineEvent";
        if (this.outTopicServerConnector != null) {
            try {
                GovernanceEngineConfigurationEvent newEvent = new GovernanceEngineConfigurationEvent();
                newEvent.setEventType(GovernanceServerEventType.REFRESH_GOVERNANCE_ENGINE_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.REFRESH_GOVERNANCE_ENGINE.getMessageDefinition(new String[]{governanceEngineName, governanceEngineGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishRefreshGovernanceEngineEvent");
            }
        }
    }

    void publishRefreshGovernanceServiceEvent(String governanceEngineGUID, String governanceEngineName, String registeredGovernanceServiceGUID, String governanceRequestType) {
        String methodName = "publishRefreshGovernanceServiceEvent";
        if (this.outTopicServerConnector != null) {
            try {
                GovernanceServiceConfigurationEvent newEvent = new GovernanceServiceConfigurationEvent();
                newEvent.setEventType(GovernanceServerEventType.REFRESH_GOVERNANCE_SERVICE_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                newEvent.setRegisteredGovernanceServiceGUID(registeredGovernanceServiceGUID);
                newEvent.setRequestType(governanceRequestType);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.REFRESH_GOVERNANCE_SERVICE.getMessageDefinition(new String[]{governanceEngineName, governanceEngineGUID, governanceRequestType, registeredGovernanceServiceGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishRefreshGovernanceServiceEvent");
            }
        }
    }

    void publishNewEngineAction(String governanceEngineGUID, String governanceEngineName, String engineActionGUID) {
        String methodName = "publishNewEngineAction";
        if (this.outTopicServerConnector != null) {
            try {
                EngineActionEvent newEvent = new EngineActionEvent();
                newEvent.setEventType(GovernanceServerEventType.REQUESTED_ENGINE_ACTION_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                newEvent.setEngineActionGUID(engineActionGUID);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.NEW_ENGINE_ACTION.getMessageDefinition(new String[]{engineActionGUID, governanceEngineName, governanceEngineGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishNewEngineAction");
            }
        }
    }

    void publishCancelledEngineAction(String governanceEngineGUID, String governanceEngineName, String engineActionGUID) {
        String methodName = "publishCancelledEngineAction";
        if (this.outTopicServerConnector != null) {
            try {
                EngineActionEvent newEvent = new EngineActionEvent();
                newEvent.setEventType(GovernanceServerEventType.CANCELLED_ENGINE_ACTION_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                newEvent.setEngineActionGUID(engineActionGUID);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.CANCELLED_ENGINE_ACTION.getMessageDefinition(new String[]{engineActionGUID, governanceEngineName, governanceEngineGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishCancelledEngineAction");
            }
        }
    }

    void publishWatchdogEvent(WatchdogGovernanceEvent watchdogGovernanceEvent) {
        String methodName = "publishWatchdogEvent";
        if (this.outTopicServerConnector != null) {
            try {
                WatchdogGovernanceServiceEvent newEvent = new WatchdogGovernanceServiceEvent();
                newEvent.setEventType(GovernanceServerEventType.WATCHDOG_GOVERNANCE_SERVICE_EVENT);
                newEvent.settWatchdogGovernanceEvent(watchdogGovernanceEvent);
                this.outTopicServerConnector.sendEvent((GovernanceServerEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.WATCHDOG_EVENT.getMessageDefinition(new String[]{watchdogGovernanceEvent.getEventType().getName()}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishWatchdogEvent");
            }
        }
    }

    private void logUnexpectedPublishingException(Exception error, String methodName) {
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logException(methodName, GovernanceServerAuditCode.OUT_TOPIC_FAILURE.getMessageDefinition(new String[]{this.outTopicName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceServerAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic event publishing", GovernanceServerAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

