/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceserver.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceserver.server.GovernanceServerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-server/users/{userId}"})
@Tag(name="Metadata Access Server: Governance Server OMAS", description="The Governance Server Open Metadata Access Service (OMAS) provides support for supporting running governance servers.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/governance-server/overview/"))
public class GovernanceServerOMASResource {
    private final GovernanceServerRESTServices restAPI = new GovernanceServerRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    @Operation(summary="getOutTopicConnection", description="Return the connection object for the Governance Server OMAS's out topic.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/out-topic/"))
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records/{governanceService}"})
    @Operation(summary="logAssetAuditMessage", description="Log an audit message about an asset.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/audit-log/"))
    public VoidResponse logAssetAuditMessage(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String governanceService, @RequestBody String message) {
        return this.restAPI.logAssetAuditMessage(serverName, userId, assetGUID, governanceService, message);
    }
}

