/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples.subjectareas;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.client.SubjectAreaManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SubjectAreaProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.samples.subjectareas.SubjectAreaSampleDefinitions;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.http.HttpHelper;

public class CreateSubjectAreasSample {
    private String serverName;
    private String serverURLRoot;
    private String clientUserId;
    private Map<String, String> subjectAreaMap = new HashMap<String, String>();
    private SubjectAreaManager client = null;

    public CreateSubjectAreasSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void createSubjectAreaDefinition(String subjectAreaDefinitionName, String parentName, String displayName, String description, String scope, String usage, int domainIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        System.out.println("------------------------------------------------------------------------");
        System.out.println(subjectAreaDefinitionName);
        System.out.println("------------------------------------------------------------------------");
        System.out.println(" ==> qualifiedName: " + subjectAreaDefinitionName);
        System.out.println(" ==> displayName:   " + displayName);
        System.out.println(" ==> description:   " + description);
        System.out.println(" ==> scope:         " + scope);
        System.out.println(" ==> usage:         " + usage);
        System.out.println(" ==> domain:        " + domainIdentifier);
        System.out.println(" ");
        SubjectAreaProperties properties = new SubjectAreaProperties();
        properties.setQualifiedName(subjectAreaDefinitionName);
        properties.setDisplayName(displayName);
        properties.setDescription(description);
        properties.setScope(scope);
        properties.setUsage(usage);
        properties.setDomainIdentifier(domainIdentifier);
        String subjectAreaGUID = this.client.createSubjectArea(this.clientUserId, properties);
        if (parentName != null) {
            this.client.linkSubjectAreasInHierarchy(this.clientUserId, this.subjectAreaMap.get(parentName), subjectAreaGUID);
        }
        this.subjectAreaMap.put(subjectAreaDefinitionName, subjectAreaGUID);
    }

    public void run() {
        try {
            SubjectAreaSampleDefinitions[] subjectAreaDefinitions;
            this.client = new SubjectAreaManager(this.serverName, this.serverURLRoot);
            for (SubjectAreaSampleDefinitions definition : subjectAreaDefinitions = SubjectAreaSampleDefinitions.values()) {
                this.createSubjectAreaDefinition(definition.getSubjectAreaName(), definition.getParentName(), definition.getDisplayName(), definition.getDescription(), definition.getScope(), definition.getUsage(), definition.getDomain());
            }
        }
        catch (Exception error) {
            System.out.println("There was an exception when calling the SubjectAreaManager client.  Error message is: " + error.getMessage());
        }
    }

    public static void main(String[] args) {
        String serverName = "cocoMDS2";
        String serverURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("Create Subject Area Definitions Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        HttpHelper.noStrictSSLIfConfigured();
        try {
            CreateSubjectAreasSample sample = new CreateSubjectAreasSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

