/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples.subjectareas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDefinitionManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceMetricsManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramReviewManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.SubjectAreaManager;
import org.odpi.openmetadata.accessservices.governanceprogram.samples.subjectareas.SubjectAreaSampleDefinitions;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDefinitionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceMetricElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SubjectAreaDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SubjectAreaElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDefinitionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceMetricProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaProperties;
import org.odpi.openmetadata.http.HttpHelper;

public class CreateSubjectAreasSample {
    private final String serverName;
    private final String serverURLRoot;
    private final String clientUserId;
    private final Map<String, String> subjectAreaMap = new HashMap<String, String>();
    private SubjectAreaManager subjectAreaManager = null;
    private GovernanceMetricsManager metricsManager = null;
    private GovernanceDefinitionManager definitionManager = null;
    private GovernanceProgramReviewManager reviewManager = null;

    public CreateSubjectAreasSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void createSubjectAreaDefinition(String subjectAreaDefinitionName, String parentName, String displayName, String description, String scope, String usage, int domainIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SubjectAreaDefinition subjectAreaDefinition;
        System.out.println("------------------------------------------------------------------------");
        System.out.println(subjectAreaDefinitionName);
        System.out.println("------------------------------------------------------------------------");
        System.out.println(" ==> subjectAreaName: " + subjectAreaDefinitionName);
        System.out.println(" ==> displayName:     " + displayName);
        System.out.println(" ==> description:     " + description);
        System.out.println(" ==> scope:           " + scope);
        System.out.println(" ==> usage:           " + usage);
        System.out.println(" ==> domain:          " + domainIdentifier);
        System.out.println(" ");
        SubjectAreaProperties properties = new SubjectAreaProperties();
        properties.setQualifiedName("SubjectAreaDefinition:" + subjectAreaDefinitionName);
        properties.setSubjectAreaName(subjectAreaDefinitionName);
        properties.setDisplayName(displayName);
        properties.setDescription(description);
        properties.setScope(scope);
        properties.setUsage(usage);
        properties.setDomainIdentifier(domainIdentifier);
        String subjectAreaGUID = this.subjectAreaManager.createSubjectArea(this.clientUserId, properties);
        if (parentName != null) {
            System.out.println("Subject area " + subjectAreaDefinitionName + " parent " + parentName + " has GUID of " + this.subjectAreaMap.get(parentName));
            this.subjectAreaManager.linkSubjectAreasInHierarchy(this.clientUserId, this.subjectAreaMap.get(parentName), subjectAreaGUID);
        }
        if ((subjectAreaDefinition = this.subjectAreaManager.getSubjectAreaDefinitionByGUID(this.clientUserId, subjectAreaGUID)) == null) {
            this.errorExit("No definition returned for " + subjectAreaDefinitionName + " with GUID " + subjectAreaGUID);
        } else if (subjectAreaDefinition.getElementHeader() == null) {
            this.errorExit("No header  returned for " + subjectAreaDefinitionName + " with GUID " + subjectAreaGUID + ": " + subjectAreaDefinition);
        } else if (!subjectAreaGUID.equals(subjectAreaDefinition.getElementHeader().getGUID())) {
            this.errorExit("GUID returned for " + subjectAreaDefinitionName + " is not " + subjectAreaGUID + ": " + subjectAreaDefinition);
        } else if (!subjectAreaDefinitionName.equals(subjectAreaDefinition.getProperties().getSubjectAreaName())) {
            this.errorExit("Unexpected subject area name returned for " + subjectAreaDefinitionName + ": " + subjectAreaDefinition);
        } else if (parentName != null) {
            SubjectAreaDefinition parentSubjectAreaDefinition;
            if (!this.subjectAreaMap.get(parentName).equals(subjectAreaDefinition.getParentSubjectAreaGUID())) {
                this.errorExit("GUID returned for parent " + parentName + " is not " + this.subjectAreaMap.get(parentName) + ": " + subjectAreaDefinition);
            }
            if ((parentSubjectAreaDefinition = this.subjectAreaManager.getSubjectAreaDefinitionByGUID(this.clientUserId, this.subjectAreaMap.get(parentName))).getNestedSubjectAreaGUIDs() == null || parentSubjectAreaDefinition.getNestedSubjectAreaGUIDs().isEmpty()) {
                this.errorExit("No children returned for parent " + parentName + ": " + parentSubjectAreaDefinition);
            } else {
                boolean found = false;
                for (String childGUID : parentSubjectAreaDefinition.getNestedSubjectAreaGUIDs()) {
                    if (!subjectAreaGUID.equals(childGUID)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.errorExit("No child of " + subjectAreaGUID + " returned for parent " + parentName + ": " + parentSubjectAreaDefinition);
                }
            }
        } else if (subjectAreaDefinition.getParentSubjectAreaGUID() != null) {
            this.errorExit("Unexpected parent " + subjectAreaDefinition.getParentSubjectAreaGUID() + " returned: " + subjectAreaDefinition);
        }
        this.subjectAreaMap.put(subjectAreaDefinitionName, subjectAreaGUID);
        System.out.println("Mapped " + subjectAreaDefinitionName + " to: " + subjectAreaGUID);
    }

    private void reviewSubjectAreas() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SubjectAreaElement subjectAreaDefinition;
        for (String string : this.subjectAreaMap.keySet()) {
            subjectAreaDefinition = this.subjectAreaManager.getSubjectAreaByName(this.clientUserId, string);
            if (subjectAreaDefinition == null) {
                this.errorExit("No subject area definition returned for: " + string);
                continue;
            }
            if (this.subjectAreaMap.get(string).equals(subjectAreaDefinition.getElementHeader().getGUID())) continue;
            this.errorExit("Unexpected subject area returned for subject area name " + string + ": " + subjectAreaDefinition);
        }
        for (String string : this.subjectAreaMap.keySet()) {
            subjectAreaDefinition = this.subjectAreaManager.getSubjectAreaByGUID(this.clientUserId, this.subjectAreaMap.get(string));
            if (subjectAreaDefinition == null) {
                this.errorExit("No subject area definition returned for: " + this.subjectAreaMap.get(string));
                continue;
            }
            if (this.subjectAreaMap.get(string).equals(subjectAreaDefinition.getElementHeader().getGUID())) continue;
            this.errorExit("Unexpected subject area returned for subject area GUID " + this.subjectAreaMap.get(string) + ": " + subjectAreaDefinition);
        }
        ArrayList<String> productSubjectAreaNames = new ArrayList<String>();
        for (SubjectAreaSampleDefinitions sampleDefinition : SubjectAreaSampleDefinitions.values()) {
            if (!sampleDefinition.getSubjectAreaName().contains("Product")) continue;
            System.out.println("Adding " + sampleDefinition.getSubjectAreaName() + " to the product assurance domain.");
            SubjectAreaProperties updateProperties = new SubjectAreaProperties();
            updateProperties.setDomainIdentifier(8);
            this.subjectAreaManager.updateSubjectArea(this.clientUserId, this.subjectAreaMap.get(sampleDefinition.getSubjectAreaName()), true, updateProperties);
            productSubjectAreaNames.add(sampleDefinition.getSubjectAreaName());
        }
        List list = this.subjectAreaManager.getSubjectAreasForDomain(this.clientUserId, 8, 0, 0);
        if (list == null || list.isEmpty()) {
            this.errorExit("No product subject areas");
        } else if (list.size() != productSubjectAreaNames.size()) {
            this.errorExit("No product subject areas");
        } else {
            for (String name : productSubjectAreaNames) {
                boolean found = false;
                for (SubjectAreaElement subjectAreaElement : list) {
                    if (!name.equals(subjectAreaElement.getProperties().getSubjectAreaName())) continue;
                    found = true;
                    if (this.subjectAreaMap.get(name).equals(subjectAreaElement.getElementHeader().getGUID())) continue;
                    this.errorExit("Unexpected product subject area: " + name);
                }
                if (found) continue;
                this.errorExit("Missing product subject area: " + name);
            }
        }
    }

    private void accessSubjectAreaMembers() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceDriverTypeName = "BusinessImperative";
        String governanceDriverDocId = "GOV-BUS-001";
        String governanceDriverTitle = "Many regulations require accurate reporting.";
        String governancePolicyTypeName = "GovernancePrinciple";
        String governancePolicyDocId = "GOV-DATA-001";
        String governancePolicyTitle = "All critical data elements should be defined and controlled.";
        boolean governancePolicyDomain = true;
        String governanceControl1TypeName = "OrganizationalControl";
        String governanceControl1DocId = "GOV-SUBJECT-AREA-001";
        String governanceControl1Title = "Use subject areas to manage the definitions of critical data items.";
        boolean governanceControl1Domain = true;
        String governanceControl2TypeName = "TechnicalControl";
        String governanceControl2DocId = "GOV-METRICS-001";
        String governanceControl2Title = "Implement governance metrics using defined governance processes/rules.";
        boolean governanceControl2Domain = false;
        GovernanceDefinitionProperties governanceDefinitionProperties = new GovernanceDefinitionProperties();
        governanceDefinitionProperties.setTypeName("BusinessImperative");
        governanceDefinitionProperties.setDocumentIdentifier("GOV-BUS-001");
        governanceDefinitionProperties.setTitle("Many regulations require accurate reporting.");
        String governanceDriverGUID = this.definitionManager.createGovernanceDefinition(this.clientUserId, governanceDefinitionProperties, GovernanceDefinitionStatus.ACTIVE);
        governanceDefinitionProperties = new GovernanceDefinitionProperties();
        governanceDefinitionProperties.setTypeName("GovernancePrinciple");
        governanceDefinitionProperties.setDocumentIdentifier("GOV-DATA-001");
        governanceDefinitionProperties.setTitle("All critical data elements should be defined and controlled.");
        governanceDefinitionProperties.setDomainIdentifier(1);
        String governancePolicyGUID = this.definitionManager.createGovernanceDefinition(this.clientUserId, governanceDefinitionProperties, GovernanceDefinitionStatus.ACTIVE);
        this.definitionManager.setupSupportingDefinition(this.clientUserId, governanceDriverGUID, governancePolicyGUID, "GovernanceResponse", null);
        governanceDefinitionProperties = new GovernanceDefinitionProperties();
        governanceDefinitionProperties.setTypeName("OrganizationalControl");
        governanceDefinitionProperties.setDocumentIdentifier("GOV-SUBJECT-AREA-001");
        governanceDefinitionProperties.setTitle("Use subject areas to manage the definitions of critical data items.");
        governanceDefinitionProperties.setDomainIdentifier(1);
        String governanceControl1GUID = this.definitionManager.createGovernanceDefinition(this.clientUserId, governanceDefinitionProperties, GovernanceDefinitionStatus.ACTIVE);
        this.definitionManager.setupSupportingDefinition(this.clientUserId, governancePolicyGUID, governanceControl1GUID, "GovernanceImplementation", null);
        governanceDefinitionProperties = new GovernanceDefinitionProperties();
        governanceDefinitionProperties.setTypeName("TechnicalControl");
        governanceDefinitionProperties.setDocumentIdentifier("GOV-METRICS-001");
        governanceDefinitionProperties.setTitle("Implement governance metrics using defined governance processes/rules.");
        governanceDefinitionProperties.setDomainIdentifier(0);
        String governanceControl2GUID = this.definitionManager.createGovernanceDefinition(this.clientUserId, governanceDefinitionProperties, GovernanceDefinitionStatus.ACTIVE);
        this.definitionManager.setupSupportingDefinition(this.clientUserId, governancePolicyGUID, governanceControl2GUID, "GovernanceImplementation", null);
        this.definitionManager.linkPeerDefinitions(this.clientUserId, governanceControl1GUID, governanceControl2GUID, "GovernanceControlLink", null);
        GovernanceDefinitionGraph governanceDefinitionGraph = this.reviewManager.getGovernanceDefinitionInContext(this.clientUserId, governancePolicyGUID);
        if (governanceDefinitionGraph.getParents() == null || governanceDefinitionGraph.getChildren() == null || governanceDefinitionGraph.getPeers() != null || governanceDefinitionGraph.getElementHeader() == null || governanceDefinitionGraph.getProperties() == null) {
            System.out.println("Unexpected policy governance definition graph: " + governanceDefinitionGraph);
        }
        if ((governanceDefinitionGraph = this.reviewManager.getGovernanceDefinitionInContext(this.clientUserId, governanceDriverGUID)).getParents() != null || governanceDefinitionGraph.getChildren() == null || governanceDefinitionGraph.getPeers() != null || governanceDefinitionGraph.getElementHeader() == null || governanceDefinitionGraph.getProperties() == null) {
            System.out.println("Unexpected driver governance definition graph: " + governanceDefinitionGraph);
        }
        if ((governanceDefinitionGraph = this.reviewManager.getGovernanceDefinitionInContext(this.clientUserId, governanceControl1GUID)).getParents() == null || governanceDefinitionGraph.getChildren() != null || governanceDefinitionGraph.getPeers() == null || governanceDefinitionGraph.getElementHeader() == null || governanceDefinitionGraph.getProperties() == null) {
            System.out.println("Unexpected control1 governance definition graph: " + governanceDefinitionGraph);
        }
        for (String subjectAreaGUID : this.subjectAreaMap.values()) {
            this.subjectAreaManager.setupGovernedBy(this.clientUserId, subjectAreaGUID, null, governanceControl1GUID);
        }
        List governedElements = this.subjectAreaManager.getGovernedElements(this.clientUserId, governanceControl1GUID, 0, 0);
        if (governedElements == null || governedElements.isEmpty()) {
            this.errorExit("No governed elements for governance control 1: " + governanceControl1GUID);
        } else {
            ArrayList<String> missingLinks = new ArrayList<String>();
            for (String subjectAreaGUID : this.subjectAreaMap.values()) {
                boolean found = false;
                for (RelatedElement relatedElement : governedElements) {
                    if (!subjectAreaGUID.equals(relatedElement.getRelatedElement().getGUID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missingLinks.add(subjectAreaGUID);
            }
            if (!missingLinks.isEmpty()) {
                this.errorExit("Missing governed elements for governance control 1: " + missingLinks);
            }
        }
        String metricName = "Trial Coverage";
        String metricDescription = "The estimated proportion of the population covered by a clinical trial.";
        String measurement = "Proportion of genome covered by trial participants.";
        String target = "80%";
        int domainIdentifier = 8;
        GovernanceMetricProperties metricProperties = new GovernanceMetricProperties();
        metricProperties.setQualifiedName("GovernanceMetric:Trial Coverage");
        metricProperties.setDisplayName("Trial Coverage");
        metricProperties.setDescription("The estimated proportion of the population covered by a clinical trial.");
        metricProperties.setMeasurement("Proportion of genome covered by trial participants.");
        metricProperties.setTarget("80%");
        metricProperties.setDomainIdentifier(8);
        String metricGUID = this.metricsManager.createGovernanceMetric(this.clientUserId, metricProperties);
        SubjectAreaClassificationProperties subjectAreaClassificationProperties = new SubjectAreaClassificationProperties();
        subjectAreaClassificationProperties.setSubjectAreaName(SubjectAreaSampleDefinitions.PRODUCT.getSubjectAreaName());
        this.subjectAreaManager.addSubjectAreaMemberClassification(this.clientUserId, metricGUID, subjectAreaClassificationProperties);
        GovernanceMetricElement metricElement = this.metricsManager.getGovernanceMetricByGUID(this.clientUserId, metricGUID);
        if (!metricGUID.equals(metricElement.getElementHeader().getGUID())) {
            this.errorExit("GUID returned for Trial Coverage is not " + metricGUID + ": " + metricElement);
        }
        if (!"Trial Coverage".equals(metricElement.getProperties().getDisplayName())) {
            this.errorExit("Unexpected metric name returned for Trial Coverage: " + metricElement);
        }
        if (metricElement.getElementHeader().getClassifications() != null) {
            boolean found = false;
            for (ElementClassification classification : metricElement.getElementHeader().getClassifications()) {
                if (!"SubjectArea".equals(classification.getClassificationName())) continue;
                found = true;
                Map properties = classification.getClassificationProperties();
                if (properties == null || properties.isEmpty()) {
                    this.errorExit("No SubjectArea classification properties returned for Trial Coverage: " + metricElement);
                    continue;
                }
                Object retrievedSubjectAreaProperty = properties.get("name");
                if (retrievedSubjectAreaProperty == null) {
                    this.errorExit("No SubjectArea name property returned for Trial Coverage: " + metricElement);
                    continue;
                }
                if (SubjectAreaSampleDefinitions.PRODUCT.getSubjectAreaName().equals(retrievedSubjectAreaProperty.toString())) continue;
                this.errorExit("Unexpected SubjectArea name property (" + retrievedSubjectAreaProperty + ") returned for Trial Coverage: " + metricElement);
            }
            if (!found) {
                this.errorExit("No subject area classification of " + SubjectAreaSampleDefinitions.PRODUCT.getSubjectAreaName() + " returned for metric Trial Coverage: " + metricElement);
            }
        } else {
            this.errorExit("No classifications for Trial Coverage: " + metricElement);
        }
        List members = this.subjectAreaManager.getMembersOfSubjectArea(this.clientUserId, SubjectAreaSampleDefinitions.PRODUCT.getSubjectAreaName(), 0, 0);
        if (members == null || members.isEmpty()) {
            this.errorExit("No classified elements for subject area " + SubjectAreaSampleDefinitions.PRODUCT.getSubjectAreaName());
        }
    }

    private void errorExit(String errorMessage) {
        System.out.println(errorMessage);
        System.exit(-1);
    }

    public void run() throws Exception {
        try {
            SubjectAreaSampleDefinitions[] subjectAreaDefinitions;
            this.subjectAreaManager = new SubjectAreaManager(this.serverName, this.serverURLRoot);
            this.metricsManager = new GovernanceMetricsManager(this.serverName, this.serverURLRoot);
            this.definitionManager = new GovernanceDefinitionManager(this.serverName, this.serverURLRoot);
            this.reviewManager = new GovernanceProgramReviewManager(this.serverName, this.serverURLRoot);
            for (SubjectAreaSampleDefinitions definition : subjectAreaDefinitions = SubjectAreaSampleDefinitions.values()) {
                this.createSubjectAreaDefinition(definition.getSubjectAreaName(), definition.getParentName(), definition.getDisplayName(), definition.getDescription(), definition.getScope(), definition.getUsage(), definition.getDomain());
            }
            this.reviewSubjectAreas();
            this.accessSubjectAreaMembers();
        }
        catch (Exception error) {
            System.out.println("There was an exception when calling the SubjectAreaManager client.  Error message is: " + error.getMessage());
            throw error;
        }
    }

    public static void main(String[] args) {
        String serverName = "fvtMDS";
        String serverURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("Create Subject Area Definitions Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            CreateSubjectAreasSample sample = new CreateSubjectAreasSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

